/**
 * Copyright 2011-2015 John Ericksen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.parceler;

/**
 * @author John Ericksen
 */
public interface TypeRangeParcelConverter<L, U extends L> {

    /**
     * Write the given input parameter to the destinationParcel.
     *
     * @param input U instance
     * @param parcel Parcel to write to
     */
    void toParcel(L input, android.os.Parcel parcel);

    /**
     * Generates an instance from the values provided in the given parcel.
     *
     * @param parcel Parcel to read from
     * @return instance of the mapped class.
     */
    U fromParcel(android.os.Parcel parcel);
}
