/*
 * Decompiled with CFR 0.152.
 */
package org.parceler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.parceler.ParcelerRuntimeException;

public final class InjectionUtil {
    public static final String GET_FIELD_METHOD = "getField";
    public static final String SET_FIELD_METHOD = "setField";
    public static final String CALL_METHOD_METHOD = "callMethod";
    public static final String CALL_CONSTRUCTOR_METHOD = "callConstructor";

    private InjectionUtil() {
    }

    public static <T> T getField(Class<T> returnType, Class<?> targetClass, Object target, String field) {
        try {
            Field declaredField = targetClass.getDeclaredField(field);
            return AccessController.doPrivileged(new GetFieldPrivilegedAction(declaredField, target));
        }
        catch (NoSuchFieldException e) {
            throw new ParcelerRuntimeException("NoSuchFieldException Exception during field injection: " + field + " in " + target.getClass(), e);
        }
        catch (PrivilegedActionException e) {
            throw new ParcelerRuntimeException("PrivilegedActionException Exception during field injection", e);
        }
        catch (Exception e) {
            throw new ParcelerRuntimeException("Exception during field injection", e);
        }
    }

    public static void setField(Class<?> targetClass, Object target, String field, Object value) {
        try {
            Field classField = targetClass.getDeclaredField(field);
            AccessController.doPrivileged(new SetFieldPrivilegedAction(classField, target, value));
        }
        catch (NoSuchFieldException e) {
            throw new ParcelerRuntimeException("NoSuchFieldException Exception during field injection: " + field + " in " + target.getClass(), e);
        }
        catch (PrivilegedActionException e) {
            throw new ParcelerRuntimeException("PrivilegedActionException Exception during field injection", e);
        }
        catch (Exception e) {
            throw new ParcelerRuntimeException("Exception during field injection", e);
        }
    }

    public static <T> T callMethod(Class<T> retClass, Class<?> targetClass, Object target, String method, Class[] argClasses, Object[] args) {
        try {
            Method classMethod = targetClass.getDeclaredMethod(method, argClasses);
            return AccessController.doPrivileged(new SetMethodPrivilegedAction(classMethod, target, args));
        }
        catch (NoSuchMethodException e) {
            throw new ParcelerRuntimeException("Exception during method injection: NoSuchFieldException", e);
        }
        catch (PrivilegedActionException e) {
            throw new ParcelerRuntimeException("PrivilegedActionException Exception during field injection", e);
        }
        catch (Exception e) {
            throw new ParcelerRuntimeException("Exception during field injection", e);
        }
    }

    public static <T> T callConstructor(Class<T> targetClass, Class[] argClasses, Object[] args) {
        Object output;
        try {
            Constructor<T> classConstructor = targetClass.getDeclaredConstructor(argClasses);
            output = AccessController.doPrivileged(new SetConstructorPrivilegedAction(classConstructor, args));
        }
        catch (NoSuchMethodException e) {
            throw new ParcelerRuntimeException("Exception during method injection: NoSuchMethodException", e);
        }
        catch (PrivilegedActionException e) {
            throw new ParcelerRuntimeException("PrivilegedActionException Exception during field injection", e);
        }
        catch (Exception e) {
            throw new ParcelerRuntimeException("Exception during field injection", e);
        }
        return output;
    }

    private static abstract class AccessibleElementPrivilegedAction<T, E extends AccessibleObject>
    implements PrivilegedExceptionAction<T> {
        private final E accessible;

        protected AccessibleElementPrivilegedAction(E accessible) {
            this.accessible = accessible;
        }

        @Override
        public T run() throws Exception {
            boolean previous = ((AccessibleObject)this.accessible).isAccessible();
            ((AccessibleObject)this.accessible).setAccessible(true);
            T output = this.run(this.accessible);
            ((AccessibleObject)this.accessible).setAccessible(previous);
            return output;
        }

        public abstract T run(E var1) throws Exception;
    }

    private static final class SetConstructorPrivilegedAction<T>
    extends AccessibleElementPrivilegedAction<T, Constructor> {
        private final Object[] args;

        private SetConstructorPrivilegedAction(Constructor classConstructor, Object[] args) {
            super(classConstructor);
            this.args = args;
        }

        @Override
        public T run(Constructor classConstructor) throws InvocationTargetException, InstantiationException, IllegalAccessException {
            return classConstructor.newInstance(this.args);
        }
    }

    private static final class SetMethodPrivilegedAction<T>
    extends AccessibleElementPrivilegedAction<T, Method> {
        private final Object target;
        private final Object[] args;

        private SetMethodPrivilegedAction(Method classMethod, Object target, Object[] args) {
            super(classMethod);
            this.target = target;
            this.args = args;
        }

        @Override
        public T run(Method classMethod) throws InvocationTargetException, IllegalAccessException {
            return (T)classMethod.invoke(this.target, this.args);
        }
    }

    private static final class SetFieldPrivilegedAction
    extends AccessibleElementPrivilegedAction<Void, Field> {
        private final Object target;
        private final Object value;

        private SetFieldPrivilegedAction(Field classField, Object target, Object value) {
            super(classField);
            this.target = target;
            this.value = value;
        }

        @Override
        public Void run(Field classField) throws IllegalAccessException {
            classField.set(this.target, this.value);
            return null;
        }
    }

    private static final class GetFieldPrivilegedAction<T>
    extends AccessibleElementPrivilegedAction<T, Field> {
        private final Object target;

        private GetFieldPrivilegedAction(Field classField, Object target) {
            super(classField);
            this.target = target;
        }

        @Override
        public T run(Field classField) throws IllegalAccessException {
            return (T)classField.get(this.target);
        }
    }
}

