/*
 * Decompiled with CFR 0.152.
 */
package org.parceler.converter;

import android.os.Parcel;
import java.util.Map;
import org.parceler.ParcelConverter;

public abstract class MapParcelConverter<K, V>
implements ParcelConverter<Map<K, V>> {
    private static final int NULL = -1;

    @Override
    public void toParcel(Map<K, V> input, Parcel parcel) {
        if (input == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(input.size());
            for (Map.Entry<K, V> entry : input.entrySet()) {
                this.mapKeyToParcel(entry.getKey(), parcel);
                this.mapValueToParcel(entry.getValue(), parcel);
            }
        }
    }

    @Override
    public Map<K, V> fromParcel(Parcel parcel) {
        Map<K, V> map;
        int size = parcel.readInt();
        if (size == -1) {
            map = null;
        } else {
            map = this.createMap();
            for (int i = 0; i < size; ++i) {
                K key = this.mapKeyFromParcel(parcel);
                V value = this.mapValueFromParcel(parcel);
                map.put(key, value);
            }
        }
        return map;
    }

    public abstract Map<K, V> createMap();

    public abstract void mapKeyToParcel(K var1, Parcel var2);

    public abstract void mapValueToParcel(V var1, Parcel var2);

    public abstract K mapKeyFromParcel(Parcel var1);

    public abstract V mapValueFromParcel(Parcel var1);
}

