/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import java.util.Arrays;
import org.parboiled.Action;
import org.parboiled.BaseActions;
import org.parboiled.Rule;
import org.parboiled.annotations.Cached;
import org.parboiled.annotations.DontExtend;
import org.parboiled.annotations.DontLabel;
import org.parboiled.annotations.SuppressNode;
import org.parboiled.annotations.SuppressSubnodes;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.errors.GrammarException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.FirstOfStringsMatcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.StringMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.support.Characters;
import org.parboiled.support.Checks;

public abstract class BaseParser<V>
extends BaseActions<V> {
    public static final Rule EOI = new CharMatcher('\uffff');
    public static final Rule INDENT = new CharMatcher('\ufdd0');
    public static final Rule DEDENT = new CharMatcher('\ufdd1');
    public static final Rule ANY = new AnyMatcher();
    public static final Rule EMPTY = new EmptyMatcher();
    public static final Rule NOTHING = new NothingMatcher();

    public <P extends BaseParser<V>> P newInstance() {
        throw new UnsupportedOperationException("Illegal parser instance, you have to use Parboiled.createParser(...) to create your parser instance!");
    }

    @Cached
    @DontLabel
    public Rule Ch(char c) {
        return new CharMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule IgnoreCase(char c) {
        if (Character.isLowerCase(c) == Character.isUpperCase(c)) {
            return this.Ch(c);
        }
        return new CharIgnoreCaseMatcher(c);
    }

    @Cached
    @DontLabel
    public Rule CharRange(char c, char c2) {
        return c == c2 ? this.Ch(c) : new CharRangeMatcher(c, c2);
    }

    @DontLabel
    public Rule AnyOf(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"characters");
        return this.AnyOf(string.toCharArray());
    }

    @DontLabel
    public Rule AnyOf(char[] cArray) {
        Preconditions.checkArgNotNull((Object)cArray, (String)"characters");
        Preconditions.checkArgument((cArray.length > 0 ? 1 : 0) != 0);
        return cArray.length == 1 ? this.Ch(cArray[0]) : this.AnyOf(Characters.of((char[])cArray));
    }

    @Cached
    @DontLabel
    public Rule AnyOf(Characters characters) {
        Preconditions.checkArgNotNull((Object)characters, (String)"characters");
        if (!characters.isSubtractive() && characters.getChars().length == 1) {
            return this.Ch(characters.getChars()[0]);
        }
        if (characters.equals((Object)Characters.NONE)) {
            return NOTHING;
        }
        return new AnyOfMatcher(characters);
    }

    @DontLabel
    public Rule NoneOf(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"characters");
        return this.NoneOf(string.toCharArray());
    }

    @DontLabel
    public Rule NoneOf(char[] cArray) {
        Preconditions.checkArgNotNull((Object)cArray, (String)"characters");
        Preconditions.checkArgument((cArray.length > 0 ? 1 : 0) != 0);
        boolean bl = false;
        for (char c : cArray) {
            if (c != '\uffff') continue;
            bl = true;
            break;
        }
        if (!bl) {
            char[] cArray2 = new char[cArray.length + 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[cArray.length] = 65535;
            cArray = cArray2;
        }
        return this.AnyOf(Characters.allBut((char[])cArray));
    }

    @DontLabel
    public Rule String(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.String(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule String(char ... cArray) {
        if (cArray.length == 1) {
            return this.Ch(cArray[0]);
        }
        Rule[] ruleArray = new Rule[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            ruleArray[i] = this.Ch(cArray[i]);
        }
        return new StringMatcher(ruleArray, cArray);
    }

    @DontLabel
    public Rule IgnoreCase(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.IgnoreCase(string.toCharArray());
    }

    @Cached
    @SuppressSubnodes
    @DontLabel
    public Rule IgnoreCase(char ... cArray) {
        if (cArray.length == 1) {
            return this.IgnoreCase(cArray[0]);
        }
        Object[] objectArray = new Rule[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            objectArray[i] = this.IgnoreCase(cArray[i]);
        }
        return ((SequenceMatcher)this.Sequence(objectArray)).label("\"" + String.valueOf(cArray) + "\"");
    }

    @DontLabel
    public Rule FirstOf(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.FirstOf(Utils.arrayOf((Object)object, (Object)object2, (Object[])objectArray));
    }

    @Cached
    @DontLabel
    public Rule FirstOf(Object[] objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"rules");
        if (objectArray.length == 1) {
            return this.toRule(objectArray[0]);
        }
        Rule[] ruleArray = this.toRules(objectArray);
        char[][] cArrayArray = new char[objectArray.length][];
        int n = ruleArray.length;
        for (int i = 0; i < n; ++i) {
            Rule rule = ruleArray[i];
            if (!(rule instanceof StringMatcher)) {
                return new FirstOfMatcher(ruleArray);
            }
            cArrayArray[i] = ((StringMatcher)rule).characters;
        }
        return new FirstOfStringsMatcher(ruleArray, (char[][])cArrayArray);
    }

    @Cached
    @DontLabel
    public Rule OneOrMore(Object object) {
        return new OneOrMoreMatcher(this.toRule(object));
    }

    @DontLabel
    public Rule OneOrMore(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.OneOrMore(this.Sequence(object, object2, objectArray));
    }

    @Cached
    @DontLabel
    public Rule Optional(Object object) {
        return new OptionalMatcher(this.toRule(object));
    }

    @DontLabel
    public Rule Optional(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.Optional(this.Sequence(object, object2, objectArray));
    }

    @DontLabel
    public Rule Sequence(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.Sequence(Utils.arrayOf((Object)object, (Object)object2, (Object[])objectArray));
    }

    @Cached
    @DontLabel
    public Rule Sequence(Object[] objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"rules");
        return objectArray.length == 1 ? this.toRule(objectArray[0]) : new SequenceMatcher(this.toRules(objectArray));
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule Test(Object object) {
        Rule rule = this.toRule(object);
        return new TestMatcher(rule);
    }

    @DontLabel
    public Rule Test(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.Test(this.Sequence(object, object2, objectArray));
    }

    @Cached
    @SuppressNode
    @DontLabel
    public Rule TestNot(Object object) {
        Rule rule = this.toRule(object);
        return new TestNotMatcher(rule);
    }

    @DontLabel
    public Rule TestNot(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.TestNot(this.Sequence(object, object2, objectArray));
    }

    @Cached
    @DontLabel
    public Rule ZeroOrMore(Object object) {
        return new ZeroOrMoreMatcher(this.toRule(object));
    }

    @DontLabel
    public Rule ZeroOrMore(Object object, Object object2, Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"moreRules");
        return this.ZeroOrMore(this.Sequence(object, object2, objectArray));
    }

    @Cached
    @DontLabel
    public Rule NTimes(int n, Object object) {
        return this.NTimes(n, object, null);
    }

    @Cached
    @DontLabel
    public Rule NTimes(int n, Object object, Object object2) {
        Preconditions.checkArgNotNull((Object)object, (String)"rule");
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"repetitions must be non-negative");
        switch (n) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return this.toRule(object);
            }
        }
        Object[] objectArray = new Object[object2 == null ? n : n * 2 - 1];
        if (object2 != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i % 2 == 0 ? object : object2;
            }
        } else {
            Arrays.fill(objectArray, object);
        }
        return this.Sequence(objectArray);
    }

    public static Action ACTION(boolean bl) {
        throw new UnsupportedOperationException("ACTION(...) calls can only be used in Rule creating parser methods");
    }

    @DontExtend
    protected Rule fromCharLiteral(char c) {
        return this.Ch(c);
    }

    @DontExtend
    protected Rule fromStringLiteral(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"string");
        return this.fromCharArray(string.toCharArray());
    }

    @DontExtend
    protected Rule fromCharArray(char[] cArray) {
        Preconditions.checkArgNotNull((Object)cArray, (String)"array");
        return this.String(cArray);
    }

    @DontExtend
    public Rule[] toRules(Object ... objectArray) {
        Preconditions.checkArgNotNull((Object)objectArray, (String)"objects");
        Rule[] ruleArray = new Rule[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ruleArray[i] = this.toRule(objectArray[i]);
        }
        return ruleArray;
    }

    @DontExtend
    public Rule toRule(Object object) {
        if (object instanceof Rule) {
            return (Rule)object;
        }
        if (object instanceof Character) {
            return this.fromCharLiteral(((Character)object).charValue());
        }
        if (object instanceof String) {
            return this.fromStringLiteral((String)object);
        }
        if (object instanceof char[]) {
            return this.fromCharArray((char[])object);
        }
        if (object instanceof Action) {
            Action action = (Action)object;
            return new ActionMatcher(action);
        }
        Checks.ensure((!(object instanceof Boolean) ? 1 : 0) != 0, (String)"Rule specification contains an unwrapped Boolean value, if you were trying to specify a parser action wrap the expression with ACTION(...)");
        throw new GrammarException("'" + object + "' cannot be automatically converted to a parser Rule");
    }
}

