/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import org.parboiled.buffers.DefaultInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.IllegalIndentationException;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public class IndentDedentInputBuffer
implements InputBuffer {
    private final DefaultInputBuffer origBuffer;
    private final DefaultInputBuffer convBuffer;
    private int[] indexMap;
    private final boolean strict;

    public IndentDedentInputBuffer(char[] cArray, int n, String string, boolean bl) {
        this.strict = bl;
        Preconditions.checkArgument(n > 0, "tabStop must be > 0");
        Preconditions.checkArgument(string == null || string.indexOf(10) == -1, "lineCommentStart must not contain newlines");
        this.origBuffer = new DefaultInputBuffer(cArray);
        BufferConverter bufferConverter = new BufferConverter(n, string != null ? string.toCharArray() : null);
        this.convBuffer = new DefaultInputBuffer(bufferConverter.builder.getChars());
        this.indexMap = bufferConverter.builder.getIndexMap();
    }

    public char charAt(int n) {
        return this.convBuffer.charAt(n);
    }

    public boolean test(int n, char[] cArray) {
        return this.convBuffer.test(n, cArray);
    }

    public String extract(int n, int n2) {
        return this.origBuffer.extract(this.map(n), this.map(n2));
    }

    public String extract(IndexRange indexRange) {
        return this.origBuffer.extract(this.map(indexRange.start), this.map(indexRange.end));
    }

    public Position getPosition(int n) {
        return this.origBuffer.getPosition(this.map(n));
    }

    public int getOriginalIndex(int n) {
        return this.map(n);
    }

    public String extractLine(int n) {
        return this.origBuffer.extractLine(n);
    }

    public int getLineCount() {
        return this.origBuffer.getLineCount();
    }

    private int map(int n) {
        if (n < 0) {
            return this.indexMap[0];
        }
        if (n < this.indexMap.length) {
            return this.indexMap[n];
        }
        if (this.indexMap.length == 0) {
            return 1;
        }
        return this.indexMap[this.indexMap.length - 1] + 1;
    }

    private class BufferConverter {
        public final BufferBuilder builder = new BufferBuilder();
        private final int tabStop;
        private final char[] lineCommentStart;
        private final IntArrayStack previousLevels = new IntArrayStack();
        private int cursor = 0;
        private char currentChar;

        public BufferConverter(int n, char[] cArray) {
            this.tabStop = n;
            this.lineCommentStart = cArray;
            this.currentChar = IndentDedentInputBuffer.this.origBuffer.charAt(0);
            this.build();
        }

        private void build() {
            this.previousLevels.push(0);
            int n = this.skipIndent();
            while (this.currentChar != '\uffff') {
                int n2 = this.skipLineComment();
                if (this.currentChar != '\n' && this.currentChar != '\uffff') {
                    this.builder.append(this.currentChar);
                    this.advance();
                    continue;
                }
                this.builder.appendNewline(n2);
                this.advance();
                int n3 = this.skipIndent();
                if (n3 > n) {
                    this.previousLevels.push(n);
                    n = n3;
                    this.builder.append('\ufdd0');
                    continue;
                }
                while (n3 < n && n3 <= this.previousLevels.peek()) {
                    n = this.previousLevels.pop();
                    this.builder.append('\ufdd1');
                }
                if (!IndentDedentInputBuffer.this.strict || n3 >= n) continue;
                throw new IllegalIndentationException(IndentDedentInputBuffer.this.origBuffer, IndentDedentInputBuffer.this.origBuffer.getPosition(this.cursor));
            }
            if (this.previousLevels.size() > 1) {
                this.builder.append('\n');
                while (this.previousLevels.size() > 1) {
                    this.previousLevels.pop();
                    this.builder.append('\ufdd1');
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int skipIndent() {
            int n = 0;
            block6: while (true) {
                switch (this.currentChar) {
                    case ' ': {
                        ++n;
                        this.advance();
                        continue block6;
                    }
                    case '\t': {
                        n = (n / this.tabStop + 1) * this.tabStop;
                        this.advance();
                        continue block6;
                    }
                    case '\n': {
                        n = 0;
                        this.advance();
                        continue block6;
                    }
                    case '\uffff': {
                        return 0;
                    }
                    default: {
                        if (this.skipLineComment() == 0) return n;
                        continue block6;
                    }
                }
                break;
            }
        }

        private void advance() {
            this.currentChar = IndentDedentInputBuffer.this.origBuffer.charAt(++this.cursor);
        }

        private int skipLineComment() {
            if (this.lineCommentStart != null && IndentDedentInputBuffer.this.origBuffer.test(this.cursor, this.lineCommentStart)) {
                int n = this.cursor;
                while (this.currentChar != '\n' && this.currentChar != '\uffff') {
                    this.advance();
                }
                return this.cursor - n;
            }
            return 0;
        }

        private class BufferBuilder {
            private final StringBuilder sb = new StringBuilder();
            private final IntArrayStack indexMap = new IntArrayStack();

            private BufferBuilder() {
            }

            private void append(char c) {
                this.indexMap.push(BufferConverter.this.cursor);
                this.sb.append(c);
            }

            private void appendNewline(int n) {
                this.indexMap.push(BufferConverter.this.cursor - n);
                this.sb.append('\n');
            }

            public char[] getChars() {
                char[] cArray = new char[this.sb.length()];
                this.sb.getChars(0, this.sb.length(), cArray, 0);
                return cArray;
            }

            public int[] getIndexMap() {
                return this.indexMap.toArray();
            }
        }
    }
}

