/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import java.util.List;
import org.parboiled.Node;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.Matcher;
import org.parboiled.trees.ImmutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeImpl<V>
extends ImmutableTreeNode<Node<V>>
implements Node<V> {
    private final Matcher matcher;
    private final int startIndex;
    private final int endIndex;
    private final V value;
    private final boolean hasError;

    public NodeImpl(Matcher matcher, List<Node<V>> children, int startIndex, int endIndex, V value, boolean hasError) {
        super(children);
        this.matcher = Preconditions.checkArgNotNull(matcher, "matcher");
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.value = value;
        this.hasError = hasError;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public String getLabel() {
        return this.matcher.getLabel();
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getLabel());
        if (this.value != null) {
            sb.append(", {").append(this.value).append('}');
        }
        sb.append(']');
        if (this.hasError) {
            sb.append('E');
        }
        return StringUtils.escape(sb.toString());
    }
}

