/*
 * Decompiled with CFR 0.152.
 */
package org.padler.gradle.minify.minifier;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.padler.gradle.minify.minifier.options.MinifierOptions;
import org.padler.gradle.minify.minifier.result.Error;
import org.padler.gradle.minify.minifier.result.Report;
import org.padler.gradle.minify.minifier.result.Warning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Minifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(Minifier.class);
    protected final Report report = new Report();

    public void minify(String srcDir, String dstDir) {
        this.minifyInternal(srcDir, dstDir);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(this.createReport());
        }
        if (!this.report.getErrors().isEmpty()) {
            throw new GradleException(this.report.getErrors() + " Errors in " + this.getMinifierName());
        }
    }

    protected void minifyInternal(String srcDir, String dstDir) {
        try (Stream<Path> filesStream = Files.list(Paths.get(srcDir, new String[0])).filter(f -> !f.toString().equals(srcDir));){
            List files = filesStream.collect(Collectors.toList());
            for (Path f2 : files) {
                if (f2.toFile().isFile()) {
                    Path dst = Paths.get(dstDir, new String[0]);
                    String fileName = f2.getFileName().toString();
                    File copy = new File(dst.toString(), fileName);
                    if (Boolean.FALSE.equals(this.getMinifierOptions().getOriginalFileNames())) {
                        fileName = this.rename(fileName);
                    }
                    File dstFile = new File(dst.toString(), fileName);
                    dstFile.getParentFile().mkdirs();
                    if (!this.fileTypeMatches(f2)) continue;
                    Files.copy(f2, copy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.minify(f2.toFile(), dstFile);
                    continue;
                }
                if (!f2.toFile().isDirectory()) continue;
                String newDstDir = dstDir + "/" + f2.getFileName().toString();
                this.minifyInternal(f2.toString(), newDstDir);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void minify(File srcFile, File dstFile) {
        try {
            this.minifyFile(srcFile, dstFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String createReport() {
        StringBuilder reportStr = new StringBuilder();
        for (Error error : this.report.getErrors()) {
            reportStr.append("Error: ");
            reportStr.append(error);
            reportStr.append("\n");
        }
        for (Warning warning : this.report.getWarnings()) {
            reportStr.append("Warning: ");
            reportStr.append(warning);
            reportStr.append("\n");
        }
        reportStr.append(this.getMinifierName()).append(": ").append(this.report.getErrors().size()).append(" error(s), ").append(this.report.getWarnings().size()).append(" warning(s)\n");
        return reportStr.toString();
    }

    protected void writeToFile(File dstFile, String string) {
        StandardOpenOption create = StandardOpenOption.CREATE;
        StandardOpenOption write = StandardOpenOption.WRITE;
        StandardOpenOption truncateExisting = StandardOpenOption.TRUNCATE_EXISTING;
        try {
            Files.write(dstFile.toPath(), string.getBytes(), create, write, truncateExisting);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(46) + 1)).orElse("");
    }

    protected abstract boolean fileTypeMatches(Path var1);

    public abstract MinifierOptions getMinifierOptions();

    protected abstract String getMinifierName();

    protected abstract void minifyFile(File var1, File var2) throws IOException;

    protected abstract String rename(String var1);
}

