/*
 * Decompiled with CFR 0.152.
 */
package org.padler.gradle.minify.minifier;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.padler.gradle.minify.minifier.Minifier;
import org.padler.gradle.minify.minifier.RelativePathLocationMapping;
import org.padler.gradle.minify.minifier.options.JSMinifierOptions;
import org.padler.gradle.minify.minifier.result.Error;
import org.padler.gradle.minify.minifier.result.Warning;

public class JsMinifier
extends Minifier {
    protected JSMinifierOptions minifierOptions = new JSMinifierOptions();
    private CompilerOptions options = new CompilerOptions();

    @Override
    protected void minifyFile(File srcFile, File dstFile) throws IOException {
        Compiler compiler = new Compiler();
        this.setOptions();
        List externs = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)new CompilerOptions().getEnvironment());
        SourceFile sourceFile = SourceFile.fromFile((String)srcFile.getAbsolutePath());
        File sourcemapFile = null;
        if (Boolean.TRUE.equals(this.minifierOptions.getCreateSoureMaps())) {
            sourcemapFile = new File(dstFile.getAbsolutePath() + ".map");
            this.options.setSourceMapOutputPath(sourcemapFile.getAbsolutePath());
            this.options.setSourceMapLocationMappings(Collections.singletonList(new RelativePathLocationMapping()));
        }
        Result result = compiler.compile(externs, (List)ImmutableList.of((Object)sourceFile), this.options);
        if (result.success) {
            String source = compiler.toSource();
            if (Boolean.TRUE.equals(this.minifierOptions.getCreateSoureMaps())) {
                StringBuilder sourceMapContent = new StringBuilder();
                result.sourceMap.appendTo((Appendable)sourceMapContent, dstFile.getName());
                this.writeToFile(sourcemapFile, sourceMapContent.toString());
                source = source + "\n//# sourceMappingURL=" + sourcemapFile.getName();
            }
            this.writeToFile(dstFile, source);
        } else {
            for (JSError error : result.errors) {
                this.report.add(new Error(error));
            }
            for (JSError warning : result.warnings) {
                this.report.add(new Warning(warning));
            }
        }
    }

    private void setOptions() {
        this.minifierOptions.getCompilationLevel().setOptionsForCompilationLevel(this.options);
        this.options.setEnvironment(this.minifierOptions.getEnv());
        if (this.minifierOptions.getLanguageIn() != null) {
            this.options.setLanguageIn(this.minifierOptions.getLanguageIn());
        }
        if (this.minifierOptions.getLanguageOut() != null) {
            this.options.setLanguageOut(this.minifierOptions.getLanguageOut());
        }
        this.minifierOptions.getWarningLevel().setOptionsForWarningLevel(this.options);
        this.options.setExtraAnnotationNames(this.minifierOptions.getExtraAnnotationNames());
        this.options.setStrictModeInput(this.minifierOptions.getStrictModeInput().booleanValue());
        if (Boolean.TRUE.equals(this.minifierOptions.getDebug())) {
            this.minifierOptions.getCompilationLevel().setDebugOptionsForCompilationLevel(this.options);
        }
        this.options.setExportLocalPropertyDefinitions(this.minifierOptions.getExportLocalPropertyDefinitions().booleanValue());
        block5: for (CommandLineRunner.FormattingOption formattingOption : this.minifierOptions.getFormatting()) {
            switch (formattingOption) {
                case PRETTY_PRINT: {
                    this.options.setPrettyPrint(true);
                    continue block5;
                }
                case PRINT_INPUT_DELIMITER: {
                    this.options.printInputDelimiter = true;
                    continue block5;
                }
                case SINGLE_QUOTES: {
                    this.options.setPreferSingleQuotes(true);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown formatting option: " + this);
        }
        this.options.setGenerateExports(this.minifierOptions.getGenerateExports().booleanValue());
        this.options.setRenamePrefixNamespace(this.minifierOptions.getRenamePrefixNamespace());
        this.options.setRenamePrefix(this.minifierOptions.getRenameVariablePrefix());
        this.options.setModuleResolutionMode(this.minifierOptions.getModuleResolution());
        this.options.setProcessCommonJSModules(this.minifierOptions.getProcessCommonJsModules().booleanValue());
        this.options.setPackageJsonEntryNames(this.minifierOptions.getPackageJsonEntryNames());
        this.options.setAngularPass(this.minifierOptions.getAngularPass().booleanValue());
        this.options.setDartPass(this.minifierOptions.getDartPass().booleanValue());
        this.options.setForceLibraryInjection(this.minifierOptions.getForceInjectLibrary());
        this.options.setPolymerVersion(this.minifierOptions.getPolymerVersion());
        this.options.setRewritePolyfills(this.minifierOptions.getRewritePolyfills().booleanValue());
        this.options.setOutputCharset(this.minifierOptions.getCharset());
        this.options.setChecksOnly(this.minifierOptions.getChecksOnly().booleanValue());
        if (this.minifierOptions.getBrowserFeaturesetYear() != null) {
            this.options.setBrowserFeaturesetYear(this.minifierOptions.getBrowserFeaturesetYear());
        }
    }

    @Override
    protected boolean fileTypeMatches(Path f) {
        return "js".equals(this.getExtension(f.toString()));
    }

    @Override
    public JSMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    @Override
    protected String getMinifierName() {
        return "JS Minifier";
    }

    @Override
    protected String rename(String oldName) {
        return oldName.replace(".js", ".min.js");
    }
}

