/*
 * Decompiled with CFR 0.152.
 */
package org.padler.gradle.minify.minifier;

import com.google.common.css.DefaultExitCodeHandler;
import com.google.common.css.ExitCodeHandler;
import com.google.common.css.GssFunctionMapProvider;
import com.google.common.css.IdentitySubstitutionMap;
import com.google.common.css.JobDescription;
import com.google.common.css.JobDescriptionBuilder;
import com.google.common.css.SourceCode;
import com.google.common.css.compiler.ast.BasicErrorManager;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.commandline.DefaultCommandLineCompiler;
import com.google.common.css.compiler.gssfunctions.DefaultGssFunctionMapProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.padler.gradle.minify.minifier.Minifier;
import org.padler.gradle.minify.minifier.options.CSSMinifierOptions;
import org.padler.gradle.minify.minifier.result.Error;
import org.padler.gradle.minify.minifier.result.Warning;

public class CssMinifier
extends Minifier {
    protected CSSMinifierOptions minifierOptions = new CSSMinifierOptions();

    @Override
    protected void minifyFile(File srcFile, File dstFile) {
        try {
            JobDescription job = this.createJobDescription(srcFile);
            DefaultExitCodeHandler exitCodeHandler = new DefaultExitCodeHandler();
            CompilerErrorManager errorManager = new CompilerErrorManager();
            ClosureStylesheetCompiler compiler = new ClosureStylesheetCompiler(job, (ExitCodeHandler)exitCodeHandler, (ErrorManager)errorManager);
            File sourcemapFile = null;
            if (Boolean.TRUE.equals(this.minifierOptions.getCreateSoureMaps())) {
                sourcemapFile = new File(dstFile.getAbsolutePath() + ".map");
            }
            String compilerOutput = compiler.execute(null, sourcemapFile);
            if (sourcemapFile != null) {
                compilerOutput = compilerOutput + "\n/*# sourceMappingURL=" + sourcemapFile.getName() + " */";
            }
            this.writeToFile(dstFile, compilerOutput);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean fileTypeMatches(Path f) {
        return "css".equals(this.getExtension(f.toString()));
    }

    @Override
    public CSSMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    @Override
    protected String getMinifierName() {
        return "CSS Minifier";
    }

    @Override
    protected String rename(String oldName) {
        return oldName.replace(".css", ".min.css");
    }

    private JobDescription createJobDescription(File file) throws IOException {
        JobDescriptionBuilder builder = new JobDescriptionBuilder();
        builder.setInputOrientation(this.minifierOptions.getInputOrientation());
        builder.setOutputOrientation(this.minifierOptions.getOutputOrientation());
        builder.setOutputFormat(this.minifierOptions.getOutputFormat());
        builder.setCopyrightNotice(this.minifierOptions.getCopyrightNotice());
        builder.setTrueConditionNames(this.minifierOptions.getTrueConditionNames());
        builder.setAllowDefPropagation(this.minifierOptions.getAllowDefPropagation().booleanValue());
        builder.setAllowUnrecognizedFunctions(this.minifierOptions.getAllowUnrecognizedFunctions().booleanValue());
        builder.setAllowedNonStandardFunctions(this.minifierOptions.getAllowedNonStandardFunctions());
        builder.setAllowedUnrecognizedProperties(this.minifierOptions.getAllowedUnrecognizedProperties());
        builder.setAllowUnrecognizedProperties(this.minifierOptions.getAllowUnrecognizedProperties().booleanValue());
        builder.setVendor(this.minifierOptions.getVendor());
        builder.setAllowKeyframes(this.minifierOptions.getAllowKeyframes().booleanValue());
        builder.setAllowWebkitKeyframes(this.minifierOptions.getAllowWebkitKeyframes().booleanValue());
        builder.setProcessDependencies(this.minifierOptions.getProcessDependencies().booleanValue());
        builder.setExcludedClassesFromRenaming(this.minifierOptions.getExcludedClassesFromRenaming());
        builder.setSimplifyCss(this.minifierOptions.getSimplifyCss().booleanValue());
        builder.setEliminateDeadStyles(this.minifierOptions.getEliminateDeadStyles().booleanValue());
        builder.setCssSubstitutionMapProvider(IdentitySubstitutionMap::new);
        builder.setCssRenamingPrefix(this.minifierOptions.getCssRenamingPrefix());
        builder.setPreserveComments(this.minifierOptions.getPreserveComments().booleanValue());
        builder.setOutputRenamingMapFormat(this.minifierOptions.getOutputRenamingMapFormat());
        builder.setCompileConstants(this.minifierOptions.getCompileConstants());
        DefaultGssFunctionMapProvider gssFunMapProv = new DefaultGssFunctionMapProvider();
        builder.setGssFunctionMapProvider((GssFunctionMapProvider)gssFunMapProv);
        builder.setSourceMapLevel(this.minifierOptions.getSourceMapLevel());
        builder.setCreateSourceMap(this.minifierOptions.getCreateSoureMaps().booleanValue());
        String fileContents = new String(Files.readAllBytes(file.toPath()));
        builder.addInput(new SourceCode(file.getName(), fileContents));
        return builder.getJobDescription();
    }

    public class ClosureStylesheetCompiler
    extends DefaultCommandLineCompiler {
        public ClosureStylesheetCompiler(JobDescription job, ExitCodeHandler exitCodeHandler, ErrorManager errorManager) {
            super(job, exitCodeHandler, errorManager);
        }

        public String execute(@Nullable File renameFile, @Nullable File sourcemapFile) {
            return super.execute(renameFile, sourcemapFile);
        }
    }

    final class CompilerErrorManager
    extends BasicErrorManager {
        CompilerErrorManager() {
        }

        public void print(String msg) {
        }

        public void report(GssError error) {
            CssMinifier.this.report.add(new Error(error));
        }

        public void reportWarning(GssError warning) {
            CssMinifier.this.report.add(new Warning(warning));
        }
    }
}

