/*
 * Decompiled with CFR 0.152.
 */
package org.padler.gradle.minify;

import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;
import org.padler.gradle.minify.MinifyTaskBase;
import org.padler.gradle.minify.minifier.CssMinifier;
import org.padler.gradle.minify.minifier.JsMinifier;
import org.padler.gradle.minify.minifier.Minifier;
import org.padler.gradle.minify.minifier.options.CSSMinifierOptions;
import org.padler.gradle.minify.minifier.options.JSMinifierOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinifyTask
extends MinifyTaskBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinifyTask.class);

    @TaskAction
    public void minify() {
        String dstDir;
        String srcDir;
        Minifier minifier;
        if (!this.extension.getCssSrcDir().isEmpty() && !this.extension.getCssDstDir().isEmpty()) {
            minifier = this.createCSSMinifier();
            srcDir = this.extension.getCssSrcDir();
            dstDir = this.extension.getCssDstDir();
            minifier.minify(srcDir, dstDir);
        }
        if (!this.extension.getJsSrcDir().isEmpty() && !this.extension.getJsDstDir().isEmpty()) {
            minifier = this.createJsMinifier();
            srcDir = this.extension.getJsSrcDir();
            dstDir = this.extension.getJsDstDir();
            minifier.minify(srcDir, dstDir);
        }
        throw new GradleException("Gradle Minify Plugin is deprecated\nplease use https://github.com/gradle-webtools/gradle-minify-plugin instead.");
    }

    private CssMinifier createCSSMinifier() {
        CssMinifier cssMinifier = new CssMinifier();
        CSSMinifierOptions minifierOptions = cssMinifier.getMinifierOptions();
        minifierOptions.setCreateSoureMaps(this.extension.getCreateCssSourceMaps());
        minifierOptions.setOriginalFileNames(this.extension.getOriginalFileNames());
        minifierOptions.setInputOrientation(this.extension.getCss().getInputOrientation());
        minifierOptions.setOutputOrientation(this.extension.getCss().getOutputOrientation());
        minifierOptions.setOutputFormat(this.extension.getCss().getOutputFormat());
        minifierOptions.setCopyrightNotice(this.extension.getCss().getCopyrightNotice());
        minifierOptions.setTrueConditionNames(this.extension.getCss().getTrueConditionNames());
        minifierOptions.setAllowDefPropagation(this.extension.getCss().getAllowDefPropagation());
        minifierOptions.setAllowUnrecognizedFunctions(this.extension.getCss().getAllowUnrecognizedFunctions());
        minifierOptions.setAllowedNonStandardFunctions(this.extension.getCss().getAllowedNonStandardFunctions());
        minifierOptions.setAllowedUnrecognizedProperties(this.extension.getCss().getAllowedUnrecognizedProperties());
        minifierOptions.setAllowUnrecognizedProperties(this.extension.getCss().getAllowUnrecognizedProperties());
        minifierOptions.setVendor(this.extension.getCss().getVendor());
        minifierOptions.setAllowKeyframes(this.extension.getCss().getAllowKeyframes());
        minifierOptions.setAllowWebkitKeyframes(this.extension.getCss().getAllowWebkitKeyframes());
        minifierOptions.setProcessDependencies(this.extension.getCss().getProcessDependencies());
        minifierOptions.setExcludedClassesFromRenaming(this.extension.getCss().getExcludedClassesFromRenaming());
        minifierOptions.setSimplifyCss(this.extension.getCss().getSimplifyCss());
        minifierOptions.setEliminateDeadStyles(this.extension.getCss().getEliminateDeadStyles());
        minifierOptions.setCssRenamingPrefix(this.extension.getCss().getCssRenamingPrefix());
        minifierOptions.setPreserveComments(this.extension.getCss().getPreserveComments());
        minifierOptions.setOutputRenamingMapFormat(this.extension.getCss().getOutputRenamingMapFormat());
        minifierOptions.setCompileConstants(this.extension.getCss().getCompileConstants());
        minifierOptions.setSourceMapLevel(this.extension.getCss().getSourceMapLevel());
        return cssMinifier;
    }

    private JsMinifier createJsMinifier() {
        JsMinifier jsMinifier = new JsMinifier();
        JSMinifierOptions minifierOptions = jsMinifier.getMinifierOptions();
        minifierOptions.setCreateSoureMaps(this.extension.getCreateJsSourceMaps());
        minifierOptions.setOriginalFileNames(this.extension.getOriginalFileNames());
        minifierOptions.setCompilationLevel(this.extension.getJs().getCompilationLevel());
        minifierOptions.setEnv(this.extension.getJs().getEnv());
        minifierOptions.setLanguageIn(this.extension.getJs().getLanguageIn());
        minifierOptions.setLanguageOut(this.extension.getJs().getLanguageOut());
        minifierOptions.setWarningLevel(this.extension.getJs().getWarningLevel());
        minifierOptions.setExtraAnnotationNames(this.extension.getJs().getExtraAnnotationNames());
        minifierOptions.setStrictModeInput(this.extension.getJs().getStrictModeInput());
        minifierOptions.setDebug(this.extension.getJs().getDebug());
        minifierOptions.setExportLocalPropertyDefinitions(this.extension.getJs().getExportLocalPropertyDefinitions());
        minifierOptions.setFormatting(this.extension.getJs().getFormatting());
        minifierOptions.setGenerateExports(this.extension.getJs().getGenerateExports());
        minifierOptions.setRenamePrefixNamespace(this.extension.getJs().getRenamePrefixNamespace());
        minifierOptions.setRenameVariablePrefix(this.extension.getJs().getRenameVariablePrefix());
        minifierOptions.setModuleResolution(this.extension.getJs().getModuleResolution());
        minifierOptions.setProcessCommonJsModules(this.extension.getJs().getProcessCommonJsModules());
        minifierOptions.setPackageJsonEntryNames(this.extension.getJs().getPackageJsonEntryNames());
        minifierOptions.setAngularPass(this.extension.getJs().getAngularPass());
        minifierOptions.setDartPass(this.extension.getJs().getDartPass());
        minifierOptions.setForceInjectLibrary(this.extension.getJs().getForceInjectLibrary());
        minifierOptions.setPolymerVersion(this.extension.getJs().getPolymerVersion());
        minifierOptions.setRewritePolyfills(this.extension.getJs().getRewritePolyfills());
        minifierOptions.setCharset(this.extension.getJs().getCharset());
        minifierOptions.setChecksOnly(this.extension.getJs().getChecksOnly());
        minifierOptions.setBrowserFeaturesetYear(this.extension.getJs().getBrowserFeaturesetYear());
        return jsMinifier;
    }
}

