/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.credentials.authenticator;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.NameID;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.profile.SAML2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAML2Authenticator
extends ProfileDefinitionAware<SAML2Profile>
implements Authenticator<SAML2Credentials> {
    public static final String SAML_CONDITION_NOT_BEFORE_ATTRIBUTE = "notBefore";
    public static final String SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE = "notOnOrAfter";
    public static final String SESSION_INDEX = "sessionindex";
    public static final String ISSUER_ID = "issuerId";
    public static final String AUTHN_CONTEXT = "authnContext";
    public static final String SAML_NAME_ID_FORMAT = "samlNameIdFormat";
    public static final String SAML_NAME_ID_NAME_QUALIFIER = "samlNameIdNameQualifier";
    public static final String SAML_NAME_ID_SP_NAME_QUALIFIER = "samlNameIdSpNameQualifier";
    public static final String SAML_NAME_ID_SP_PROVIDED_ID = "samlNameIdSpProvidedId";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String attributeAsId;

    public SAML2Authenticator(String attributeAsId) {
        this.attributeAsId = attributeAsId;
    }

    protected void internalInit() {
        this.defaultProfileDefinition((ProfileDefinition)new CommonProfileDefinition(x -> new SAML2Profile()));
    }

    public void validate(SAML2Credentials credentials, WebContext context) {
        this.init();
        SAML2Profile profile = (SAML2Profile)this.getProfileDefinition().newProfile(new Object[0]);
        NameID nameId = credentials.getNameId();
        profile.setId(nameId.getValue());
        profile.addAttribute(SESSION_INDEX, credentials.getSessionIndex());
        profile.addAuthenticationAttribute(SAML_NAME_ID_FORMAT, nameId.getFormat());
        profile.addAuthenticationAttribute(SAML_NAME_ID_NAME_QUALIFIER, nameId.getNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_NAME_QUALIFIER, nameId.getSPNameQualifier());
        profile.addAuthenticationAttribute(SAML_NAME_ID_SP_PROVIDED_ID, nameId.getSPProvidedID());
        for (Attribute attribute : credentials.getAttributes()) {
            this.logger.debug("Processing profile attribute {}", (Object)attribute);
            String name = attribute.getName();
            String friendlyName = attribute.getFriendlyName();
            ArrayList<String> values = new ArrayList<String>();
            for (XMLObject attributeValue : attribute.getAttributeValues()) {
                Element attributeValueElement = attributeValue.getDOM();
                if (attributeValueElement != null) {
                    String value = attributeValueElement.getTextContent();
                    this.logger.debug("Adding attribute value {} for attribute {} / {}", new Object[]{value, name, friendlyName});
                    values.add(value);
                    continue;
                }
                this.logger.warn("Attribute value DOM element is null for {}", (Object)attribute);
            }
            if (!values.isEmpty()) {
                if (StringUtils.isNotBlank((String)this.attributeAsId) && this.attributeAsId.equals(name)) {
                    if (values.size() == 1) {
                        profile.setId((String)values.get(0));
                    } else {
                        this.logger.warn("Will not add {} as id because it has multiple values: {}", (Object)this.attributeAsId, values);
                    }
                }
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, name, values);
                if (!CommonHelper.isNotBlank((String)friendlyName)) continue;
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, friendlyName, values);
                continue;
            }
            this.logger.debug("No attribute values found for {}", (Object)name);
        }
        profile.addAuthenticationAttribute(ISSUER_ID, credentials.getIssuerId());
        profile.addAuthenticationAttribute(AUTHN_CONTEXT, credentials.getAuthnContexts());
        Conditions conditions = credentials.getConditions();
        if (conditions != null) {
            profile.addAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            profile.addAuthenticationAttribute(SAML_CONDITION_NOT_BEFORE_ATTRIBUTE, conditions.getNotBefore());
            profile.addAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
            profile.addAuthenticationAttribute(SAML_CONDITION_NOT_ON_OR_AFTER_ATTRIBUTE, conditions.getNotOnOrAfter());
        }
        credentials.setUserProfile(profile);
    }
}

