/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.authenticator;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.exceptions.OidcTokenException;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAuthenticator
implements Authenticator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthenticator.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcAuthenticator(OidcConfiguration configuration, OidcClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials cred) {
        OidcCredentials credentials;
        AuthorizationCode code;
        if (cred instanceof OidcCredentials && (code = (credentials = (OidcCredentials)cred).toAuthorizationCode()) != null) {
            try {
                String computedCallbackUrl = this.client.computeFinalCallbackUrl(ctx.webContext());
                CodeVerifier verifier = this.configuration.getValueRetriever().retrieve(ctx, this.client.getCodeVerifierSessionAttributeName(), this.client).orElse(null);
                TokenRequest request = this.createTokenRequest((AuthorizationGrant)new AuthorizationCodeGrant(code, new URI(computedCallbackUrl), verifier));
                this.executeTokenRequest((Request)request, credentials);
            }
            catch (ParseException | IOException | URISyntaxException e) {
                throw new OidcException(e);
            }
        }
        return Optional.ofNullable(cred);
    }

    public void refresh(OidcCredentials credentials) {
        RefreshToken refreshToken = credentials.toRefreshToken();
        if (refreshToken != null) {
            try {
                TokenRequest request = this.createTokenRequest((AuthorizationGrant)new RefreshTokenGrant(refreshToken));
                this.executeTokenRequest((Request)request, credentials);
            }
            catch (ParseException | IOException e) {
                throw new OidcException(e);
            }
        }
    }

    protected TokenRequest createTokenRequest(AuthorizationGrant grant) {
        OidcOpMetadataResolver metadataResolver = this.configuration.getOpMetadataResolver();
        URI tokenEndpointUri = ((OIDCProviderMetadata)metadataResolver.load()).getTokenEndpointURI();
        ClientAuthentication clientAuthentication = metadataResolver.getClientAuthentication();
        if (clientAuthentication != null) {
            return new TokenRequest(tokenEndpointUri, clientAuthentication, grant, Scope.parse((String)this.configuration.getScope()));
        }
        return new TokenRequest(tokenEndpointUri, new ClientID(this.configuration.getClientId()), grant, Scope.parse((String)this.configuration.getScope()));
    }

    private void executeTokenRequest(Request request, OidcCredentials credentials) throws IOException, ParseException {
        HTTPRequest tokenHttpRequest = request.toHTTPRequest();
        this.configuration.configureHttpRequest(tokenHttpRequest);
        HTTPResponse httpResponse = tokenHttpRequest.send();
        LOGGER.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getBody());
        TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
        if (response instanceof TokenErrorResponse) {
            TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)response;
            ErrorObject errorObject = tokenErrorResponse.getErrorObject();
            throw new OidcTokenException("Bad token response, error=" + errorObject.getCode() + ", description=" + errorObject.getDescription() + ", status=" + errorObject.getHTTPStatusCode());
        }
        LOGGER.debug("Token response successful");
        OIDCTokenResponse tokenSuccessResponse = (OIDCTokenResponse)response;
        OIDCTokens oidcTokens = tokenSuccessResponse.getOIDCTokens();
        if (oidcTokens.getAccessToken() != null) {
            credentials.setAccessToken((Map<String, ?>)oidcTokens.getAccessToken().toJSONObject());
        }
        if (oidcTokens.getRefreshToken() != null) {
            credentials.setRefreshToken((Map<String, ?>)oidcTokens.getRefreshToken().toJSONObject());
        }
        if (oidcTokens.getIDToken() != null) {
            credentials.setIdToken(oidcTokens.getIDToken().serialize());
        }
    }
}

