/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.credentials.extractor;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcExtractor
extends InitializableWebObject
implements CredentialsExtractor<OidcCredentials> {
    private static final Logger logger = LoggerFactory.getLogger(OidcExtractor.class);
    private OidcConfiguration configuration;
    private String clientName;

    public OidcExtractor() {
    }

    public OidcExtractor(OidcConfiguration configuration, String clientName) {
        this.configuration = configuration;
        this.clientName = clientName;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertNotBlank((String)"clientName", (String)this.clientName);
        this.configuration.init(context);
    }

    public OidcCredentials extract(WebContext context) throws HttpAction {
        AccessToken accessToken;
        JWT idToken;
        AuthenticationResponse response;
        this.init(context);
        Map<String, String> parameters = this.retrieveParameters(context);
        try {
            response = AuthenticationResponseParser.parse((URI)new URI(this.configuration.getCallbackUrl()), parameters);
        }
        catch (ParseException | URISyntaxException e) {
            throw new TechnicalException(e);
        }
        if (response instanceof AuthenticationErrorResponse) {
            logger.error("Bad authentication response, error={}", (Object)((AuthenticationErrorResponse)response).getErrorObject());
            return null;
        }
        logger.debug("Authentication response successful");
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)response;
        State state = successResponse.getState();
        if (state == null) {
            throw new TechnicalException("Missing state parameter");
        }
        if (!state.equals(context.getSessionAttribute("oidcStateAttribute"))) {
            throw new TechnicalException("State parameter is different from the one sent in authentication request. Session expired or possible threat of cross-site request forgery");
        }
        OidcCredentials credentials = new OidcCredentials(this.clientName);
        AuthorizationCode code = successResponse.getAuthorizationCode();
        if (code != null) {
            credentials.setCode(code);
        }
        if ((idToken = successResponse.getIDToken()) != null) {
            credentials.setIdToken(idToken);
        }
        if ((accessToken = successResponse.getAccessToken()) != null) {
            credentials.setAccessToken(accessToken);
        }
        return credentials;
    }

    protected Map<String, String> retrieveParameters(WebContext context) {
        Map requestParameters = context.getRequestParameters();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : requestParameters.entrySet()) {
            map.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return map;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration, "clientName", this.clientName});
    }
}

