/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.credentials.extractor.OidcExtractor;
import org.pac4j.oidc.logout.OidcLogoutActionBuilder;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.creator.OidcProfileCreator;
import org.pac4j.oidc.redirect.OidcRedirectActionBuilder;

public class OidcClient<U extends OidcProfile>
extends IndirectClient<OidcCredentials, U> {
    private OidcConfiguration configuration = new OidcConfiguration();

    public OidcClient() {
    }

    public OidcClient(OidcConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public OidcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void clientInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setCallbackUrl(this.computeFinalCallbackUrl(context));
        this.configuration.init(context);
        this.defaultRedirectActionBuilder(new OidcRedirectActionBuilder(this.configuration));
        this.defaultCredentialsExtractor(new OidcExtractor(this.configuration, this.getName()));
        this.defaultAuthenticator(new OidcAuthenticator(this.configuration));
        this.defaultProfileCreator(new OidcProfileCreator(this.configuration));
        this.defaultLogoutActionBuilder(new OidcLogoutActionBuilder(this.configuration));
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "urlResolver", this.urlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectActionBuilder", this.getRedirectActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.getLogoutActionBuilder(), "configuration", this.configuration});
    }
}

