/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Map;

public final class StravaApi20
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://www.strava.com/oauth/authorize?approval_prompt=%s&response_type=code&client_id=%s&redirect_uri=%s";
    private static final String SCOPED_AUTHORIZE_URL = "https://www.strava.com/oauth/authorize?approval_prompt=%s&response_type=code&client_id=%s&redirect_uri=%s&scope=%s";
    private static final String ACCESS_TOKEN_URL = "https://www.strava.com/oauth/token";
    private String approvalPrompt;

    public StravaApi20(String approvalPrompt) {
        this.approvalPrompt = approvalPrompt;
    }

    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid callback url.");
        if (config.getScope() != null) {
            return String.format(SCOPED_AUTHORIZE_URL, this.approvalPrompt, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL, this.approvalPrompt, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    protected String getAuthorizationBaseUrl() {
        return "https://www.strava.com/oauth/authorize";
    }
}

