/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthProfileCreator<C extends OAuthCredentials, U extends CommonProfile, O extends OAuthConfiguration, T extends Token>
extends InitializableWebObject
implements ProfileCreator<C, U> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final ObjectMapper mapper = new ObjectMapper();
    protected final O configuration;

    protected OAuthProfileCreator(O configuration) {
        this.configuration = configuration;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"configuration", this.configuration);
        this.configuration.init(context);
    }

    public U create(C credentials, WebContext context) throws HttpAction {
        try {
            T token = this.getAccessToken(credentials);
            return this.retrieveUserProfileFromToken(token);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract T getAccessToken(C var1) throws HttpAction;

    protected U retrieveUserProfileFromToken(T accessToken) throws HttpAction {
        OAuthProfileDefinition profileDefinition = ((OAuthConfiguration)((Object)this.configuration)).getProfileDefinition();
        String profileUrl = profileDefinition.getProfileUrl(accessToken, this.configuration);
        String body = this.sendRequestForData(accessToken, profileUrl, profileDefinition.getProfileVerb());
        this.logger.info("UserProfile: " + body);
        if (body == null) {
            throw new HttpCommunicationException("No data found for accessToken: " + accessToken);
        }
        Object profile = ((OAuthConfiguration)((Object)this.configuration)).getProfileDefinition().extractUserProfile(body);
        this.addAccessTokenToProfile(profile, accessToken);
        return (U)profile;
    }

    protected String sendRequestForData(T accessToken, String dataUrl, Verb verb) {
        String body;
        this.logger.debug("accessToken: {} / dataUrl: {}", accessToken, (Object)dataUrl);
        long t0 = System.currentTimeMillis();
        OAuthRequest request = this.createOAuthRequest(dataUrl, verb);
        this.signRequest(accessToken, request);
        Response response = request.send();
        int code = response.getCode();
        try {
            body = response.getBody();
        }
        catch (IOException ex) {
            throw new HttpCommunicationException("Error getting body: " + ex.getMessage());
        }
        long t1 = System.currentTimeMillis();
        this.logger.debug("Request took: " + (t1 - t0) + " ms for: " + dataUrl);
        this.logger.debug("response code: {} / response body: {}", (Object)code, (Object)body);
        if (code != 200) {
            throw new HttpCommunicationException(code, body);
        }
        return body;
    }

    protected abstract void signRequest(T var1, OAuthRequest var2);

    protected OAuthRequest createOAuthRequest(String url, Verb verb) {
        return new OAuthRequest(verb, url, ((OAuthConfiguration)((Object)this.configuration)).getService());
    }

    protected abstract void addAccessTokenToProfile(U var1, T var2);

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"configuration", this.configuration});
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

