/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.credentials.authenticator.OAuth20Authenticator;
import org.pac4j.oauth.credentials.extractor.OAuth20CredentialsExtractor;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.redirect.OAuth20RedirectActionBuilder;

public class OAuth20Client<U extends OAuth20Profile>
extends IndirectClient<OAuth20Credentials, U> {
    protected OAuth20Configuration configuration = new OAuth20Configuration();

    protected void clientInit(WebContext context) {
        this.defaultRedirectActionBuilder(new OAuth20RedirectActionBuilder(this.configuration));
        this.defaultCredentialsExtractor(new OAuth20CredentialsExtractor(this.configuration));
        this.defaultAuthenticator(new OAuth20Authenticator(this.configuration));
        this.defaultProfileCreator(new OAuth20ProfileCreator(this.configuration));
    }

    public OAuth20Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuth20Configuration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.configuration.setClient(this);
    }

    public String getKey() {
        return this.configuration.getKey();
    }

    public void setKey(String key) {
        this.configuration.setKey(key);
    }

    public String getSecret() {
        return this.configuration.getSecret();
    }

    public void setSecret(String secret) {
        this.configuration.setSecret(secret);
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.getCallbackUrl(), "callbackUrlResolver", this.getCallbackUrlResolver(), "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectActionBuilder", this.getRedirectActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "configuration", this.configuration});
    }
}

