/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.StringTokenizer;
import lombok.Generated;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.profile.UserProfile;

public class FromAttributesAuthorizationGenerator
implements AuthorizationGenerator {
    private Collection<String> roleAttributes;
    private String splitChar = ",";

    public FromAttributesAuthorizationGenerator() {
        this.roleAttributes = new ArrayList<String>();
    }

    public FromAttributesAuthorizationGenerator(Collection<String> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public FromAttributesAuthorizationGenerator(String[] roleAttributes) {
        this.roleAttributes = roleAttributes != null ? Arrays.asList(roleAttributes) : null;
    }

    @Override
    public Optional<UserProfile> generate(CallContext ctx, UserProfile profile) {
        this.generateAuth(profile, this.roleAttributes);
        return Optional.of(profile);
    }

    private void generateAuth(UserProfile profile, Iterable<String> attributes) {
        if (attributes == null) {
            return;
        }
        for (String attribute : attributes) {
            Object value = profile.getAttribute(attribute);
            if (value == null) continue;
            if (value instanceof String) {
                StringTokenizer st = new StringTokenizer((String)value, this.splitChar);
                while (st.hasMoreTokens()) {
                    this.addRoleToProfile(profile, st.nextToken());
                }
                continue;
            }
            if (value.getClass().isArray() && value.getClass().getComponentType().isAssignableFrom(String.class)) {
                for (Object item : (Object[])value) {
                    this.addRoleToProfile(profile, item.toString());
                }
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass())) continue;
            for (Object item : (Collection)value) {
                if (!item.getClass().isAssignableFrom(String.class)) continue;
                this.addRoleToProfile(profile, item.toString());
            }
        }
    }

    private void addRoleToProfile(UserProfile profile, String value) {
        profile.addRole(value);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Collection<String> getRoleAttributes() {
        return this.roleAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSplitChar() {
        return this.splitChar;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRoleAttributes(Collection<String> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSplitChar(String splitChar) {
        this.splitChar = splitChar;
    }
}

