/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceConnection
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceConnection.class);
    private static final int MAX_REDIRECT_ATTEMPTS = 5;
    private static final String HEAD = "HEAD";
    private static final String GET = "GET";
    private final Settings settings;
    private final URLConnectionFactory connFactory;
    private HttpURLConnection connection = null;
    private final boolean usesProxy;
    private String userKey = null;
    private String passwordKey = null;

    public HttpResourceConnection(Settings settings) {
        this(settings, true);
    }

    public HttpResourceConnection(Settings settings, boolean usesProxy) {
        this.settings = settings;
        this.connFactory = new URLConnectionFactory(settings);
        this.usesProxy = usesProxy;
    }

    public HttpResourceConnection(Settings settings, boolean usesProxy, String userKey, String passwordKey) {
        this.settings = settings;
        this.connFactory = new URLConnectionFactory(settings);
        this.usesProxy = usesProxy;
        this.userKey = userKey;
        this.passwordKey = passwordKey;
    }

    public InputStream fetch(URL url) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException ex) {
                String msg = String.format("Download failed, unable to locate '%s'", url);
                throw new DownloadFailedException(msg);
            }
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (IOException ex) {
                    String msg = String.format("Download failed, unable to rerieve '%s'", url);
                    throw new DownloadFailedException(msg, ex);
                }
            }
            String msg = String.format("Download failed, file ('%s') does not exist", url);
            throw new DownloadFailedException(msg);
        }
        if (this.connection != null) {
            LOGGER.warn("HTTP URL Connection was not properly closed");
            this.connection.disconnect();
            this.connection = null;
        }
        this.connection = this.obtainConnection(url);
        String encoding = this.connection.getContentEncoding();
        try {
            if ("gzip".equalsIgnoreCase(encoding)) {
                return new GZIPInputStream(this.connection.getInputStream());
            }
            if ("deflate".equalsIgnoreCase(encoding)) {
                return new InflaterInputStream(this.connection.getInputStream());
            }
            return this.connection.getInputStream();
        }
        catch (IOException ex) {
            this.checkForCommonExceptionTypes(ex);
            String msg = String.format("Error retrieving '%s'%nConnection Timeout: %d%nEncoding: %s%n", url, this.connection.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
        catch (Exception ex) {
            String msg = String.format("Unexpected exception retrieving '%s'%nConnection Timeout: %d%nEncoding: %s%n", url, this.connection.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection obtainConnection(URL url) throws DownloadFailedException, TooManyRequestsException, ResourceNotFoundException {
        HttpURLConnection conn;
        block26: {
            conn = null;
            try {
                LOGGER.debug("Attempting retrieval of {}", (Object)url.toString());
                conn = this.connFactory.createHttpURLConnection(url, this.usesProxy);
                if (this.userKey != null && this.passwordKey != null) {
                    this.connFactory.addBasicAuthentication(conn, this.userKey, this.passwordKey);
                }
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                int status = conn.getResponseCode();
                String message = conn.getResponseMessage();
                int redirectCount = 0;
                while ((status == 302 || status == 301 || status == 303) && 5 > redirectCount++) {
                    String location = conn.getHeaderField("Location");
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                    LOGGER.debug("Download is being redirected from {} to {}", (Object)url, (Object)location);
                    conn = this.connFactory.createHttpURLConnection(new URL(location), this.usesProxy);
                    conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                    conn.connect();
                    status = conn.getResponseCode();
                }
                if (status == 404) {
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                    throw new ResourceNotFoundException("Requested resource does not exists - received a 404");
                }
                if (status == 429) {
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                    throw new TooManyRequestsException("Download failed - too many connection requests");
                }
                if (status == 200) break block26;
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
                String msg = String.format("Error retrieving %s; received response code %s; %s", url, status, message);
                LOGGER.error(msg);
                throw new DownloadFailedException(msg);
            }
            catch (IOException ex) {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                finally {
                    conn = null;
                }
                if ("Connection reset".equalsIgnoreCase(ex.getMessage())) {
                    String msg = String.format("TLS Connection Reset%nPlease see http://jeremylong.github.io/DependencyCheck/data/tlsfailure.html for more information regarding how to resolve the issue.", new Object[0]);
                    LOGGER.error(msg);
                    throw new DownloadFailedException(msg, ex);
                }
                String msg = String.format("Error downloading file %s; unable to connect.", url);
                throw new DownloadFailedException(msg, ex);
            }
        }
        return conn;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    private String determineHttpMethod() {
        return this.isQuickQuery() ? HEAD : GET;
    }

    private boolean isQuickQuery() {
        return this.settings.getBoolean("downloader.quick.query.timestamp", true);
    }

    public void checkForCommonExceptionTypes(IOException ex) throws DownloadFailedException {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause instanceof UnknownHostException) {
                String msg = String.format("Unable to resolve domain '%s'", cause.getMessage());
                LOGGER.error(msg);
                throw new DownloadFailedException(msg);
            }
            if (!(cause instanceof InvalidAlgorithmParameterException)) continue;
            String keystore = System.getProperty("javax.net.ssl.keyStore");
            String version = System.getProperty("java.version");
            String vendor = System.getProperty("java.vendor");
            LOGGER.info("Error making HTTPS request - InvalidAlgorithmParameterException");
            LOGGER.info("There appears to be an issue with the installation of Java and the cacerts.See closed issue #177 here: https://github.com/jeremylong/DependencyCheck/issues/177");
            LOGGER.info("Java Info:\njavax.net.ssl.keyStore='{}'\njava.version='{}'\njava.vendor='{}'", new Object[]{keystore, version, vendor});
            throw new DownloadFailedException("Error making HTTPS request. Please see the log for more details.");
        }
    }
}

