/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.NugetPackageReference;
import org.owasp.dependencycheck.data.nuget.NugetconfParseException;
import org.owasp.dependencycheck.data.nuget.XPathNugetconfParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NugetconfAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "dotnet";
    private static final Logger LOGGER = LoggerFactory.getLogger(NugetconfAnalyzer.class);
    private static final String ANALYZER_NAME = "Nugetconf Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String FILE_NAME = "packages.config";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("packages.config").build();

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nugetconf.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking packages.config file {}", (Object)dependency);
        try {
            List<NugetPackageReference> packages;
            XPathNugetconfParser parser = new XPathNugetconfParser();
            try (FileInputStream fis = new FileInputStream(dependency.getActualFilePath());){
                packages = parser.parse(fis);
            }
            catch (FileNotFoundException | NugetconfParseException ex) {
                throw new AnalysisException(ex);
            }
            for (NugetPackageReference np : packages) {
                Dependency child = new Dependency(dependency.getActualFile(), true);
                String id = np.getId();
                String version = np.getVersion();
                child.setEcosystem(DEPENDENCY_ECOSYSTEM);
                child.setName(id);
                child.setVersion(version);
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("nuget").withName(id).withVersion(version).build();
                    child.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to build package url for nuget package", (Throwable)ex);
                    GenericIdentifier gid = new GenericIdentifier("nuget:" + id + "@" + version, Confidence.HIGHEST);
                    child.addSoftwareIdentifier(gid);
                }
                child.setPackagePath(String.format("%s:%s", id, version));
                child.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", id, version)));
                child.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", id, version)));
                child.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", id, version)));
                child.addEvidence(EvidenceType.VERSION, FILE_NAME, "version", np.getVersion(), Confidence.HIGHEST);
                child.addEvidence(EvidenceType.PRODUCT, FILE_NAME, "id", np.getId(), Confidence.HIGHEST);
                if (id.indexOf(46) > 0) {
                    String[] parts = id.split("\\.");
                    child.addEvidence(EvidenceType.VENDOR, FILE_NAME, "id", parts[0], Confidence.MEDIUM);
                    child.addEvidence(EvidenceType.PRODUCT, FILE_NAME, "id", parts[1], Confidence.MEDIUM);
                    if (parts.length > 2) {
                        String rest = id.substring(id.indexOf(46) + 1);
                        child.addEvidence(EvidenceType.PRODUCT, FILE_NAME, "id", rest, Confidence.MEDIUM);
                    }
                } else {
                    child.addEvidence(EvidenceType.VENDOR, FILE_NAME, "id", id, Confidence.LOW);
                }
                engine.addDependency(child);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }
}

