/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.CPEAnalyzer;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.cpe.NpmCpeMemoryIndex;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class NpmCPEAnalyzer
extends CPEAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NpmCPEAnalyzer.class);

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.PRE_IDENTIFIER_ANALYSIS;
    }

    @Override
    public String getName() {
        return "NPM CPE Analyzer";
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.npm.cpe.enabled";
    }

    @Override
    public void open(CveDB cve) throws IOException, DatabaseException {
        this.setCveDB(cve);
        this.setMemoryIndex(NpmCpeMemoryIndex.getInstance());
        try {
            long creationStart = System.currentTimeMillis();
            this.getMemoryIndex().open(cve.getVendorProductListForNode(), this.getSettings());
            long creationSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - creationStart);
            LOGGER.info("Created CPE Index ({} seconds)", (Object)creationSeconds);
        }
        catch (IndexException ex) {
            LOGGER.debug("IndexException", (Throwable)ex);
            throw new DatabaseException(ex);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (!"npm".equals(dependency.getEcosystem())) {
            return;
        }
        try {
            this.determineCPE(dependency);
        }
        catch (CorruptIndexException ex) {
            throw new AnalysisException("CPE Index is corrupt.", ex);
        }
        catch (IOException ex) {
            throw new AnalysisException("Failure opening the CPE Index.", ex);
        }
        catch (ParseException ex) {
            throw new AnalysisException("Unable to parse the generated Lucene query for this dependency.", ex);
        }
    }
}

