/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.nvd.Config;
import io.github.jeremylong.openvulnerability.client.nvd.CpeMatch;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3Data;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import io.github.jeremylong.openvulnerability.client.nvd.LangString;
import io.github.jeremylong.openvulnerability.client.nvd.Node;
import io.github.jeremylong.openvulnerability.client.nvd.Reference;
import io.github.jeremylong.openvulnerability.client.nvd.Weakness;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.anarres.jdiagnostics.DefaultQuery;
import org.apache.commons.collections.map.ReferenceMap;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.knownexploited.json.Vulnerability;
import org.owasp.dependencycheck.data.nvdcve.CveItemOperator;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseManager;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.cpe.CpeEcosystemCache;
import org.owasp.dependencycheck.data.update.cpe.CpePlus;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public final class CveDB
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    public static final String DB_ECOSYSTEM_CACHE = "data/dbEcosystemCacheUpdates.sql";
    private final DatabaseManager databaseManager;
    private ResourceBundle statementBundle;
    private DatabaseProperties databaseProperties;
    private final String cpeStartsWithFilter;
    private final Map<String, List<org.owasp.dependencycheck.dependency.Vulnerability>> vulnerabilitiesForCpeCache = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final Settings settings;
    private final CveItemOperator cveItemConverter;
    private boolean isOracle = false;
    private boolean isH2 = false;

    public int updateEcosystemCache() {
        LOGGER.debug("Updating the ecosystem cache");
        int updateCount = 0;
        try {
            URL url = Resources.getResource((String)DB_ECOSYSTEM_CACHE);
            List sql = Resources.readLines((URL)url, (Charset)StandardCharsets.UTF_8);
            try (Connection conn = this.databaseManager.getConnection();
                 Statement statement = conn.createStatement();){
                for (String single : sql) {
                    updateCount += statement.executeUpdate(single);
                }
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to update the ecosystem cache", ex);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to update the ecosystem cache", ex);
        }
        catch (LinkageError ex) {
            LOGGER.debug(new DefaultQuery((Throwable)ex).call().toString());
        }
        return updateCount;
    }

    public CveDB(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.cpeStartsWithFilter = settings.getString("cve.cpe.startswith.filter", "cpe:2.3:a:");
        this.cveItemConverter = new CveItemOperator(this.cpeStartsWithFilter);
        this.databaseManager = new DatabaseManager(settings);
        this.statementBundle = this.databaseManager.getSqlStatements();
        this.isOracle = this.databaseManager.isOracle();
        this.isH2 = this.databaseManager.isH2Connection();
    }

    public void open() {
        this.databaseManager.open();
        this.databaseProperties = new DatabaseProperties(this);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            LOGGER.debug("Closing database");
            this.clearCache();
            LOGGER.debug("Cache cleared");
            try {
                this.databaseManager.close();
                LOGGER.debug("Connection closed");
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.releaseResources();
            LOGGER.debug("Resources released");
            this.databaseManager.cleanup();
        }
    }

    private void releaseResources() {
        this.statementBundle = null;
        this.databaseProperties = null;
    }

    public boolean isOpen() {
        return this.databaseManager.isOpen();
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key, String parameter) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(connection, key);
        preparedStatement.setString(1, parameter);
        return preparedStatement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key, int parameter) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(connection, key);
        preparedStatement.setInt(1, parameter);
        return preparedStatement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key) throws DatabaseException {
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            try {
                String statementString = this.statementBundle.getString(key.name());
                preparedStatement = this.isOracle && key == PreparedStatementCveDb.UPDATE_VULNERABILITY ? connection.prepareCall(statementString) : connection.prepareStatement(statementString);
                if (this.isOracle) {
                    preparedStatement.setFetchSize(10000);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
            catch (MissingResourceException ex) {
                if (ex.getMessage().contains("key MERGE_PROPERTY")) break block4;
                throw new DatabaseException(ex);
            }
        }
        return preparedStatement;
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    DatabaseProperties reloadProperties() {
        this.databaseProperties = new DatabaseProperties(this);
        return this.databaseProperties;
    }

    public Set<CpePlus> getCPEs(String vendor, String product) {
        HashSet<CpePlus> cpe = new HashSet<CpePlus>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CPE_ENTRIES);){
            ps.setString(1, vendor);
            ps.setString(2, product);
            try (ResultSet rs = ps.executeQuery();){
                CpeBuilder builder = new CpeBuilder();
                while (rs.next()) {
                    Cpe entry = builder.part(rs.getString(1)).vendor(rs.getString(2)).product(rs.getString(3)).version(rs.getString(4)).update(rs.getString(5)).edition(rs.getString(6)).language(rs.getString(7)).swEdition(rs.getString(8)).targetSw(rs.getString(9)).targetHw(rs.getString(10)).other(rs.getString(11)).build();
                    CpePlus plus = new CpePlus(entry, rs.getString(12));
                    cpe.add(plus);
                }
            }
        }
        catch (SQLException | CpeParsingException | CpeValidationException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", ex);
        }
        return cpe;
    }

    public Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
            throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
        }
        return data;
    }

    public Set<Pair<String, String>> getVendorProductListForNode() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
            throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
        }
        return data;
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_PROPERTIES);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
        }
        return prop;
    }

    public void saveProperty(String key, String value) {
        block51: {
            this.clearCache();
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement mergeProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.MERGE_PROPERTY);){
                if (mergeProperty != null) {
                    mergeProperty.setString(1, key);
                    mergeProperty.setString(2, value);
                    mergeProperty.execute();
                    break block51;
                }
                try (PreparedStatement updateProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_PROPERTY);){
                    updateProperty.setString(1, value);
                    updateProperty.setString(2, key);
                    if (updateProperty.executeUpdate() != 0) break block51;
                    try (PreparedStatement insertProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_PROPERTY);){
                        insertProperty.setString(1, key);
                        insertProperty.setString(2, value);
                        insertProperty.executeUpdate();
                    }
                }
            }
            catch (SQLException ex) {
                LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    private void clearCache() {
        this.vulnerabilitiesForCpeCache.clear();
    }

    public List<org.owasp.dependencycheck.dependency.Vulnerability> getVulnerabilities(Cpe cpe) throws DatabaseException {
        List<org.owasp.dependencycheck.dependency.Vulnerability> cachedVulnerabilities = this.vulnerabilitiesForCpeCache.get(cpe.toCpe23FS());
        if (cachedVulnerabilities != null) {
            LOGGER.debug("Cache hit for {}", (Object)cpe.toCpe23FS());
            return cachedVulnerabilities;
        }
        LOGGER.debug("Cache miss for {}", (Object)cpe.toCpe23FS());
        ArrayList<org.owasp.dependencycheck.dependency.Vulnerability> vulnerabilities = new ArrayList<org.owasp.dependencycheck.dependency.Vulnerability>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CVE_FROM_SOFTWARE);){
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            try (ResultSet rs = ps.executeQuery();){
                org.owasp.dependencycheck.dependency.Vulnerability v;
                String currentCVE = "";
                HashSet<VulnerableSoftware> vulnSoftware = new HashSet<VulnerableSoftware>();
                VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
                while (rs.next()) {
                    VulnerableSoftware vs;
                    String cveId = rs.getString(1);
                    if (currentCVE.isEmpty()) {
                        currentCVE = cveId;
                    }
                    if (!vulnSoftware.isEmpty() && !currentCVE.equals(cveId)) {
                        org.owasp.dependencycheck.dependency.Vulnerability v2;
                        VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                        if (matchedCPE != null && (v2 = this.getVulnerability(currentCVE, conn)) != null) {
                            v2.setMatchedVulnerableSoftware(matchedCPE);
                            v2.setSource(Vulnerability.Source.NVD);
                            vulnerabilities.add(v2);
                        }
                        vulnSoftware.clear();
                        currentCVE = cveId;
                    }
                    try {
                        vs = vulnerableSoftwareBuilder.part(rs.getString(2)).vendor(rs.getString(3)).product(rs.getString(4)).version(rs.getString(5)).update(rs.getString(6)).edition(rs.getString(7)).language(rs.getString(8)).swEdition(rs.getString(9)).targetSw(rs.getString(10)).targetHw(rs.getString(11)).other(rs.getString(12)).versionEndExcluding(rs.getString(13)).versionEndIncluding(rs.getString(14)).versionStartExcluding(rs.getString(15)).versionStartIncluding(rs.getString(16)).vulnerable(rs.getBoolean(17)).build();
                    }
                    catch (CpeParsingException | CpeValidationException ex) {
                        throw new DatabaseException("Database contains an invalid Vulnerable Software Entry", ex);
                    }
                    vulnSoftware.add(vs);
                }
                VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                if (matchedCPE != null && (v = this.getVulnerability(currentCVE, conn)) != null) {
                    v.setMatchedVulnerableSoftware(matchedCPE);
                    v.setSource(Vulnerability.Source.NVD);
                    vulnerabilities.add(v);
                }
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException("Exception retrieving vulnerability for " + cpe.toCpe23FS(), ex);
        }
        this.vulnerabilitiesForCpeCache.put(cpe.toCpe23FS(), vulnerabilities);
        return vulnerabilities;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.owasp.dependencycheck.dependency.Vulnerability getVulnerability(String cve) throws DatabaseException {
        try (Connection conn = this.databaseManager.getConnection();){
            org.owasp.dependencycheck.dependency.Vulnerability vulnerability = this.getVulnerability(cve, conn);
            return vulnerability;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Error retrieving " + cve, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.owasp.dependencycheck.dependency.Vulnerability getVulnerability(String cve, Connection conn) throws DatabaseException {
        VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
        org.owasp.dependencycheck.dependency.Vulnerability vuln = null;
        try {
            int cveId;
            Throwable throwable;
            Throwable throwable2;
            block112: {
                throwable2 = null;
                try (PreparedStatement psV = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VULNERABILITY, cve);){
                    throwable = null;
                    try (ResultSet rsV = psV.executeQuery();){
                        if (rsV.next()) {
                            cveId = rsV.getInt(1);
                            vuln = new org.owasp.dependencycheck.dependency.Vulnerability();
                            vuln.setSource(Vulnerability.Source.NVD);
                            vuln.setName(cve);
                            vuln.setDescription(rsV.getString(2));
                            if (rsV.getObject(11) != null) {
                                CvssV2Data.AccessVectorType accessVector = CvssV2Data.AccessVectorType.fromValue((String)rsV.getString(12));
                                CvssV2Data.AccessComplexityType accessComplexity = CvssV2Data.AccessComplexityType.fromValue((String)rsV.getString(13));
                                CvssV2Data.AuthenticationType authentication = CvssV2Data.AuthenticationType.fromValue((String)rsV.getString(14));
                                CvssV2Data.CiaType confidentialityImpact = CvssV2Data.CiaType.fromValue((String)rsV.getString(15));
                                CvssV2Data.CiaType integrityImpact = CvssV2Data.CiaType.fromValue((String)rsV.getString(16));
                                CvssV2Data.CiaType availabilityImpact = CvssV2Data.CiaType.fromValue((String)rsV.getString(17));
                                String vector = String.format("/AV:%s/AC:%s/Au:%s/C:%s/I:%s/A:%s", accessVector == null ? "" : accessVector.value().substring(0, 1), accessComplexity == null ? "" : accessComplexity.value().substring(0, 1), authentication == null ? "" : authentication.value().substring(0, 1), confidentialityImpact == null ? "" : confidentialityImpact.value().substring(0, 1), integrityImpact == null ? "" : integrityImpact.value().substring(0, 1), availabilityImpact == null ? "" : availabilityImpact.value().substring(0, 1));
                                String cveVersion = "2.0";
                                if (rsV.getString(18) != null) {
                                    cveVersion = rsV.getString(18);
                                }
                                CvssV2Data cvssData = new CvssV2Data(cveVersion, vector, accessVector, accessComplexity, authentication, confidentialityImpact, integrityImpact, availabilityImpact, Double.valueOf(rsV.getDouble(11)), rsV.getString(3), null, null, null, null, null, null, null, null, null, null);
                                CvssV2 cvss = new CvssV2(null, CvssV2.Type.PRIMARY, cvssData, rsV.getString(3), Double.valueOf(rsV.getDouble(4)), Double.valueOf(rsV.getDouble(5)), Boolean.valueOf(rsV.getBoolean(6)), Boolean.valueOf(rsV.getBoolean(7)), Boolean.valueOf(rsV.getBoolean(8)), Boolean.valueOf(rsV.getBoolean(9)), Boolean.valueOf(rsV.getBoolean(10)));
                                vuln.setCvssV2(cvss);
                            }
                            if (rsV.getObject(21) != null) {
                                String cveVersion = "3.1";
                                if (rsV.getString(31) != null) {
                                    cveVersion = rsV.getString(31);
                                }
                                CvssV3Data.Version version = CvssV3Data.Version.fromValue((String)cveVersion);
                                CvssV3Data.AttackVectorType attackVector = CvssV3Data.AttackVectorType.fromValue((String)rsV.getString(21));
                                CvssV3Data.AttackComplexityType attackComplexity = CvssV3Data.AttackComplexityType.fromValue((String)rsV.getString(22));
                                CvssV3Data.PrivilegesRequiredType privilegesRequired = CvssV3Data.PrivilegesRequiredType.fromValue((String)rsV.getString(23));
                                CvssV3Data.UserInteractionType userInteraction = CvssV3Data.UserInteractionType.fromValue((String)rsV.getString(24));
                                CvssV3Data.ScopeType scope = CvssV3Data.ScopeType.fromValue((String)rsV.getString(25));
                                CvssV3Data.CiaType confidentialityImpact = CvssV3Data.CiaType.fromValue((String)rsV.getString(26));
                                CvssV3Data.CiaType integrityImpact = CvssV3Data.CiaType.fromValue((String)rsV.getString(27));
                                CvssV3Data.CiaType availabilityImpact = CvssV3Data.CiaType.fromValue((String)rsV.getString(28));
                                CvssV3Data.SeverityType baseSeverity = CvssV3Data.SeverityType.fromValue((String)rsV.getString(30));
                                String vector = String.format("CVSS:%s/AV:%s/AC:%s/PR:%s/UI:%s/S:%s/C:%s/I:%s/A:%s", version == null ? "" : version, attackVector == null ? "" : attackVector.value().substring(0, 1), attackComplexity == null ? "" : attackComplexity.value().substring(0, 1), privilegesRequired == null ? "" : privilegesRequired.value().substring(0, 1), userInteraction == null ? "" : userInteraction.value().substring(0, 1), scope == null ? "" : scope.value().substring(0, 1), confidentialityImpact == null ? "" : confidentialityImpact.value().substring(0, 1), integrityImpact == null ? "" : integrityImpact.value().substring(0, 1), availabilityImpact == null ? "" : availabilityImpact.value().substring(0, 1));
                                CvssV3Data cvssData = new CvssV3Data(version, vector, attackVector, attackComplexity, privilegesRequired, userInteraction, scope, confidentialityImpact, integrityImpact, availabilityImpact, Double.valueOf(rsV.getDouble(29)), baseSeverity, CvssV3Data.ExploitCodeMaturityType.PROOF_OF_CONCEPT, CvssV3Data.RemediationLevelType.NOT_DEFINED, CvssV3Data.ConfidenceType.REASONABLE, Double.valueOf(0.0), CvssV3Data.SeverityType.MEDIUM, CvssV3Data.CiaRequirementType.NOT_DEFINED, CvssV3Data.CiaRequirementType.NOT_DEFINED, CvssV3Data.CiaRequirementType.NOT_DEFINED, CvssV3Data.ModifiedAttackVectorType.ADJACENT_NETWORK, CvssV3Data.ModifiedAttackComplexityType.NOT_DEFINED, CvssV3Data.ModifiedPrivilegesRequiredType.NOT_DEFINED, CvssV3Data.ModifiedUserInteractionType.NOT_DEFINED, CvssV3Data.ModifiedScopeType.NOT_DEFINED, CvssV3Data.ModifiedCiaType.NOT_DEFINED, CvssV3Data.ModifiedCiaType.NOT_DEFINED, CvssV3Data.ModifiedCiaType.NOT_DEFINED, Double.valueOf(1.0), CvssV3Data.SeverityType.NONE);
                                CvssV3 cvss = new CvssV3(null, null, cvssData, Double.valueOf(rsV.getDouble(19)), Double.valueOf(rsV.getDouble(20)));
                                vuln.setCvssV3(cvss);
                            }
                            break block112;
                        }
                        LOGGER.debug(cve + " does not exist in the database");
                        org.owasp.dependencycheck.dependency.Vulnerability vulnerability = null;
                        return vulnerability;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable rsV) {
                    throwable2 = rsV;
                    throw rsV;
                }
            }
            throwable2 = null;
            try (PreparedStatement psCWE = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VULNERABILITY_CWE, cveId);){
                throwable = null;
                try (ResultSet rsC = psCWE.executeQuery();){
                    while (rsC.next()) {
                        vuln.addCwe(rsC.getString(1));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable rsC) {
                throwable2 = rsC;
                throw rsC;
            }
            throwable2 = null;
            try (PreparedStatement psR = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_REFERENCES, cveId);){
                throwable = null;
                try (ResultSet rsR = psR.executeQuery();){
                    while (rsR.next()) {
                        vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable rsR) {
                throwable2 = rsR;
                throw rsR;
            }
            throwable2 = null;
            try (PreparedStatement psS = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_SOFTWARE, cveId);){
                throwable = null;
                try (ResultSet rsS = psS.executeQuery();){
                    while (rsS.next()) {
                        vulnerableSoftwareBuilder.part(rsS.getString(1)).vendor(rsS.getString(2)).product(rsS.getString(3)).version(rsS.getString(4)).update(rsS.getString(5)).edition(rsS.getString(6)).language(rsS.getString(7)).swEdition(rsS.getString(8)).targetSw(rsS.getString(9)).targetHw(rsS.getString(10)).other(rsS.getString(11)).versionEndExcluding(rsS.getString(12)).versionEndIncluding(rsS.getString(13)).versionStartExcluding(rsS.getString(14)).versionStartIncluding(rsS.getString(15)).vulnerable(rsS.getBoolean(16));
                        vuln.addVulnerableSoftware(vulnerableSoftwareBuilder.build());
                    }
                    return vuln;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException("Error retrieving " + cve, ex);
        }
        catch (CpeParsingException | CpeValidationException ex) {
            throw new DatabaseException("The database contains an invalid Vulnerable Software Entry", ex);
        }
    }

    public void updateVulnerability(DefCveItem cve, String baseEcosystem) {
        this.clearCache();
        String cveId = cve.getCve().getId();
        try {
            if (cve.getCve().getVulnStatus().toUpperCase().startsWith("REJECT")) {
                this.deleteVulnerability(cveId);
            } else if (this.cveItemConverter.testCveCpeStartWithFilter(cve)) {
                String description = this.cveItemConverter.extractDescription(cve);
                int vulnerabilityId = this.updateOrInsertVulnerability(cve, description);
                this.updateVulnerabilityInsertCwe(vulnerabilityId, cve);
                this.updateVulnerabilityInsertReferences(vulnerabilityId, cve);
                List<VulnerableSoftware> software = this.parseCpes(cve);
                this.updateVulnerabilityInsertSoftware(vulnerabilityId, cveId, software, baseEcosystem);
            }
        }
        catch (SQLException ex) {
            String msg = String.format("Error updating '%s'; %s", cveId, ex.getMessage());
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg);
        }
        catch (CpeValidationException ex) {
            String msg = String.format("Error parsing CPE entry from '%s'; %s", cveId, ex.getMessage());
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg);
        }
    }

    private void loadCpeEcosystemCache() {
        HashMap<Pair<String, String>, String> map = new HashMap<Pair<String, String>, String>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CPE_ECOSYSTEM);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Pair<String, String> key = new Pair<String, String>(rs.getString(1), rs.getString(2));
                String value = rs.getString(3);
                map.put(key, value);
            }
        }
        catch (SQLException ex) {
            String msg = String.format("Error loading the Cpe Ecosystem Cache: %s", ex.getMessage());
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
        CpeEcosystemCache.setCache(map);
    }

    private void saveCpeEcosystemCache() {
        Map<Pair<String, String>, String> map = CpeEcosystemCache.getChanged();
        if (map != null && !map.isEmpty()) {
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.MERGE_CPE_ECOSYSTEM);){
                for (Map.Entry<Pair<String, String>, String> entry : map.entrySet()) {
                    ps.setString(1, entry.getKey().getLeft());
                    ps.setString(2, entry.getKey().getRight());
                    ps.setString(3, entry.getValue());
                    if (this.isBatchInsertEnabled()) {
                        ps.addBatch();
                        continue;
                    }
                    ps.execute();
                }
                if (this.isBatchInsertEnabled()) {
                    ps.executeBatch();
                }
            }
            catch (SQLException ex) {
                String msg = String.format("Error saving the Cpe Ecosystem Cache: %s", ex.getMessage());
                LOGGER.debug(msg, (Throwable)ex);
                throw new DatabaseException(msg, ex);
            }
        }
    }

    private int updateOrInsertVulnerability(DefCveItem cve, String description) {
        int vulnerabilityId;
        block56: {
            if (CpeEcosystemCache.isEmpty()) {
                this.loadCpeEcosystemCache();
            }
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement callUpdate = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_VULNERABILITY);){
                callUpdate.setString(1, cve.getCve().getId());
                callUpdate.setString(2, description);
                Optional<CvssV2> optCvssv2 = null;
                if (cve.getCve().getMetrics() != null && cve.getCve().getMetrics().getCvssMetricV2() != null) {
                    optCvssv2 = cve.getCve().getMetrics().getCvssMetricV2().stream().sorted(Comparator.comparing(CvssV2::getType)).findFirst();
                }
                if (optCvssv2 != null && optCvssv2.isPresent()) {
                    CvssV2 cvssv2 = (CvssV2)optCvssv2.get();
                    this.setUpdateColumn(callUpdate, 3, cvssv2.getBaseSeverity());
                    this.setUpdateColumn(callUpdate, 4, cvssv2.getExploitabilityScore());
                    this.setUpdateColumn(callUpdate, 5, cvssv2.getImpactScore());
                    this.setUpdateColumn(callUpdate, 6, cvssv2.getAcInsufInfo());
                    this.setUpdateColumn(callUpdate, 7, cvssv2.getObtainAllPrivilege());
                    this.setUpdateColumn(callUpdate, 8, cvssv2.getObtainUserPrivilege());
                    this.setUpdateColumn(callUpdate, 9, cvssv2.getObtainOtherPrivilege());
                    this.setUpdateColumn(callUpdate, 10, cvssv2.getUserInteractionRequired());
                    this.setUpdateColumn(callUpdate, 11, cvssv2.getCvssData().getBaseScore());
                    this.setUpdateColumn(callUpdate, 12, cvssv2.getCvssData().getAccessVector());
                    this.setUpdateColumn(callUpdate, 13, cvssv2.getCvssData().getAccessComplexity());
                    this.setUpdateColumn(callUpdate, 14, cvssv2.getCvssData().getAuthentication());
                    this.setUpdateColumn(callUpdate, 15, cvssv2.getCvssData().getConfidentialityImpact());
                    this.setUpdateColumn(callUpdate, 16, cvssv2.getCvssData().getIntegrityImpact());
                    this.setUpdateColumn(callUpdate, 17, cvssv2.getCvssData().getAvailabilityImpact());
                    this.setUpdateColumn(callUpdate, 18, cvssv2.getCvssData().getVersion());
                } else {
                    callUpdate.setNull(3, 12);
                    callUpdate.setNull(4, 8);
                    callUpdate.setNull(5, 8);
                    callUpdate.setNull(6, 12);
                    if (this.isOracle) {
                        callUpdate.setNull(7, -7);
                        callUpdate.setNull(8, -7);
                        callUpdate.setNull(9, -7);
                        callUpdate.setNull(10, -7);
                    } else {
                        callUpdate.setNull(7, 16);
                        callUpdate.setNull(8, 16);
                        callUpdate.setNull(9, 16);
                        callUpdate.setNull(10, 16);
                    }
                    callUpdate.setNull(11, 8);
                    callUpdate.setNull(12, 12);
                    callUpdate.setNull(13, 12);
                    callUpdate.setNull(14, 12);
                    callUpdate.setNull(15, 12);
                    callUpdate.setNull(16, 12);
                    callUpdate.setNull(17, 12);
                    callUpdate.setNull(18, 12);
                }
                Optional<Object> optCvssv30 = Optional.empty();
                if (cve.getCve().getMetrics() != null && cve.getCve().getMetrics().getCvssMetricV30() != null) {
                    optCvssv30 = cve.getCve().getMetrics().getCvssMetricV30().stream().sorted(Comparator.comparing(CvssV3::getType)).findFirst();
                }
                Optional<Object> optCvssv31 = Optional.empty();
                if (cve.getCve().getMetrics() != null && cve.getCve().getMetrics().getCvssMetricV31() != null) {
                    optCvssv31 = cve.getCve().getMetrics().getCvssMetricV31().stream().sorted(Comparator.comparing(CvssV3::getType)).findFirst();
                }
                CvssV3 cvssv3 = null;
                if (optCvssv31.isPresent()) {
                    cvssv3 = (CvssV3)optCvssv31.get();
                } else if (optCvssv30.isPresent()) {
                    cvssv3 = (CvssV3)optCvssv30.get();
                }
                if (cvssv3 != null) {
                    this.setUpdateColumn(callUpdate, 19, cvssv3.getExploitabilityScore());
                    this.setUpdateColumn(callUpdate, 20, cvssv3.getImpactScore());
                    this.setUpdateColumn(callUpdate, 21, cvssv3.getCvssData().getAttackVector());
                    this.setUpdateColumn(callUpdate, 22, cvssv3.getCvssData().getAttackComplexity());
                    this.setUpdateColumn(callUpdate, 23, cvssv3.getCvssData().getPrivilegesRequired());
                    this.setUpdateColumn(callUpdate, 24, cvssv3.getCvssData().getUserInteraction());
                    this.setUpdateColumn(callUpdate, 25, cvssv3.getCvssData().getScope());
                    this.setUpdateColumn(callUpdate, 26, cvssv3.getCvssData().getConfidentialityImpact());
                    this.setUpdateColumn(callUpdate, 27, cvssv3.getCvssData().getIntegrityImpact());
                    this.setUpdateColumn(callUpdate, 28, cvssv3.getCvssData().getAvailabilityImpact());
                    this.setUpdateColumn(callUpdate, 29, cvssv3.getCvssData().getBaseScore());
                    this.setUpdateColumn(callUpdate, 30, cvssv3.getCvssData().getBaseSeverity());
                    this.setUpdateColumn(callUpdate, 31, cvssv3.getCvssData().getVersion());
                } else {
                    callUpdate.setNull(19, 8);
                    callUpdate.setNull(20, 8);
                    callUpdate.setNull(21, 12);
                    callUpdate.setNull(22, 12);
                    callUpdate.setNull(23, 12);
                    callUpdate.setNull(24, 12);
                    callUpdate.setNull(25, 12);
                    callUpdate.setNull(26, 12);
                    callUpdate.setNull(27, 12);
                    callUpdate.setNull(28, 12);
                    callUpdate.setNull(29, 8);
                    callUpdate.setNull(30, 12);
                    callUpdate.setNull(31, 12);
                }
                if (this.isOracle) {
                    try {
                        CallableStatement cs = (CallableStatement)callUpdate;
                        cs.registerOutParameter(32, (SQLType)JDBCType.INTEGER);
                        cs.executeUpdate();
                        vulnerabilityId = cs.getInt(32);
                        break block56;
                    }
                    catch (SQLException ex) {
                        String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getId());
                        throw new DatabaseException(msg, ex);
                    }
                }
                try (ResultSet rs = callUpdate.executeQuery();){
                    rs.next();
                    vulnerabilityId = rs.getInt(1);
                }
                catch (SQLException ex) {
                    String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getId());
                    throw new DatabaseException(msg, ex);
                }
            }
            catch (SQLException ex) {
                throw new UnexpectedAnalysisException(ex);
            }
        }
        return vulnerabilityId;
    }

    private void updateVulnerabilityInsertCwe(int vulnerabilityId, DefCveItem cve) throws SQLException {
        if (cve.getCve() != null && cve.getCve().getWeaknesses() != null) {
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement insertCWE = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_CWE, vulnerabilityId);){
                for (Weakness weakness : cve.getCve().getWeaknesses()) {
                    for (LangString desc : weakness.getDescription()) {
                        if (!"en".equals(desc.getLang())) continue;
                        insertCWE.setString(2, desc.getValue());
                        if (this.isBatchInsertEnabled()) {
                            insertCWE.addBatch();
                            continue;
                        }
                        insertCWE.execute();
                    }
                }
                if (this.isBatchInsertEnabled()) {
                    insertCWE.executeBatch();
                }
            }
        }
    }

    private void deleteVulnerability(String cve) throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement deleteVulnerability = this.getPreparedStatement(conn, PreparedStatementCveDb.DELETE_VULNERABILITY, cve);){
            deleteVulnerability.executeUpdate();
        }
    }

    public void updateKnownExploitedVulnerabilities(List<Vulnerability> vulnerabilities) throws DatabaseException, SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement mergeKnownVulnerability = this.getPreparedStatement(conn, PreparedStatementCveDb.MERGE_KNOWN_EXPLOITED);){
            int ctr = 0;
            for (Vulnerability v : vulnerabilities) {
                mergeKnownVulnerability.setString(1, v.getCveID());
                this.addNullableStringParameter(mergeKnownVulnerability, 2, v.getVendorProject());
                this.addNullableStringParameter(mergeKnownVulnerability, 3, v.getProduct());
                this.addNullableStringParameter(mergeKnownVulnerability, 4, v.getVulnerabilityName());
                this.addNullableStringParameter(mergeKnownVulnerability, 5, v.getDateAdded());
                this.addNullableStringParameter(mergeKnownVulnerability, 6, v.getShortDescription());
                this.addNullableStringParameter(mergeKnownVulnerability, 7, v.getRequiredAction());
                this.addNullableStringParameter(mergeKnownVulnerability, 8, v.getDueDate());
                this.addNullableStringParameter(mergeKnownVulnerability, 9, v.getNotes());
                if (this.isBatchInsertEnabled()) {
                    mergeKnownVulnerability.addBatch();
                    if (++ctr < this.getBatchSize()) continue;
                    mergeKnownVulnerability.executeBatch();
                    ctr = 0;
                    continue;
                }
                try {
                    mergeKnownVulnerability.execute();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("Duplicate entry")) {
                        String msg = String.format("Duplicate known exploited vulnerability key identified in '%s'", v.getCveID());
                        LOGGER.info(msg, (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.isBatchInsertEnabled()) {
                mergeKnownVulnerability.executeBatch();
            }
        }
    }

    private void updateVulnerabilityInsertSoftware(int vulnerabilityId, String cveId, List<VulnerableSoftware> software, String baseEcosystem) throws DatabaseException, SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement insertSoftware = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_SOFTWARE);){
            for (VulnerableSoftware parsedCpe : software) {
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setString(2, parsedCpe.getPart().getAbbreviation());
                insertSoftware.setString(3, parsedCpe.getVendor());
                insertSoftware.setString(4, parsedCpe.getProduct());
                insertSoftware.setString(5, parsedCpe.getVersion());
                insertSoftware.setString(6, parsedCpe.getUpdate());
                insertSoftware.setString(7, parsedCpe.getEdition());
                insertSoftware.setString(8, parsedCpe.getLanguage());
                insertSoftware.setString(9, parsedCpe.getSwEdition());
                insertSoftware.setString(10, parsedCpe.getTargetSw());
                insertSoftware.setString(11, parsedCpe.getTargetHw());
                insertSoftware.setString(12, parsedCpe.getOther());
                String ecosystem = CpeEcosystemCache.getEcosystem(parsedCpe.getVendor(), parsedCpe.getProduct(), this.cveItemConverter.extractEcosystem(baseEcosystem, parsedCpe));
                this.addNullableStringParameter(insertSoftware, 13, ecosystem);
                this.addNullableStringParameter(insertSoftware, 14, parsedCpe.getVersionEndExcluding());
                this.addNullableStringParameter(insertSoftware, 15, parsedCpe.getVersionEndIncluding());
                this.addNullableStringParameter(insertSoftware, 16, parsedCpe.getVersionStartExcluding());
                this.addNullableStringParameter(insertSoftware, 17, parsedCpe.getVersionStartIncluding());
                insertSoftware.setBoolean(18, parsedCpe.isVulnerable());
                if (this.isBatchInsertEnabled()) {
                    insertSoftware.addBatch();
                    continue;
                }
                try {
                    insertSoftware.execute();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("Duplicate entry")) {
                        String msg = String.format("Duplicate software key identified in '%s'", cveId);
                        LOGGER.info(msg, (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.isBatchInsertEnabled()) {
                this.executeBatch(cveId, insertSoftware);
            }
        }
    }

    private void updateVulnerabilityInsertReferences(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement insertReference = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_REFERENCE);){
            if (cve.getCve().getReferences() != null) {
                for (Reference r : cve.getCve().getReferences()) {
                    insertReference.setInt(1, vulnerabilityId);
                    String name = null;
                    if (r.getTags() != null) {
                        name = r.getTags().stream().sorted().collect(Collectors.joining(",")).toUpperCase().replaceAll("\\s", "_");
                    }
                    if (name != null) {
                        insertReference.setString(2, name);
                    } else {
                        insertReference.setNull(2, 12);
                    }
                    if (r.getUrl() != null && !r.getUrl().isEmpty()) {
                        insertReference.setString(3, r.getUrl());
                    } else {
                        insertReference.setNull(3, 12);
                    }
                    if (r.getSource() != null && !r.getSource().isEmpty()) {
                        insertReference.setString(4, r.getSource());
                    } else {
                        insertReference.setNull(4, 12);
                    }
                    if (this.isBatchInsertEnabled()) {
                        insertReference.addBatch();
                        continue;
                    }
                    insertReference.execute();
                }
            }
            if (this.isBatchInsertEnabled()) {
                insertReference.executeBatch();
            }
        }
    }

    private List<VulnerableSoftware> parseCpes(DefCveItem cve) throws CpeValidationException {
        ArrayList<VulnerableSoftware> software = new ArrayList<VulnerableSoftware>();
        List<CpeMatch> cpeEntries = cve.getCve().getConfigurations().stream().map(Config::getNodes).flatMap(Collection::stream).map(Node::getCpeMatch).flatMap(Collection::stream).filter(predicate -> predicate.getCriteria() != null).filter(predicate -> predicate.getCriteria().startsWith(this.cpeStartsWithFilter)).filter(entry -> !"CVE-2009-0754".equals(cve.getCve().getId()) || !"cpe:2.3:a:apache:apache:*:*:*:*:*:*:*:*".equals(entry.getCriteria())).collect(Collectors.toList());
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        try {
            cpeEntries.forEach(entry -> {
                builder.cpe(this.parseCpe((CpeMatch)entry, cve.getCve().getId())).versionEndExcluding(entry.getVersionEndExcluding()).versionStartExcluding(entry.getVersionStartExcluding()).versionEndIncluding(entry.getVersionEndIncluding()).versionStartIncluding(entry.getVersionStartIncluding()).vulnerable(entry.getVulnerable());
                try {
                    software.add(builder.build());
                }
                catch (CpeValidationException ex) {
                    throw new LambdaExceptionWrapper((Exception)((Object)ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (CpeValidationException)ex.getCause();
        }
        return software;
    }

    private Cpe parseCpe(CpeMatch cpe, String cveId) throws DatabaseException {
        Cpe parsedCpe;
        try {
            parsedCpe = CpeParser.parse((String)cpe.getCriteria(), (boolean)true);
        }
        catch (CpeParsingException ex) {
            LOGGER.debug("NVD (" + cveId + ") contain an invalid 2.3 CPE: " + cpe.getCriteria());
            throw new DatabaseException("Unable to parse CPE: " + cpe.getCriteria(), ex);
        }
        return parsedCpe;
    }

    private int getBatchSize() {
        int max;
        try {
            max = this.settings.getInt("database.batchinsert.maxsize");
        }
        catch (InvalidSettingException pE) {
            max = 1000;
        }
        return max;
    }

    private boolean isBatchInsertEnabled() {
        boolean batch;
        try {
            batch = this.settings.getBoolean("database.batchinsert.enabled");
        }
        catch (InvalidSettingException pE) {
            batch = false;
        }
        return batch;
    }

    private void executeBatch(String vulnId, PreparedStatement statement) throws SQLException {
        try {
            statement.executeBatch();
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("Duplicate entry")) {
                String msg = String.format("Duplicate software key identified in '%s'", vulnId);
                LOGGER.info(msg, (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataExists() {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement cs = this.getPreparedStatement(conn, PreparedStatementCveDb.COUNT_CPE);
             ResultSet rs = cs.executeQuery();){
            if (!rs.next()) return false;
            if (rs.getInt(1) <= 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            String dd;
            try {
                dd = this.settings.getDataDirectory().getAbsolutePath();
            }
            catch (IOException ex1) {
                dd = this.settings.getString("data.directory");
            }
            LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at https://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, this.settings.getString("odc.application.name")});
            LOGGER.debug("", (Throwable)ex);
        }
        return false;
    }

    public void cleanupDatabase() {
        LOGGER.info("Begin database maintenance");
        long start = System.currentTimeMillis();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement psOrphans = this.getPreparedStatement(conn, PreparedStatementCveDb.CLEANUP_ORPHANS);
             PreparedStatement psEcosystem = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_ECOSYSTEM);
             PreparedStatement psEcosystem2 = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_ECOSYSTEM2);){
            int count;
            if (psEcosystem != null && (count = psEcosystem.executeUpdate()) > 0) {
                LOGGER.info("Updated the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psEcosystem2 != null && (count = psEcosystem2.executeUpdate()) > 0) {
                LOGGER.info("Removed the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psOrphans != null && (count = psOrphans.executeUpdate()) > 0) {
                LOGGER.info("Cleaned up {} orphaned NVD records", (Object)count);
            }
            long millis = System.currentTimeMillis() - start;
            LOGGER.info("End database maintenance ({} ms)", (Object)millis);
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unexpected SQL Exception", ex);
        }
    }

    public void persistEcosystemCache() {
        this.saveCpeEcosystemCache();
        this.clearCache();
    }

    public void defrag() {
        if (this.isH2) {
            long start = System.currentTimeMillis();
            try (Connection conn = this.databaseManager.getConnection();
                 CallableStatement psCompaxt = conn.prepareCall("SHUTDOWN DEFRAG");){
                LOGGER.info("Begin database defrag");
                psCompaxt.execute();
                long millis = System.currentTimeMillis() - start;
                LOGGER.info("End database defrag ({} ms)", (Object)millis);
            }
            catch (SQLException ex) {
                LOGGER.error("An unexpected SQL Exception occurred compacting the database; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    VulnerableSoftware getMatchingSoftware(Cpe cpe, Set<VulnerableSoftware> vulnerableSoftware) {
        VulnerableSoftware matched = null;
        for (VulnerableSoftware vs : vulnerableSoftware) {
            if (!vs.matches((ICpe)cpe)) continue;
            if (matched == null) {
                matched = vs;
                continue;
            }
            if (!"*".equals(vs.getWellFormedUpdate()) || "*".equals(matched.getWellFormedUpdate())) continue;
            matched = vs;
        }
        return matched;
    }

    public void deleteUnusedCpe() {
        this.clearCache();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.DELETE_UNUSED_DICT_CPE);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
        }
    }

    public void addCpe(String cpe, String vendor, String product) {
        this.clearCache();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.ADD_DICT_CPE);){
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
        }
    }

    public Map<String, Vulnerability> getknownExploitedVulnerabilities() {
        HashMap<String, Vulnerability> known = new HashMap<String, Vulnerability>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_KNOWN_EXPLOITED_VULNERABILITIES);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Vulnerability kev = new Vulnerability();
                kev.setCveID(rs.getString(1));
                kev.setVendorProject(rs.getString(2));
                kev.setProduct(rs.getString(3));
                kev.setVulnerabilityName(rs.getString(4));
                kev.setDateAdded(rs.getString(5));
                kev.setShortDescription(rs.getString(6));
                kev.setRequiredAction(rs.getString(7));
                kev.setDueDate(rs.getString(8));
                kev.setNotes(rs.getString(9));
                known.put(kev.getCveID(), kev);
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
        return known;
    }

    private void addNullableStringParameter(PreparedStatement ps, int pos, String value) throws SQLException {
        if (value == null || value.isEmpty()) {
            ps.setNull(pos, 12);
        } else {
            ps.setString(pos, value);
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, Double value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 8);
        } else {
            ps.setDouble(i, value);
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV2Data.AuthenticationType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV2Data.CiaType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV2Data.Version value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV2Data.AccessComplexityType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV2Data.AccessVectorType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, String value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value);
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, Boolean value) throws SQLException {
        if (value == null) {
            if (this.isOracle) {
                ps.setNull(i, -7);
            } else {
                ps.setNull(i, 16);
            }
        } else {
            ps.setBoolean(i, value);
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.AttackVectorType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.AttackComplexityType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.PrivilegesRequiredType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.UserInteractionType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.ScopeType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.SeverityType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.CiaType value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setUpdateColumn(PreparedStatement ps, int i, CvssV3Data.Version value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 12);
        } else {
            ps.setString(i, value.value());
        }
    }

    private void setFloatValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            try {
                ps.setFloat(i, Float.parseFloat(props.get(key).toString()));
            }
            catch (NumberFormatException nfe) {
                ps.setNull(i, 6);
            }
        } else {
            ps.setNull(i, 6);
        }
    }

    private void setStringValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setString(i, props.get(key).toString());
        } else {
            ps.setNull(i, 12);
        }
    }

    private void setBooleanValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setBoolean(i, Boolean.parseBoolean(props.get(key).toString()));
        } else {
            ps.setNull(i, 16);
        }
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean getBooleanValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return rs.getBoolean(index);
    }

    private Float getFloatValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return Float.valueOf(rs.getFloat(index));
    }

    static enum PreparedStatementCveDb {
        CLEANUP_ORPHANS,
        UPDATE_ECOSYSTEM,
        UPDATE_ECOSYSTEM2,
        COUNT_CPE,
        DELETE_VULNERABILITY,
        INSERT_PROPERTY,
        INSERT_CWE,
        INSERT_REFERENCE,
        INSERT_SOFTWARE,
        MERGE_PROPERTY,
        SELECT_CPE_ENTRIES,
        SELECT_CVE_FROM_SOFTWARE,
        SELECT_PROPERTIES,
        SELECT_VULNERABILITY_CWE,
        SELECT_REFERENCES,
        SELECT_SOFTWARE,
        SELECT_VENDOR_PRODUCT_LIST,
        SELECT_VENDOR_PRODUCT_LIST_FOR_NODE,
        SELECT_VULNERABILITY,
        UPDATE_PROPERTY,
        UPDATE_VULNERABILITY,
        SELECT_CPE_ECOSYSTEM,
        MERGE_CPE_ECOSYSTEM,
        DELETE_UNUSED_DICT_CPE,
        ADD_DICT_CPE,
        SELECT_KNOWN_EXPLOITED_VULNERABILITIES,
        MERGE_KNOWN_EXPLOITED;

    }
}

