/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.reporting.SarifRule;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.values.Part;

public class ReportTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTool.class);

    public String identifierToSuppressionId(Identifier id) {
        if (id instanceof PurlIdentifier) {
            PurlIdentifier purl = (PurlIdentifier)id;
            return purl.toString();
        }
        if (id instanceof CpeIdentifier) {
            try {
                CpeIdentifier cpeId = (CpeIdentifier)id;
                Cpe cpe = cpeId.getCpe();
                return String.format("cpe:/%s:%s:%s", Convert.wellFormedToCpeUri((Part)cpe.getPart()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedVendor()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedProduct()));
            }
            catch (CpeEncodingException ex) {
                LOGGER.debug("Unable to convert to cpe URI", (Throwable)ex);
            }
        } else if (id instanceof GenericIdentifier) {
            return id.getValue();
        }
        return null;
    }

    public Double estimateSeverity(String severity) {
        return SeverityUtil.estimateCvssV2(severity);
    }

    public Collection<SarifRule> convertToSarifRules(List<Dependency> dependencies) {
        HashMap<String, SarifRule> rules = new HashMap<String, SarifRule>();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (rules.containsKey(v.getName())) continue;
                SarifRule r = new SarifRule(v.getName(), this.buildShortDescription(d, v, v.getKnownExploitedVulnerability() != null), this.buildDescription(v.getDescription(), v.getKnownExploitedVulnerability()), v.getSource().name(), v.getCvssV2(), v.getCvssV3());
                rules.put(v.getName(), r);
            }
        }
        return rules.values();
    }

    private String determineScore(Vulnerability vuln) {
        if (vuln.getUnscoredSeverity() != null) {
            if ("0.0".equals(vuln.getUnscoredSeverity())) {
                return "unknown";
            }
            return this.normalizeSeverity(vuln.getUnscoredSeverity().toLowerCase());
        }
        if (vuln.getCvssV3() != null && vuln.getCvssV3().getCvssData().getBaseSeverity() != null) {
            return this.normalizeSeverity(vuln.getCvssV3().getCvssData().getBaseSeverity().value().toLowerCase());
        }
        if (vuln.getCvssV2() != null && vuln.getCvssV2().getCvssData().getBaseSeverity() != null) {
            return this.normalizeSeverity(vuln.getCvssV2().getCvssData().getBaseSeverity());
        }
        return "unknown";
    }

    private String normalizeSeverity(String sev) {
        switch (sev.toLowerCase()) {
            case "critical": {
                return "critical";
            }
            case "high": {
                return "high";
            }
            case "medium": 
            case "moderate": {
                return "medium";
            }
            case "low": 
            case "informational": 
            case "info": {
                return "low";
            }
        }
        return "unknown";
    }

    private String buildShortDescription(Dependency d, Vulnerability vuln, boolean knownExploited) {
        String cwe;
        StringBuilder sb = new StringBuilder();
        sb.append(this.determineScore(vuln)).append(" severity - ").append(vuln.getName());
        if (!(vuln.getCwes() == null || vuln.getCwes().isEmpty() || (cwe = vuln.getCwes().getFullCwes().values().iterator().next()) == null || "NVD-CWE-Other".equals(cwe) || "NVD-CWE-noinfo".equals(cwe))) {
            sb.append(" ").append(cwe);
        }
        sb.append(" vulnerability in ");
        if (d.getSoftwareIdentifiers() != null && !d.getSoftwareIdentifiers().isEmpty()) {
            sb.append(d.getSoftwareIdentifiers().iterator().next());
        } else {
            sb.append(d.getDisplayFileName());
        }
        if (knownExploited) {
            sb.append(" *Known Exploited Vulnerability*");
        }
        return sb.toString();
    }

    private String buildDescription(String description, org.owasp.dependencycheck.data.knownexploited.json.Vulnerability knownExploitedVulnerability) {
        StringBuilder sb = new StringBuilder();
        if (knownExploitedVulnerability != null) {
            sb.append("CISA Known Exploited Vulnerability\n");
            if (knownExploitedVulnerability.getVendorProject() != null) {
                sb.append("Vendor/Project: ").append(knownExploitedVulnerability.getVendorProject()).append("\n");
            }
            if (knownExploitedVulnerability.getProduct() != null) {
                sb.append("Product: ").append(knownExploitedVulnerability.getProduct()).append("\n");
            }
            if (knownExploitedVulnerability.getVulnerabilityName() != null) {
                sb.append("Vulnerability Name: ").append(knownExploitedVulnerability.getVulnerabilityName()).append("\n");
            }
            if (knownExploitedVulnerability.getDateAdded() != null) {
                sb.append("Date Added: ").append(knownExploitedVulnerability.getDateAdded()).append("\n");
            }
            if (knownExploitedVulnerability.getShortDescription() != null) {
                sb.append("Short Description: ").append(knownExploitedVulnerability.getShortDescription()).append("\n");
            }
            if (knownExploitedVulnerability.getRequiredAction() != null) {
                sb.append("Required Action: ").append(knownExploitedVulnerability.getRequiredAction()).append("\n");
            }
            if (knownExploitedVulnerability.getDueDate() != null) {
                sb.append("Due Date").append(knownExploitedVulnerability.getDueDate()).append("\n");
            }
            if (knownExploitedVulnerability.getNotes() != null) {
                sb.append("Notes: ").append(knownExploitedVulnerability.getNotes()).append("\n");
            }
            sb.append("\n");
        }
        sb.append(description);
        return sb.toString();
    }
}

