/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.owasp.dependencycheck.data.lucene.AlphaNumericFilter;
import org.owasp.dependencycheck.data.lucene.TokenPairConcatenatingFilter;
import org.owasp.dependencycheck.data.lucene.UrlTokenizingFilter;

public class SearchFieldAnalyzer
extends Analyzer {
    private static final String[] ADDITIONAL_STOP_WORDS = new String[]{"software", "framework", "inc", "com", "org", "net", "www", "consulting", "ltd", "foundation", "project"};
    private final CharArraySet stopWords = SearchFieldAnalyzer.getStopWords();
    private TokenPairConcatenatingFilter concatenatingFilter;

    public static CharArraySet getStopWords() {
        CharArraySet words = StopFilter.makeStopSet((String[])ADDITIONAL_STOP_WORDS, (boolean)true);
        words.addAll((Collection)EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
        return words;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        WhitespaceTokenizer source;
        Object stream = source = new WhitespaceTokenizer();
        stream = new UrlTokenizingFilter((TokenStream)stream);
        stream = new AlphaNumericFilter((TokenStream)stream);
        stream = new WordDelimiterGraphFilter((TokenStream)stream, 481, null);
        stream = new LowerCaseFilter((TokenStream)stream);
        stream = new StopFilter((TokenStream)stream, this.stopWords);
        this.concatenatingFilter = new TokenPairConcatenatingFilter((TokenStream)stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)this.concatenatingFilter);
    }

    public void reset() throws IOException {
        if (this.concatenatingFilter != null) {
            this.concatenatingFilter.clear();
        }
    }
}

