/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PinnedMavenInstallAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinnedMavenInstallAnalyzer.class);
    private static final String ANALYZER_NAME = "Pinned Maven install Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Pattern MAVEN_INSTALL_JSON_PATTERN = Pattern.compile("(.+install.*|.*install.+)\\.json");
    private static final FileFilter FILTER = file -> MAVEN_INSTALL_JSON_PATTERN.matcher(file.getName()).matches();
    private static final ObjectReader INSTALL_FILE_READER;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.maveninstall.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        List<MavenDependency> deps;
        DependencyTree tree;
        LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
        File dependencyFile = dependency.getActualFile();
        if (!dependencyFile.isFile() || dependencyFile.length() == 0L) {
            return;
        }
        try {
            InstallFile installFile = (InstallFile)INSTALL_FILE_READER.readValue(dependencyFile);
            tree = installFile.getDependencyTree();
        }
        catch (IOException e) {
            return;
        }
        if (tree == null) {
            return;
        }
        if (!Objects.equals(tree.getAutogeneratedSentinel(), "THERE_IS_NO_DATA_ONLY_ZUUL")) {
            return;
        }
        engine.removeDependency(dependency);
        if (!Objects.equals(tree.getVersion(), "0.1.0")) {
            LOGGER.warn("Unsupported pinned maven_install.json version {}. Continuing optimistically.", (Object)tree.getVersion());
        }
        if ((deps = tree.getDependencies()) == null) {
            deps = Collections.emptyList();
        }
        for (MavenDependency dep : deps) {
            String version;
            if (dep.getCoord() == null) {
                LOGGER.warn("Unexpected null coordinate in {}", (Object)dependency.getActualFilePath());
                continue;
            }
            LOGGER.debug("Analyzing {}", (Object)dep.getCoord());
            String[] pieces = dep.getCoord().split(":");
            if (pieces.length < 3 || pieces.length > 5) {
                LOGGER.warn("Invalid maven coordinate {}", (Object)dep.getCoord());
                continue;
            }
            String group = pieces[0];
            String artifact = pieces[1];
            String classifier = null;
            if (pieces.length == 3) {
                version = pieces[2];
            } else if (pieces.length == 4) {
                classifier = pieces[2];
                version = pieces[3];
            } else {
                classifier = pieces[3];
                version = pieces[4];
            }
            if ("sources".equals(classifier) || "javadoc".equals(classifier)) {
                LOGGER.debug("Skipping sources jar {}", (Object)dep.getCoord());
                continue;
            }
            Dependency d = new Dependency(dependency.getActualFile(), true);
            d.setEcosystem("java");
            d.addEvidence(EvidenceType.VENDOR, "project", "groupid", group, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.PRODUCT, "project", "artifactid", artifact, Confidence.HIGHEST);
            d.addEvidence(EvidenceType.VERSION, "project", "version", version, Confidence.HIGHEST);
            d.setName(String.format("%s:%s", group, artifact));
            d.setFilePath(String.format("%s>>%s", dependency.getActualFile(), dep.getCoord()));
            d.setFileName(dep.getCoord());
            try {
                PackageURLBuilder purl = PackageURLBuilder.aPackageURL().withType("maven").withNamespace(group).withName(artifact).withVersion(version);
                if (classifier != null) {
                    purl.withQualifier("classifier", classifier);
                }
                d.addSoftwareIdentifier(new PurlIdentifier(purl.build(), Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException e) {
                d.addSoftwareIdentifier(new GenericIdentifier("maven_install JSON coord " + dep.getCoord(), Confidence.HIGH));
            }
            d.setVersion(version);
            engine.addDependency(d);
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        INSTALL_FILE_READER = mapper.readerFor(InstallFile.class);
    }

    private static class MavenDependency {
        @JsonProperty(value="coord")
        private String coord;

        private MavenDependency() {
        }

        public String getCoord() {
            return this.coord;
        }
    }

    private static class DependencyTree {
        @JsonProperty(value="__AUTOGENERATED_FILE_DO_NOT_MODIFY_THIS_FILE_MANUALLY")
        private String autogeneratedSentinel;
        @JsonProperty(value="dependencies")
        private List<MavenDependency> dependencies;
        @JsonProperty(value="version")
        private String version;

        private DependencyTree() {
        }

        public String getAutogeneratedSentinel() {
            return this.autogeneratedSentinel;
        }

        public List<MavenDependency> getDependencies() {
            return this.dependencies;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static class InstallFile {
        @JsonProperty(value="dependency_tree")
        private DependencyTree dependencyTree;

        private InstallFile() {
        }

        public DependencyTree getDependencyTree() {
            return this.dependencyTree;
        }
    }
}

