/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class DependencyVersion
implements Iterable<String>,
Comparable<DependencyVersion> {
    private List<String> versionParts;

    public DependencyVersion() {
    }

    public DependencyVersion(String version) {
        this.parseVersion(version);
    }

    public final void parseVersion(String version) {
        this.versionParts = new ArrayList<String>();
        if (version != null) {
            Pattern rx = Pattern.compile("(\\d+[a-z]{1,3}$|[a-z]{1,3}[_-]?\\d+|\\d+|(rc|release|snapshot|beta|alpha)$)", 2);
            Matcher matcher = rx.matcher(version.toLowerCase());
            while (matcher.find()) {
                this.versionParts.add(matcher.group());
            }
            if (this.versionParts.isEmpty()) {
                this.versionParts.add(version);
            }
        }
    }

    public List<String> getVersionParts() {
        return this.versionParts;
    }

    public void setVersionParts(List<String> versionParts) {
        this.versionParts = versionParts;
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.versionParts.iterator();
    }

    public String toString() {
        return StringUtils.join(this.versionParts, (char)'.');
    }

    public boolean equals(Object obj) {
        int i;
        int maxVersionMatchLength;
        if (obj == null || !(obj instanceof DependencyVersion)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DependencyVersion other = (DependencyVersion)obj;
        int minVersionMatchLength = this.versionParts.size() < other.versionParts.size() ? this.versionParts.size() : other.versionParts.size();
        int n = maxVersionMatchLength = this.versionParts.size() > other.versionParts.size() ? this.versionParts.size() : other.versionParts.size();
        if (minVersionMatchLength == 1 && maxVersionMatchLength >= 3) {
            return false;
        }
        for (i = 0; i < minVersionMatchLength; ++i) {
            String otherPart;
            String thisPart = this.versionParts.get(i);
            if (thisPart.equals(otherPart = other.versionParts.get(i))) continue;
            return false;
        }
        if (this.versionParts.size() > minVersionMatchLength) {
            for (i = minVersionMatchLength; i < this.versionParts.size(); ++i) {
                if ("0".equals(this.versionParts.get(i))) continue;
                return false;
            }
        }
        if (other.versionParts.size() > minVersionMatchLength) {
            for (i = minVersionMatchLength; i < other.versionParts.size(); ++i) {
                if ("0".equals(other.versionParts.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 71).append(this.versionParts).toHashCode();
    }

    public boolean matchesAtLeastThreeLevels(DependencyVersion version) {
        if (version == null) {
            return false;
        }
        if (Math.abs(this.versionParts.size() - version.versionParts.size()) >= 3) {
            return false;
        }
        int max = this.versionParts.size() < version.versionParts.size() ? this.versionParts.size() : version.versionParts.size();
        boolean ret = true;
        for (int i = 0; i < max; ++i) {
            String thisVersion = this.versionParts.get(i);
            String otherVersion = version.getVersionParts().get(i);
            if (i >= 3) {
                if (thisVersion.compareToIgnoreCase(otherVersion) < 0) continue;
                ret = false;
                break;
            }
            if (thisVersion.equals(otherVersion)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    public int compareTo(@NotNull DependencyVersion version) {
        if (version == null) {
            return 1;
        }
        List<String> left = this.getVersionParts();
        List<String> right = version.getVersionParts();
        int max = left.size() < right.size() ? left.size() : right.size();
        for (int i = 0; i < max; ++i) {
            String rStr;
            String lStr = left.get(i);
            if (lStr.equals(rStr = right.get(i))) continue;
            try {
                int l = Integer.parseInt(lStr);
                int r = Integer.parseInt(rStr);
                if (l < r) {
                    return -1;
                }
                if (l <= r) continue;
                return 1;
            }
            catch (NumberFormatException ex) {
                int comp = left.get(i).compareTo(right.get(i));
                if (comp < 0) {
                    return -1;
                }
                if (comp <= 0) continue;
                return 1;
            }
        }
        return Integer.compare(left.size(), right.size());
    }
}

