/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.processing.MixAuditProcessor;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@Experimental
public class ElixirMixAuditAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElixirMixAuditAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "exlixir";
    private static final String ANALYZER_NAME = "Elixir Mix Audit Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("mix.lock").build();
    public static final String NAME = "Name: ";
    public static final String VERSION = "Version: ";
    public static final String ADVISORY = "Advisory: ";
    public static final String CRITICALITY = "Criticality: ";
    private CveDB cvedb = null;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        String mixAuditVersionDetails;
        Process process;
        if (engine != null) {
            this.cvedb = engine.getDatabase();
        }
        try {
            List<String> mixAuditArgs = Arrays.asList("--version");
            process = this.launchMixAudit(this.getSettings().getTempDirectory(), mixAuditArgs);
        }
        catch (AnalysisException ae) {
            this.setEnabled(false);
            String msg = String.format("Exception from mix_audit process: %s. Disabling %s", ae.getCause(), ANALYZER_NAME);
            throw new InitializationException(msg, ae);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create temporary file, the Mix Audit Analyzer will be disabled", ex);
        }
        try (ProcessReader processReader = new ProcessReader(process);){
            processReader.readAll();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                if (StringUtils.isBlank((CharSequence)processReader.getError())) {
                    LOGGER.warn("Unexpected exit value from mix_audit process and error stream unexpectedly not ready to capture error details. Disabling {}. Exit value was: {}", (Object)ANALYZER_NAME, (Object)exitValue);
                    this.setEnabled(false);
                    throw new InitializationException("mix_audit error stream unexpectedly not ready.");
                }
                this.setEnabled(false);
                LOGGER.warn("Unexpected exit value from mix_audit process. Disabling {}. Exit value was: {}. error stream output from mix_audit process was: {}", new Object[]{ANALYZER_NAME, exitValue, processReader.getError()});
                throw new InitializationException("Unexpected exit value from bundle-audit process.");
            }
            if (StringUtils.isBlank((CharSequence)processReader.getOutput())) {
                LOGGER.warn("mix_audit input stream unexpectedly not ready to capture version details. Disabling {}", (Object)ANALYZER_NAME);
                this.setEnabled(false);
                throw new InitializationException("mix_audit input stream unexpectedly not ready to capture version details.");
            }
            mixAuditVersionDetails = processReader.getOutput();
        }
        catch (InterruptedException ex) {
            this.setEnabled(false);
            String msg = String.format("mix_audit process was interrupted. Disabling %s", ANALYZER_NAME);
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            String msg = String.format("IOException '%s' during mix_audit process was interrupted. Disabling %s", ex.getMessage(), ANALYZER_NAME);
            throw new InitializationException(msg);
        }
        if (this.isEnabled()) {
            LOGGER.debug("{} is enabled and is using mix_audit with version: {}.", (Object)ANALYZER_NAME, (Object)mixAuditVersionDetails);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.mix.audit.enabled";
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    private Process launchMixAudit(File folder, List<String> mixAuditArgs) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        String mixAuditPath = this.getSettings().getString("analyzer.mix.audit.path");
        File mixAudit = null;
        if (mixAuditPath != null) {
            mixAudit = new File(mixAuditPath);
            if (!mixAudit.isFile()) {
                LOGGER.warn("Supplied `mixAudit` path is incorrect: {}", (Object)mixAuditPath);
                mixAudit = null;
            }
        } else {
            Path homePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path escriptPath = Paths.get(homePath.toString(), ".mix", "escripts", "mix_audit");
            mixAudit = escriptPath.toFile();
        }
        args.add(mixAudit != null ? mixAudit.getAbsolutePath() : "mix_audit");
        args.addAll(mixAuditArgs);
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("mix_audit initialization failure; this error can be ignored if you are not analyzing Elixir. Otherwise ensure that mix_audit is installed and the path to mix_audit is correctly specified", ioe);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File parentFile = dependency.getActualFile().getParentFile();
        List<String> mixAuditArgs = Arrays.asList("--format", "json");
        Process process = this.launchMixAudit(parentFile, mixAuditArgs);
        try (MixAuditProcessor processor = new MixAuditProcessor(dependency, engine);
             ProcessReader processReader = new ProcessReader(process, (Processor)processor);){
            processReader.readAll();
            int exitValue = process.exitValue();
            if (exitValue < 0 || exitValue > 1) {
                String msg = String.format("Unexpected exit code from mix_audit process; exit code: %s", exitValue);
                throw new AnalysisException(msg);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("mix_audit process interrupted", ie);
        }
        catch (IOException | CpeValidationException ioe) {
            LOGGER.warn("mix_audit failure", ioe);
            throw new AnalysisException("mix_audit failure", ioe);
        }
    }
}

