/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmPayloadBuilder;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class YarnAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnAuditAnalyzer.class);
    public static final String YARN_PACKAGE_LOCK = "yarn.lock";
    private static final FileFilter LOCK_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("yarn.lock").build();
    private static final String EXPECTED_ERROR = "{\"type\":\"error\",\"data\":\"Can't make a request in offline mode (\\\"https://registry.yarnpkg.com/-/npm/v1/security/audits\\\")\"}\n";
    private String yarnPath;

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File packageLock;
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(packageLock = dependency.getActualFile()).isFile() || packageLock.length() == 0L || !YarnAuditAnalyzer.shouldProcess(packageLock)) {
            return;
        }
        File packageJson = new File(packageLock.getParentFile(), "package.json");
        HashMap<String, String> dependencyMap = new HashMap<String, String>();
        List<Advisory> advisories = this.analyzePackage(packageLock, packageJson, dependency, dependencyMap);
        try {
            this.processResults(advisories, engine, dependency, dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.yarn.audit.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return LOCK_FILE_FILTER;
    }

    @Override
    public String getName() {
        return "Yarn Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        super.prepareFileTypeAnalyzer(engine);
        if (!this.isEnabled()) {
            LOGGER.debug("{} Analyzer is disabled skipping yarn executable check", (Object)this.getName());
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getYarn());
        args.add("--help");
        ProcessBuilder builder = new ProcessBuilder(args);
        LOGGER.debug("Launching: {}", args);
        try {
            Process process = builder.start();
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                int exitValue = process.waitFor();
                boolean expectedExitValue = false;
                int yarnExecutableNotFoundExitValue = 127;
                switch (exitValue) {
                    case 0: {
                        LOGGER.debug("{} is enabled.", (Object)this.getName());
                        return;
                    }
                    case 127: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Yarn executable was not found.", (Object)this.getName());
                    }
                    default: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Yarn executable was not found.", (Object)this.getName());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.setEnabled(false);
            LOGGER.debug("The {} has been disabled. Yarn executable was not found.", (Throwable)ex);
            LOGGER.warn("The {} has been disabled. Yarn executable was not found.", (Object)this.getName());
            throw new InitializationException("Unable to read yarn audit output.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getYarn() {
        String value;
        YarnAuditAnalyzer yarnAuditAnalyzer = this;
        synchronized (yarnAuditAnalyzer) {
            if (this.yarnPath == null) {
                String path = this.getSettings().getString("analyzer.yarn.path");
                if (path == null) {
                    this.yarnPath = "yarn";
                } else {
                    File yarnFile = new File(path);
                    if (yarnFile.isFile()) {
                        this.yarnPath = yarnFile.getAbsolutePath();
                    } else {
                        LOGGER.warn("Provided path to `yarn` executable is invalid.");
                        this.yarnPath = "yarn";
                    }
                }
            }
            value = this.yarnPath;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject fetchYarnAuditJson(Dependency dependency, boolean skipDevDependencies) throws AnalysisException {
        File folder = dependency.getActualFile().getParentFile();
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.getYarn());
            args.add("audit");
            args.add("--offline");
            if (skipDevDependencies) {
                args.add("--groups");
                args.add("dependencies");
            }
            args.add("--json");
            args.add("--verbose");
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.directory(folder);
            LOGGER.debug("Launching: {}", args);
            Process process = builder.start();
            try (ProcessReader processReader = new ProcessReader(process);){
                String auditRequest;
                processReader.readAll();
                String errOutput = processReader.getError();
                if (!StringUtils.isBlank((CharSequence)errOutput) && !EXPECTED_ERROR.equals(errOutput)) {
                    LOGGER.debug("Process Error Out: {}", (Object)errOutput);
                    LOGGER.debug("Process Out: {}", (Object)processReader.getOutput());
                }
                String verboseJson = Arrays.stream(processReader.getOutput().split("\n")).filter(line -> line.contains("Audit Request")).findFirst().get();
                try (JsonReader reader = Json.createReader((InputStream)IOUtils.toInputStream((String)verboseJson, (Charset)StandardCharsets.UTF_8));){
                    JsonObject jsonObject = reader.readObject();
                    auditRequest = jsonObject.getString("data");
                    auditRequest = auditRequest.substring(15);
                }
                LOGGER.debug("Audit Request: {}", (Object)auditRequest);
                JsonObject jsonObject = Json.createReader((InputStream)IOUtils.toInputStream((String)auditRequest, (Charset)StandardCharsets.UTF_8)).readObject();
                return jsonObject;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new AnalysisException("Yarn audit process was interrupted.", ex);
            }
        }
        catch (IOException ioe) {
            throw new AnalysisException("yarn audit failure; this error can be ignored if you are not analyzing projects with a yarn lockfile.", ioe);
        }
    }

    private List<Advisory> analyzePackage(File lockFile, File packageFile, Dependency dependency, Map<String, String> dependencyMap) throws AnalysisException {
        try {
            Boolean skipDevDependencies = this.getSettings().getBoolean("analyzer.node.audit.skipdev", false);
            JsonObject lockJson = this.fetchYarnAuditJson(dependency, skipDevDependencies);
            JsonReader packageReader = Json.createReader((InputStream)FileUtils.openInputStream((File)packageFile));
            JsonObject packageJson = packageReader.readObject();
            JsonObject payload = NpmPayloadBuilder.build(lockJson, packageJson, dependencyMap, skipDevDependencies);
            return this.getSearcher().submitPackage(payload);
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the NPM Audit API (YarnAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the NPM Audit API (YarnAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (YarnAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("YarnAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }
}

