/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.ossindex;

import java.io.File;
import java.io.IOException;
import org.joda.time.Duration;
import org.owasp.dependencycheck.data.ossindex.ODCConnectionTransport;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.packageurl.RenderFlavor;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.cache.CacheConfiguration;
import org.sonatype.ossindex.service.client.cache.DirectoryCache;
import org.sonatype.ossindex.service.client.internal.OssindexClientImpl;
import org.sonatype.ossindex.service.client.marshal.GsonMarshaller;
import org.sonatype.ossindex.service.client.marshal.Marshaller;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public final class OssindexClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OssindexClientFactory.class);

    private OssindexClientFactory() {
    }

    public static OssindexClient create(Settings settings) {
        OssindexClientConfiguration config = new OssindexClientConfiguration();
        String baseUrl = settings.getString("analyzer.ossindex.url", null);
        if (baseUrl != null) {
            config.setBaseUrl(baseUrl);
        }
        String username = settings.getString("analyzer.ossindex.user");
        String password = settings.getString("analyzer.ossindex.password");
        if (username != null && password != null) {
            AuthConfiguration auth = new AuthConfiguration(username, password);
            config.setAuthConfiguration(auth);
        }
        if (settings.getBoolean("analyzer.ossindex.use.cache", true)) {
            DirectoryCache.Configuration cache = new DirectoryCache.Configuration();
            try {
                File data = settings.getDataDirectory();
                File cacheDir = new File(data, "oss_cache");
                if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
                    cache.setBaseDir(cacheDir.toPath());
                    cache.setExpireAfter(Duration.standardHours((long)24L));
                    config.setCacheConfiguration((CacheConfiguration)cache);
                    LOGGER.debug("OSS Index Cache: " + cache.toString());
                } else {
                    LOGGER.warn("Unable to use a cache for the OSS Index");
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to use a cache for the OSS Index", (Throwable)ex);
            }
        }
        UserAgentSupplier userAgent = new UserAgentSupplier("dependency-check", settings.getString("odc.application.version", "unknown"));
        ODCConnectionTransport transport = new ODCConnectionTransport(settings, config, userAgent);
        GsonMarshaller marshaller = new GsonMarshaller();
        return new OssindexClientImpl(config, (Transport)transport, (Marshaller)marshaller);
    }

    static {
        RenderFlavor.setDefault((RenderFlavor)RenderFlavor.SCHEME);
    }
}

