/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.data.nvd.ecosystem.DescriptionEcosystemMapper;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlEcosystemMapper;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.DefCpeMatch;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;

@NotThreadSafe
public class CveEcosystemMapper {
    private final DescriptionEcosystemMapper descriptionEcosystemMapper = new DescriptionEcosystemMapper();
    private final UrlEcosystemMapper urlEcosystemMapper = new UrlEcosystemMapper();

    public String getEcosystem(DefCveItem cve) {
        if (this.hasMultipleVendorProductConfigurations(cve)) {
            return null;
        }
        String ecosystem = this.descriptionEcosystemMapper.getEcosystem(cve);
        if (ecosystem != null) {
            return ecosystem;
        }
        return this.urlEcosystemMapper.getEcosystem(cve);
    }

    private boolean hasMultipleVendorProductConfigurations(DefCveItem cve) {
        List cpeEntries = cve.getConfigurations().getNodes().stream().collect(NodeFlatteningCollector.getInstance()).collect(CpeMatchStreamCollector.getInstance()).collect(Collectors.toList());
        if (!cpeEntries.isEmpty() && cpeEntries.size() > 1) {
            DefCpeMatch firstMatch = (DefCpeMatch)cpeEntries.get(0);
            String uri = firstMatch.getCpe23Uri();
            int pos = uri.indexOf(":", uri.indexOf(":", 10) + 1);
            String match = uri.substring(0, pos + 1);
            return !cpeEntries.stream().allMatch(e -> e.getCpe23Uri().startsWith(match));
        }
        return false;
    }
}

