/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import com.google.common.io.ByteStreams;
import com.h3xstream.retirejs.repo.JsLibrary;
import com.h3xstream.retirejs.repo.JsLibraryResult;
import com.h3xstream.retirejs.repo.JsVulnerability;
import com.h3xstream.retirejs.repo.ScannerFacade;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepository;
import com.h3xstream.retirejs.repo.VulnerabilitiesRepositoryLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.json.JSONException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.RetireJSDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.exception.WriteLockException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.WriteLock;
import org.owasp.dependencycheck.utils.search.FileContentSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetireJsAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "js";
    private static final Logger LOGGER = LoggerFactory.getLogger(RetireJsAnalyzer.class);
    private static final String ANALYZER_NAME = "RetireJS Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.FINDING_ANALYSIS;
    private static final String[] EXTENSIONS = new String[]{"js"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(EXTENSIONS).build();
    private VulnerabilitiesRepository jsRepository;
    private String[] filters = null;
    private boolean skipNonVulnerableInJAR = true;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public boolean accept(File pathname) {
        try {
            boolean accepted = super.accept(pathname);
            if (accepted && !pathname.exists()) {
                super.setFilesMatched(true);
                return true;
            }
            if (accepted && this.filters != null && FileContentSearch.contains((File)pathname, (String[])this.filters)) {
                return false;
            }
            return accepted;
        }
        catch (IOException ex) {
            LOGGER.warn(String.format("Error testing file %s", pathname), (Throwable)ex);
            return false;
        }
    }

    @Override
    public void initialize(Settings settings) {
        super.initialize(settings);
        if (this.isEnabled()) {
            this.filters = settings.getArray("analyzer.retirejs.filters");
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        Throwable throwable;
        File repoFile = null;
        boolean repoEmpty = false;
        try {
            String configuredUrl = this.getSettings().getString("analyzer.retirejs.repo.js.url", "https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json");
            URL url = new URL(configuredUrl);
            File filepath = new File(url.getPath());
            repoFile = new File(this.getSettings().getDataDirectory(), filepath.getName());
            if (!repoFile.isFile() || repoFile.length() <= 1L) {
                LOGGER.warn("Retire JS repository is empty or missing - attempting to force the update");
                repoEmpty = true;
                this.getSettings().setBoolean("analyzer.retirejs.forceupdate", true);
            }
        }
        catch (FileNotFoundException ex) {
            this.setEnabled(false);
            throw new InitializationException(String.format("RetireJS repo does not exist locally (%s)", repoFile), ex);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to initialize the RetireJS", ex);
        }
        boolean autoupdate = this.getSettings().getBoolean("odc.autoupdate", true);
        boolean forceupdate = this.getSettings().getBoolean("analyzer.retirejs.forceupdate", false);
        if (!autoupdate && forceupdate || autoupdate && repoEmpty) {
            RetireJSDataSource ds = new RetireJSDataSource();
            try {
                ds.update(engine);
            }
            catch (UpdateException ex) {
                throw new InitializationException("Unable to initialize the Retire JS respository", ex);
            }
        }
        try {
            throwable = null;
            try (WriteLock lock = new WriteLock(this.getSettings(), true, repoFile.getName() + ".lock");){
                File temp = this.getSettings().getTempDirectory();
                File tempRepo = new File(temp, repoFile.getName());
                LOGGER.debug("copying retireJs repo {} to {}", (Object)repoFile.toPath(), (Object)tempRepo.toPath());
                Files.copy(repoFile.toPath(), tempRepo.toPath(), new CopyOption[0]);
                repoFile = tempRepo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | WriteLockException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to copy the RetireJS repo", ex);
        }
        try {
            throwable = null;
            try (FileInputStream in = new FileInputStream(repoFile);){
                this.jsRepository = new VulnerabilitiesRepositoryLoader().loadFromInputStream((InputStream)in);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (JSONException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to initialize the RetireJS repo: `" + repoFile.toString() + "` appears to be malformed. Please delete the file or run the dependency-check purge command and re-try running dependency-check.", ex);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Failed to initialize the RetireJS repo", ex);
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.retirejs.enabled";
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        block47: {
            try (FileInputStream fis = new FileInputStream(dependency.getActualFile());){
                List results;
                byte[] fileContent = ByteStreams.toByteArray((InputStream)fis);
                ScannerFacade scanner = new ScannerFacade(this.jsRepository);
                try {
                    results = scanner.scanScript(dependency.getActualFile().getAbsolutePath(), fileContent, 0);
                }
                catch (StackOverflowError ex) {
                    String msg = String.format("An error occured trying to analyze %s. To resolve this error please try increasing the Java stack size to 8mb and re-run dependency-check:%n%n(win) : set JAVA_OPTS=\"-Xss8192k\"%n(*nix): export JAVA_OPTS=\"-Xss8192k\"%n%n", dependency.getDisplayFileName());
                    throw new AnalysisException(msg, ex);
                }
                if (results.size() > 0) {
                    for (JsLibraryResult libraryResult : results) {
                        JsLibrary lib = libraryResult.getLibrary();
                        dependency.setName(lib.getName());
                        dependency.setVersion(libraryResult.getDetectedVersion());
                        try {
                            PackageURL purl = PackageURLBuilder.aPackageURL().withType("javascript").withName(lib.getName()).withVersion(libraryResult.getDetectedVersion()).build();
                            dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                        }
                        catch (MalformedPackageURLException ex) {
                            LOGGER.debug("Unable to build package url for retireJS", (Throwable)ex);
                            GenericIdentifier id = new GenericIdentifier("javascript:" + lib.getName() + "@" + libraryResult.getDetectedVersion(), Confidence.HIGHEST);
                            dependency.addSoftwareIdentifier(id);
                        }
                        dependency.addEvidence(EvidenceType.VERSION, "file", "version", libraryResult.getDetectedVersion(), Confidence.HIGH);
                        dependency.addEvidence(EvidenceType.PRODUCT, "file", "name", libraryResult.getLibrary().getName(), Confidence.HIGH);
                        dependency.addEvidence(EvidenceType.VENDOR, "file", "name", libraryResult.getLibrary().getName(), Confidence.HIGH);
                        ArrayList<Vulnerability> vulns = new ArrayList<Vulnerability>();
                        JsVulnerability jsVuln = libraryResult.getVuln();
                        if (jsVuln.getIdentifiers().containsKey("CVE") || jsVuln.getIdentifiers().containsKey("osvdb")) {
                            for (Map.Entry entry : jsVuln.getIdentifiers().entrySet()) {
                                String key = (String)entry.getKey();
                                List value = (List)entry.getValue();
                                if ("CVE".equals(key)) {
                                    for (String cve : value) {
                                        Vulnerability vuln = engine.getDatabase().getVulnerability(StringUtils.trim((String)cve));
                                        if (vuln == null) {
                                            vuln = new Vulnerability();
                                            vuln.setName(cve);
                                            vuln.setUnscoredSeverity(jsVuln.getSeverity());
                                            vuln.setSource(Vulnerability.Source.RETIREJS);
                                        }
                                        jsVuln.getInfo().stream().map(info -> {
                                            if (UrlValidator.getInstance().isValid(info)) {
                                                return new Reference((String)info, "info", (String)info);
                                            }
                                            return new Reference((String)info, "info", null);
                                        }).forEach(vuln::addReference);
                                        vulns.add(vuln);
                                    }
                                } else if ("osvdb".equals(key)) {
                                    value.forEach(osvdb -> {
                                        Vulnerability vuln = new Vulnerability();
                                        vuln.setName((String)osvdb);
                                        vuln.setSource(Vulnerability.Source.RETIREJS);
                                        vuln.setUnscoredSeverity(jsVuln.getSeverity());
                                        jsVuln.getInfo().stream().map(info -> {
                                            if (UrlValidator.getInstance().isValid(info)) {
                                                return new Reference((String)info, "info", (String)info);
                                            }
                                            return new Reference((String)info, "info", null);
                                        }).forEach(vuln::addReference);
                                        vulns.add(vuln);
                                    });
                                }
                                dependency.addVulnerabilities(vulns);
                            }
                            continue;
                        }
                        Vulnerability individualVuln = new Vulnerability();
                        block30: for (Map.Entry entry : jsVuln.getIdentifiers().entrySet()) {
                            String key = (String)entry.getKey();
                            List value = (List)entry.getValue();
                            if (null == key) continue;
                            switch (key) {
                                case "summary": {
                                    if (null == individualVuln.getName()) {
                                        individualVuln.setName((String)value.get(0));
                                    }
                                    individualVuln.setDescription((String)value.get(0));
                                    continue block30;
                                }
                                case "issue": {
                                    individualVuln.setName(libraryResult.getLibrary().getName() + " issue: " + (String)value.get(0));
                                    if (UrlValidator.getInstance().isValid((String)value.get(0))) {
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        continue block30;
                                    }
                                    individualVuln.addReference(key, (String)value.get(0), null);
                                    continue block30;
                                }
                                case "bug": {
                                    individualVuln.setName(libraryResult.getLibrary().getName() + " bug: " + (String)value.get(0));
                                    if (UrlValidator.getInstance().isValid((String)value.get(0))) {
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        continue block30;
                                    }
                                    individualVuln.addReference(key, (String)value.get(0), null);
                                    continue block30;
                                }
                                case "pr": {
                                    individualVuln.setName(libraryResult.getLibrary().getName() + " pr: " + (String)value.get(0));
                                    if (UrlValidator.getInstance().isValid((String)value.get(0))) {
                                        individualVuln.addReference(key, key, (String)value.get(0));
                                        continue block30;
                                    }
                                    individualVuln.addReference(key, (String)value.get(0), null);
                                    continue block30;
                                }
                            }
                            if (UrlValidator.getInstance().isValid((String)value.get(0))) {
                                individualVuln.addReference(key, key, (String)value.get(0));
                                continue;
                            }
                            individualVuln.addReference(key, (String)value.get(0), null);
                        }
                        if (StringUtils.isEmpty((CharSequence)individualVuln.getName())) {
                            individualVuln.setName("Vulnerability in " + libraryResult.getLibrary().getName());
                        }
                        individualVuln.setSource(Vulnerability.Source.RETIREJS);
                        individualVuln.setUnscoredSeverity(jsVuln.getSeverity());
                        jsVuln.getInfo().stream().map(info -> {
                            if (UrlValidator.getInstance().isValid(info)) {
                                return new Reference((String)info, "info", (String)info);
                            }
                            return new Reference((String)info, "info", null);
                        }).forEach(individualVuln::addReference);
                        dependency.addVulnerability(individualVuln);
                    }
                    break block47;
                }
                if (this.getSettings().getBoolean("analyzer.retirejs.filternonvulnerable", false)) {
                    engine.removeDependency(dependency);
                }
            }
            catch (IOException | DatabaseException e) {
                throw new AnalysisException(e);
            }
        }
    }
}

