/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.tools.SimpleResultSet;

public class H2Functions {
    public static void insertSoftware(Connection conn, int vulnerabilityId, String part, String vendor, String product, String version, String update, String edition, String language, String swEdition, String targetSw, String targetHw, String other, String ecosystem, String versionEndExcluding, String versionEndIncluding, String versionStartExcluding, String versionStartIncluding, Boolean vulnerable) throws SQLException {
        int cpeID = 0;
        PreparedStatement selectCpeId = conn.prepareStatement("SELECT id, ecosystem FROM cpeEntry WHERE part=? AND vendor=? AND product=? AND version=? AND update_version=? AND edition=? AND lang=? AND sw_edition=? AND target_sw=? AND target_hw=? AND other=?");
        selectCpeId.setString(1, part);
        selectCpeId.setString(2, vendor);
        selectCpeId.setString(3, product);
        selectCpeId.setString(4, version);
        selectCpeId.setString(5, update);
        selectCpeId.setString(6, edition);
        selectCpeId.setString(7, language);
        selectCpeId.setString(8, swEdition);
        selectCpeId.setString(9, targetSw);
        selectCpeId.setString(10, targetHw);
        selectCpeId.setString(11, other);
        try (ResultSet rs = selectCpeId.executeQuery();){
            if (rs.next()) {
                cpeID = rs.getInt(1);
                String e = rs.getString(2);
                if (e == null && ecosystem != null) {
                    PreparedStatement updateEcosystem = conn.prepareStatement("UPDATE cpeEntry SET ecosystem=? WHERE id=?");
                    updateEcosystem.setString(1, ecosystem);
                    updateEcosystem.setInt(2, cpeID);
                }
            }
        }
        if (cpeID == 0) {
            String[] returnedColumns = new String[]{"id"};
            PreparedStatement insertCpe = conn.prepareStatement("INSERT INTO cpeEntry (part, vendor, product, version, update_version, edition, lang, sw_edition, target_sw, target_hw, other, ecosystem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", returnedColumns);
            insertCpe.setString(1, part);
            insertCpe.setString(2, vendor);
            insertCpe.setString(3, product);
            insertCpe.setString(4, version);
            insertCpe.setString(5, update);
            insertCpe.setString(6, edition);
            insertCpe.setString(7, language);
            insertCpe.setString(8, swEdition);
            insertCpe.setString(9, targetSw);
            insertCpe.setString(10, targetHw);
            insertCpe.setString(11, other);
            H2Functions.setStringOrNull(insertCpe, 12, ecosystem);
            insertCpe.executeUpdate();
            try (ResultSet rs = insertCpe.getGeneratedKeys();){
                if (rs.next()) {
                    cpeID = rs.getInt(1);
                }
            }
        }
        PreparedStatement insertSoftware = conn.prepareStatement("INSERT INTO software (cveid, cpeEntryId, versionEndExcluding, versionEndIncluding, versionStartExcluding, versionStartIncluding, vulnerable) VALUES (?, ?, ?, ?, ?, ?, ?)");
        insertSoftware.setInt(1, vulnerabilityId);
        insertSoftware.setInt(2, cpeID);
        H2Functions.setStringOrNull(insertSoftware, 3, versionEndExcluding);
        H2Functions.setStringOrNull(insertSoftware, 4, versionEndIncluding);
        H2Functions.setStringOrNull(insertSoftware, 5, versionStartExcluding);
        H2Functions.setStringOrNull(insertSoftware, 6, versionStartIncluding);
        H2Functions.setBooleanOrNull(insertSoftware, 7, vulnerable);
        insertSoftware.execute();
    }

    public static ResultSet updateVulnerability(Connection conn, String cve, String description, String v2Severity, Float v2ExploitabilityScore, Float v2ImpactScore, Boolean v2AcInsufInfo, Boolean v2ObtainAllPrivilege, Boolean v2ObtainUserPrivilege, Boolean v2ObtainOtherPrivilege, Boolean v2UserInteractionRequired, Float v2Score, String v2AccessVector, String v2AccessComplexity, String v2Authentication, String v2ConfidentialityImpact, String v2IntegrityImpact, String v2AvailabilityImpact, String v2Version, Float v3ExploitabilityScore, Float v3ImpactScore, String v3AttackVector, String v3AttackComplexity, String v3PrivilegesRequired, String v3UserInteraction, String v3Scope, String v3ConfidentialityImpact, String v3IntegrityImpact, String v3AvailabilityImpact, Float v3BaseScore, String v3BaseSeverity, String v3Version) throws SQLException {
        PreparedStatement merge;
        SimpleResultSet ret = new SimpleResultSet();
        ret.addColumn("id", 4, 10, 0);
        int vulnerabilityId = 0;
        PreparedStatement selectVulnerabilityId = conn.prepareStatement("SELECT id FROM VULNERABILITY CVE WHERE cve=?");
        selectVulnerabilityId.setString(1, cve);
        try (ResultSet rs = selectVulnerabilityId.executeQuery();){
            if (rs.next()) {
                vulnerabilityId = rs.getInt(1);
            }
        }
        if (vulnerabilityId > 0) {
            try (PreparedStatement refs = conn.prepareStatement("DELETE FROM reference WHERE cveid = ?");){
                refs.setInt(1, vulnerabilityId);
                refs.executeUpdate();
            }
            var37_40 = null;
            try (PreparedStatement software = conn.prepareStatement("DELETE FROM software WHERE cveid = ?");){
                software.setInt(1, vulnerabilityId);
                software.executeUpdate();
            }
            catch (Throwable throwable) {
                var37_40 = throwable;
                throw throwable;
            }
            var37_40 = null;
            try (PreparedStatement cwe = conn.prepareStatement("DELETE FROM cweEntry WHERE cveid = ?");){
                cwe.setInt(1, vulnerabilityId);
                cwe.executeUpdate();
            }
            catch (Throwable throwable) {
                var37_40 = throwable;
                throw throwable;
            }
            merge = conn.prepareStatement("UPDATE VULNERABILITY SET description=?, v2Severity=?, v2ExploitabilityScore=?, v2ImpactScore=?, v2AcInsufInfo=?, v2ObtainAllPrivilege=?, v2ObtainUserPrivilege=?, v2ObtainOtherPrivilege=?, v2UserInteractionRequired=?, v2Score=?, v2AccessVector=?, v2AccessComplexity=?, v2Authentication=?, v2ConfidentialityImpact=?, v2IntegrityImpact=?, v2AvailabilityImpact=?, v2Version=?, v3ExploitabilityScore=?, v3ImpactScore=?, v3AttackVector=?, v3AttackComplexity=?, v3PrivilegesRequired=?, v3UserInteraction=?, v3Scope=?, v3ConfidentialityImpact=?, v3IntegrityImpact=?, v3AvailabilityImpact=?, v3BaseScore=?, v3BaseSeverity=?, v3Version=? WHERE id=?");
        } else {
            String[] returnedColumns = new String[]{"id"};
            merge = conn.prepareStatement("INSERT INTO VULNERABILITY (description, v2Severity, v2ExploitabilityScore, v2ImpactScore, v2AcInsufInfo, v2ObtainAllPrivilege, v2ObtainUserPrivilege, v2ObtainOtherPrivilege, v2UserInteractionRequired, v2Score, v2AccessVector, v2AccessComplexity, v2Authentication, v2ConfidentialityImpact, v2IntegrityImpact, v2AvailabilityImpact, v2Version, v3ExploitabilityScore, v3ImpactScore, v3AttackVector, v3AttackComplexity, v3PrivilegesRequired, v3UserInteraction, v3Scope, v3ConfidentialityImpact, v3IntegrityImpact, v3AvailabilityImpact, v3BaseScore, v3BaseSeverity, v3Version, cve) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", returnedColumns);
        }
        merge.setString(1, description);
        H2Functions.setStringOrNull(merge, 2, v2Severity);
        H2Functions.setFloatOrNull(merge, 3, v2ExploitabilityScore);
        H2Functions.setFloatOrNull(merge, 4, v2ImpactScore);
        H2Functions.setBooleanOrNull(merge, 5, v2AcInsufInfo);
        H2Functions.setBooleanOrNull(merge, 6, v2ObtainAllPrivilege);
        H2Functions.setBooleanOrNull(merge, 7, v2ObtainUserPrivilege);
        H2Functions.setBooleanOrNull(merge, 8, v2ObtainOtherPrivilege);
        H2Functions.setBooleanOrNull(merge, 9, v2UserInteractionRequired);
        H2Functions.setFloatOrNull(merge, 10, v2Score);
        H2Functions.setStringOrNull(merge, 11, v2AccessVector);
        H2Functions.setStringOrNull(merge, 12, v2AccessComplexity);
        H2Functions.setStringOrNull(merge, 13, v2Authentication);
        H2Functions.setStringOrNull(merge, 14, v2ConfidentialityImpact);
        H2Functions.setStringOrNull(merge, 15, v2IntegrityImpact);
        H2Functions.setStringOrNull(merge, 16, v2AvailabilityImpact);
        H2Functions.setStringOrNull(merge, 17, v2Version);
        H2Functions.setFloatOrNull(merge, 18, v3ExploitabilityScore);
        H2Functions.setFloatOrNull(merge, 19, v3ImpactScore);
        H2Functions.setStringOrNull(merge, 20, v3AttackVector);
        H2Functions.setStringOrNull(merge, 21, v3AttackComplexity);
        H2Functions.setStringOrNull(merge, 22, v3PrivilegesRequired);
        H2Functions.setStringOrNull(merge, 23, v3UserInteraction);
        H2Functions.setStringOrNull(merge, 24, v3Scope);
        H2Functions.setStringOrNull(merge, 25, v3ConfidentialityImpact);
        H2Functions.setStringOrNull(merge, 26, v3IntegrityImpact);
        H2Functions.setStringOrNull(merge, 27, v3AvailabilityImpact);
        H2Functions.setFloatOrNull(merge, 28, v3BaseScore);
        H2Functions.setStringOrNull(merge, 29, v3BaseSeverity);
        H2Functions.setStringOrNull(merge, 30, v3Version);
        if (vulnerabilityId == 0) {
            merge.setString(31, cve);
        } else {
            merge.setInt(31, vulnerabilityId);
        }
        int count = merge.executeUpdate();
        if (vulnerabilityId == 0) {
            try (ResultSet rs = merge.getGeneratedKeys();){
                if (rs.next()) {
                    vulnerabilityId = rs.getInt(1);
                }
            }
        }
        ret.addRow(new Object[]{vulnerabilityId});
        return ret;
    }

    private static void setStringOrNull(PreparedStatement ps, int i, String value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setString(i, value);
        }
    }

    private static void setFloatOrNull(PreparedStatement ps, int i, Float value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setFloat(i, value.floatValue());
        }
    }

    private static void setBooleanOrNull(PreparedStatement ps, int i, Boolean value) throws SQLException {
        if (value == null) {
            ps.setNull(i, 0);
        } else {
            ps.setBoolean(i, value);
        }
    }
}

