/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV2;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV3;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.DefCpeMatch;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.LangString;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;
import org.owasp.dependencycheck.data.nvd.json.ProblemtypeDatum;
import org.owasp.dependencycheck.data.nvd.json.Reference;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.cpe.CpePlus;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.CvssV3;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public final class CveDB
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    private final ConnectionFactory connectionFactory;
    private Connection connection;
    private ResourceBundle statementBundle;
    private DatabaseProperties databaseProperties;
    private final EnumMap<PreparedStatementCveDb, PreparedStatement> preparedStatements = new EnumMap(PreparedStatementCveDb.class);
    private final VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
    private final String cpeStartsWithFilter;
    private final Map<String, List<Vulnerability>> vulnerabilitiesForCpeCache = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final Settings settings;

    private String determineBaseEcosystem(String description) {
        if (description == null) {
            return null;
        }
        int idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".php");
        if (idx > 0 && (idx + 4 == description.length() || !Character.isLetterOrDigit(description.charAt(idx + 4))) || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"wordpress") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"drupal") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"joomla") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"moodle") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"typo3")) {
            return "Composer";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" npm ") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"node module") && StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)".js") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" node.js")) {
            return "npm";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".pm");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "perl";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".pl");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "perl";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".java");
        if (!(idx <= 0 || idx + 5 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 5)))) {
            return "Java";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".jsp");
        if (!(idx <= 0 || idx + 4 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 4)))) {
            return "Java";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" grails ")) {
            return "Java";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".rb");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "ruby";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"ruby gem")) {
            return "ruby";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".py");
        if (idx > 0 && (idx + 3 == description.length() || !Character.isLetterOrDigit(description.charAt(idx + 3))) || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"django")) {
            return "python";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"buffer overflow") && !StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"android")) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".c");
        if (!(idx <= 0 || idx + 2 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 2)))) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".cpp");
        if (!(idx <= 0 || idx + 4 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 4)))) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".h");
        if (!(idx <= 0 || idx + 2 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 2)))) {
            return "CMAKE";
        }
        return null;
    }

    private String determineEcosystem(String baseEcosystem, String vendor, String product, String targetSw) {
        if ("ibm".equals(vendor) && "java".equals(product)) {
            return "c/c++";
        }
        if ("oracle".equals(vendor) && "vm".equals(product)) {
            return "c/c++";
        }
        if ("*".equals(targetSw) || baseEcosystem != null) {
            return baseEcosystem;
        }
        return targetSw;
    }

    public CveDB(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.cpeStartsWithFilter = this.settings.getString("cve.cpe.startswith.filter", "cpe:2.3:a:");
        this.connectionFactory = new ConnectionFactory(settings);
        this.open();
    }

    private String determineDatabaseProductName(Connection conn) {
        try {
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            LOGGER.debug("Database product: {}", (Object)databaseProductName);
            return databaseProductName;
        }
        catch (SQLException se) {
            LOGGER.warn("Problem determining database product!", (Throwable)se);
            return null;
        }
    }

    private synchronized void open() throws DatabaseException {
        try {
            if (!this.isOpen()) {
                this.connection = this.connectionFactory.getConnection();
                String databaseProductName = this.determineDatabaseProductName(this.connection);
                this.statementBundle = databaseProductName != null ? ResourceBundle.getBundle("data/dbStatements", new Locale(databaseProductName)) : ResourceBundle.getBundle("data/dbStatements");
                this.prepareStatements();
                this.databaseProperties = new DatabaseProperties(this);
            }
        }
        catch (DatabaseException e) {
            this.releaseResources();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.clearCache();
            this.closeStatements();
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                LOGGER.error("There was an error attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.releaseResources();
            this.connectionFactory.cleanup();
        }
    }

    private synchronized void releaseResources() {
        this.statementBundle = null;
        this.preparedStatements.clear();
        this.databaseProperties = null;
        this.connection = null;
    }

    protected synchronized boolean isOpen() {
        return this.connection != null;
    }

    private void prepareStatements() throws DatabaseException {
        for (PreparedStatementCveDb key : PreparedStatementCveDb.values()) {
            PreparedStatement preparedStatement;
            block4: {
                preparedStatement = null;
                try {
                    String statementString = this.statementBundle.getString(key.name());
                    preparedStatement = key == PreparedStatementCveDb.INSERT_VULNERABILITY || key == PreparedStatementCveDb.INSERT_CPE ? this.connection.prepareStatement(statementString, new String[]{"id"}) : this.connection.prepareStatement(statementString);
                }
                catch (SQLException ex) {
                    throw new DatabaseException(ex);
                }
                catch (MissingResourceException ex) {
                    if (ex.getMessage().contains("key MERGE_PROPERTY")) break block4;
                    throw new DatabaseException(ex);
                }
            }
            if (preparedStatement == null) continue;
            this.preparedStatements.put(key, preparedStatement);
        }
    }

    private PreparedStatement prepareStatement(PreparedStatementCveDb key) throws DatabaseException {
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            try {
                String statementString = this.statementBundle.getString(key.name());
                if (key == PreparedStatementCveDb.INSERT_VULNERABILITY || key == PreparedStatementCveDb.INSERT_CPE) {
                    String[] returnedColumns = new String[]{"id"};
                    preparedStatement = this.connection.prepareStatement(statementString, returnedColumns);
                } else {
                    preparedStatement = this.connection.prepareStatement(statementString);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
            catch (MissingResourceException ex) {
                if (ex.getMessage().contains("key MERGE_PROPERTY")) break block5;
                throw new DatabaseException(ex);
            }
        }
        return preparedStatement;
    }

    private synchronized void closeStatements() {
        this.preparedStatements.values().forEach(preparedStatement -> DBUtils.closeStatement(preparedStatement));
    }

    private synchronized PreparedStatement getPreparedStatement(PreparedStatementCveDb key) throws SQLException {
        if (!this.preparedStatements.containsKey((Object)key)) {
            return null;
        }
        PreparedStatement preparedStatement = this.preparedStatements.get((Object)key);
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    public synchronized void commit() throws SQLException {
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public synchronized DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    protected synchronized DatabaseProperties reloadProperties() {
        this.databaseProperties = new DatabaseProperties(this);
        return this.databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<CpePlus> getCPEs(String vendor, String product) {
        HashSet<CpePlus> cpe = new HashSet<CpePlus>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CPE_ENTRIES);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_CPE_ENTRIES));
            }
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            CpeBuilder builder = new CpeBuilder();
            while (rs.next()) {
                Cpe entry = builder.part(rs.getString(1)).vendor(rs.getString(2)).product(rs.getString(3)).version(rs.getString(4)).update(rs.getString(5)).edition(rs.getString(6)).language(rs.getString(7)).swEdition(rs.getString(8)).targetSw(rs.getString(9)).targetHw(rs.getString(10)).other(rs.getString(11)).build();
                CpePlus plus = new CpePlus(entry, rs.getString(12));
                cpe.add(plus);
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException | CpeParsingException | CpeValidationException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", ex);
        }
        finally {
            DBUtils.closeResultSet(rs);
        }
        return cpe;
    }

    public synchronized Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    public synchronized Set<Pair<String, String>> getVendorProductListForNode() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getProperties() {
        Properties prop = new Properties();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_PROPERTIES);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_PROPERTIES));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
        }
        DBUtils.closeResultSet(rs);
        return prop;
    }

    public synchronized void saveProperty(String key, String value) {
        this.clearCache();
        try {
            PreparedStatement mergeProperty = this.getPreparedStatement(PreparedStatementCveDb.MERGE_PROPERTY);
            if (mergeProperty != null) {
                mergeProperty.setString(1, key);
                mergeProperty.setString(2, value);
                mergeProperty.execute();
            } else {
                PreparedStatement updateProperty = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_PROPERTY);
                if (updateProperty == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.UPDATE_PROPERTY));
                }
                updateProperty.setString(1, value);
                updateProperty.setString(2, key);
                if (updateProperty.executeUpdate() == 0) {
                    PreparedStatement insertProperty = this.getPreparedStatement(PreparedStatementCveDb.INSERT_PROPERTY);
                    if (insertProperty == null) {
                        throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_PROPERTY));
                    }
                    insertProperty.setString(1, key);
                    insertProperty.setString(2, value);
                    insertProperty.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
            LOGGER.debug("", (Throwable)ex);
        }
    }

    private synchronized void clearCache() {
        this.vulnerabilitiesForCpeCache.clear();
    }

    public synchronized List<Vulnerability> getVulnerabilities(Cpe cpe) throws DatabaseException {
        List<Vulnerability> cachedVulnerabilities = this.vulnerabilitiesForCpeCache.get(cpe.toCpe23FS());
        if (cachedVulnerabilities != null) {
            LOGGER.debug("Cache hit for {}", (Object)cpe.toCpe23FS());
            return cachedVulnerabilities;
        }
        LOGGER.debug("Cache miss for {}", (Object)cpe.toCpe23FS());
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        ResultSet rs = null;
        try {
            Vulnerability v;
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CVE_FROM_SOFTWARE);
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            String currentCVE = "";
            HashSet<VulnerableSoftware> vulnSoftware = new HashSet<VulnerableSoftware>();
            while (rs.next()) {
                VulnerableSoftware vs;
                String cveId = rs.getString(1);
                if (currentCVE.isEmpty()) {
                    currentCVE = cveId;
                }
                if (!vulnSoftware.isEmpty() && !currentCVE.equals(cveId)) {
                    Vulnerability v2;
                    VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                    if (matchedCPE != null && (v2 = this.getVulnerability(currentCVE)) != null) {
                        v2.setMatchedVulnerableSoftware(matchedCPE);
                        v2.setSource(Vulnerability.Source.NVD);
                        vulnerabilities.add(v2);
                    }
                    vulnSoftware.clear();
                    currentCVE = cveId;
                }
                try {
                    vs = this.vulnerableSoftwareBuilder.part(rs.getString(2)).vendor(rs.getString(3)).product(rs.getString(4)).version(rs.getString(5)).update(rs.getString(6)).edition(rs.getString(7)).language(rs.getString(8)).swEdition(rs.getString(9)).targetSw(rs.getString(10)).targetHw(rs.getString(11)).other(rs.getString(12)).versionEndExcluding(rs.getString(13)).versionEndIncluding(rs.getString(14)).versionStartExcluding(rs.getString(15)).versionStartIncluding(rs.getString(16)).vulnerable(rs.getBoolean(17)).build();
                }
                catch (CpeParsingException | CpeValidationException ex) {
                    throw new DatabaseException("Database contains an invalid Vulnerable Software Entry", ex);
                }
                vulnSoftware.add(vs);
            }
            VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
            if (matchedCPE != null && (v = this.getVulnerability(currentCVE)) != null) {
                v.setMatchedVulnerableSoftware(matchedCPE);
                v.setSource(Vulnerability.Source.NVD);
                vulnerabilities.add(v);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpe.toCpe23FS(), ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        this.vulnerabilitiesForCpeCache.put(cpe.toCpe23FS(), vulnerabilities);
        return vulnerabilities;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vulnerability getVulnerability(String cve) throws DatabaseException {
        ResultSet rsV = null;
        ResultSet rsC = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            PreparedStatement psV = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VULNERABILITY);
            if (psV == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VULNERABILITY));
            }
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                PreparedStatement psCWE;
                Serializable cvss;
                vuln = new Vulnerability();
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                vuln.setSource(Vulnerability.Source.NVD);
                int cveId = rsV.getInt(1);
                if (rsV.getString(4) != null) {
                    cvss = new CvssV2(rsV.getFloat(3), rsV.getString(4), rsV.getString(5), rsV.getString(6), rsV.getString(7), rsV.getString(7), rsV.getString(9), rsV.getString(10));
                    vuln.setCvssV2((CvssV2)cvss);
                }
                if (rsV.getString(11) != null) {
                    cvss = new CvssV3(rsV.getString(11), rsV.getString(12), rsV.getString(13), rsV.getString(14), rsV.getString(15), rsV.getString(16), rsV.getString(17), rsV.getString(18), rsV.getFloat(19), rsV.getString(20));
                    vuln.setCvssV3((CvssV3)cvss);
                }
                if ((psCWE = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VULNERABILITY_CWE)) == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VULNERABILITY_CWE));
                }
                psCWE.setInt(1, cveId);
                rsC = psCWE.executeQuery();
                while (rsC.next()) {
                    vuln.addCwe(rsC.getString(1));
                }
                PreparedStatement psR = this.getPreparedStatement(PreparedStatementCveDb.SELECT_REFERENCES);
                if (psR == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_REFERENCES));
                }
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                PreparedStatement psS = this.getPreparedStatement(PreparedStatementCveDb.SELECT_SOFTWARE);
                if (psS == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_SOFTWARE));
                }
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    this.vulnerableSoftwareBuilder.part(rsS.getString(1)).vendor(rsS.getString(2)).product(rsS.getString(3)).version(rsS.getString(4)).update(rsS.getString(5)).edition(rsS.getString(6)).language(rsS.getString(7)).swEdition(rsS.getString(8)).targetSw(rsS.getString(9)).targetHw(rsS.getString(10)).other(rsS.getString(11)).versionEndExcluding(rsS.getString(12)).versionEndIncluding(rsS.getString(13)).versionStartExcluding(rsS.getString(14)).versionStartIncluding(rsS.getString(15)).vulnerable(rsS.getBoolean(16));
                    vuln.addVulnerableSoftware(this.vulnerableSoftwareBuilder.build());
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
                catch (CpeParsingException | CpeValidationException ex2) {
                    throw new DatabaseException("The database contains an invalid Vulnerable Software Entry", ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rsV);
                DBUtils.closeResultSet(rsC);
                DBUtils.closeResultSet(rsR);
                DBUtils.closeResultSet(rsS);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rsV);
        DBUtils.closeResultSet(rsC);
        DBUtils.closeResultSet(rsR);
        DBUtils.closeResultSet(rsS);
        return vuln;
    }

    public void updateVulnerability(DefCveItem cve) {
        this.clearCache();
        String cveId = cve.getCve().getCVEDataMeta().getId();
        try {
            int vulnerabilityId = this.updateVulnerabilityGetVulnerabilityId(cveId);
            String description = cve.getCve().getDescription().getDescriptionData().stream().filter(desc -> "en".equals(desc.getLang())).map(d -> d.getValue()).collect(Collectors.joining(" "));
            if (vulnerabilityId != 0) {
                if (description.trim().startsWith("** REJECT **")) {
                    this.updateVulnerabilityDeleteVulnerability(vulnerabilityId);
                } else {
                    this.updateVulnerabilityUpdateVulnerability(vulnerabilityId, cve, description);
                }
            } else {
                if (description.trim().startsWith("** REJECT **")) {
                    return;
                }
                vulnerabilityId = this.updateVulnerabilityInsertVulnerability(cve, description);
            }
            this.updateVulnerabilityInsertCwe(vulnerabilityId, cve);
            String baseEcosystem = this.determineBaseEcosystem(description);
            baseEcosystem = this.updateVulnerabilityInsertReferences(vulnerabilityId, cve, baseEcosystem);
            List<VulnerableSoftware> software = this.parseCpes(cve);
            this.updateVulnerabilityInsertSoftware(vulnerabilityId, cveId, software, baseEcosystem);
        }
        catch (SQLException ex) {
            String msg = String.format("Error updating '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
        catch (CpeValidationException ex) {
            String msg = String.format("Error parsing CPE entry from '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
    }

    @SuppressFBWarnings(justification="Try with resources will cleanup the resources", value={"OBL_UNSATISFIED_OBLIGATION"})
    private synchronized int updateVulnerabilityGetVulnerabilityId(String cveId) {
        int vulnerabilityId = 0;
        try (PreparedStatement selectVulnerabilityId = this.prepareStatement(PreparedStatementCveDb.SELECT_VULNERABILITY_ID);
             PreparedStatement deleteReference = this.prepareStatement(PreparedStatementCveDb.DELETE_REFERENCE);
             PreparedStatement deleteSoftware = this.prepareStatement(PreparedStatementCveDb.DELETE_SOFTWARE);
             PreparedStatement deleteCwe = this.prepareStatement(PreparedStatementCveDb.DELETE_CWE);){
            if (selectVulnerabilityId == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VULNERABILITY_ID));
            }
            if (deleteReference == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.DELETE_REFERENCE));
            }
            if (deleteSoftware == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.DELETE_SOFTWARE));
            }
            if (deleteCwe == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.DELETE_CWE));
            }
            selectVulnerabilityId.setString(1, cveId);
            try (ResultSet rs = selectVulnerabilityId.executeQuery();){
                if (rs.next()) {
                    vulnerabilityId = rs.getInt(1);
                    deleteReference.setInt(1, vulnerabilityId);
                    deleteReference.execute();
                    deleteSoftware.setInt(1, vulnerabilityId);
                    deleteSoftware.execute();
                    deleteCwe.setInt(1, vulnerabilityId);
                    deleteCwe.execute();
                }
            }
        }
        catch (SQLException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
        return vulnerabilityId;
    }

    private synchronized int updateVulnerabilityInsertVulnerability(DefCveItem cve, String description) {
        int vulnerabilityId;
        try (PreparedStatement insertVulnerability = this.prepareStatement(PreparedStatementCveDb.INSERT_VULNERABILITY);){
            if (insertVulnerability == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_VULNERABILITY));
            }
            insertVulnerability.setString(1, cve.getCve().getCVEDataMeta().getId());
            insertVulnerability.setString(2, description);
            if (cve.getImpact().getBaseMetricV2() != null) {
                BaseMetricV2 cvssv2 = cve.getImpact().getBaseMetricV2();
                insertVulnerability.setFloat(3, cvssv2.getCvssV2().getBaseScore().floatValue());
                insertVulnerability.setString(4, cvssv2.getCvssV2().getAccessVector().value());
                insertVulnerability.setString(5, cvssv2.getCvssV2().getAccessComplexity().value());
                insertVulnerability.setString(6, cvssv2.getCvssV2().getAuthentication().value());
                insertVulnerability.setString(7, cvssv2.getCvssV2().getConfidentialityImpact().value());
                insertVulnerability.setString(8, cvssv2.getCvssV2().getIntegrityImpact().value());
                insertVulnerability.setString(9, cvssv2.getCvssV2().getAvailabilityImpact().value());
                insertVulnerability.setString(10, cvssv2.getSeverity());
            } else {
                insertVulnerability.setNull(3, 0);
                insertVulnerability.setNull(4, 0);
                insertVulnerability.setNull(5, 0);
                insertVulnerability.setNull(6, 0);
                insertVulnerability.setNull(7, 0);
                insertVulnerability.setNull(8, 0);
                insertVulnerability.setNull(9, 0);
                insertVulnerability.setNull(10, 0);
            }
            if (cve.getImpact().getBaseMetricV3() != null) {
                BaseMetricV3 cvssv3 = cve.getImpact().getBaseMetricV3();
                insertVulnerability.setString(11, cvssv3.getCvssV3().getAttackVector().value());
                insertVulnerability.setString(12, cvssv3.getCvssV3().getAttackComplexity().value());
                insertVulnerability.setString(13, cvssv3.getCvssV3().getPrivilegesRequired().value());
                insertVulnerability.setString(14, cvssv3.getCvssV3().getUserInteraction().value());
                insertVulnerability.setString(15, cvssv3.getCvssV3().getScope().value());
                insertVulnerability.setString(16, cvssv3.getCvssV3().getConfidentialityImpact().value());
                insertVulnerability.setString(17, cvssv3.getCvssV3().getIntegrityImpact().value());
                insertVulnerability.setString(18, cvssv3.getCvssV3().getAvailabilityImpact().value());
                insertVulnerability.setFloat(19, cvssv3.getCvssV3().getBaseScore().floatValue());
                insertVulnerability.setString(20, cvssv3.getCvssV3().getBaseSeverity().value());
            } else {
                insertVulnerability.setNull(11, 0);
                insertVulnerability.setNull(12, 0);
                insertVulnerability.setNull(13, 0);
                insertVulnerability.setNull(14, 0);
                insertVulnerability.setNull(15, 0);
                insertVulnerability.setNull(16, 0);
                insertVulnerability.setNull(17, 0);
                insertVulnerability.setNull(18, 0);
                insertVulnerability.setNull(19, 0);
                insertVulnerability.setNull(20, 0);
            }
            insertVulnerability.execute();
            try (ResultSet rs = insertVulnerability.getGeneratedKeys();){
                rs.next();
                vulnerabilityId = rs.getInt(1);
            }
            catch (SQLException ex) {
                String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getCVEDataMeta().getId());
                throw new DatabaseException(msg, ex);
            }
        }
        catch (SQLException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
        return vulnerabilityId;
    }

    private synchronized void updateVulnerabilityUpdateVulnerability(int vulnerabilityId, DefCveItem cve, String description) {
        try (PreparedStatement updateVulnerability = this.prepareStatement(PreparedStatementCveDb.UPDATE_VULNERABILITY);){
            if (updateVulnerability == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.UPDATE_VULNERABILITY));
            }
            updateVulnerability.setString(1, description);
            if (cve.getImpact().getBaseMetricV2() != null) {
                BaseMetricV2 cvssv2 = cve.getImpact().getBaseMetricV2();
                updateVulnerability.setFloat(2, cvssv2.getCvssV2().getBaseScore().floatValue());
                updateVulnerability.setString(3, cvssv2.getCvssV2().getAccessVector().value());
                updateVulnerability.setString(4, cvssv2.getCvssV2().getAccessComplexity().value());
                updateVulnerability.setString(5, cvssv2.getCvssV2().getAuthentication().value());
                updateVulnerability.setString(6, cvssv2.getCvssV2().getConfidentialityImpact().value());
                updateVulnerability.setString(7, cvssv2.getCvssV2().getIntegrityImpact().value());
                updateVulnerability.setString(8, cvssv2.getCvssV2().getAvailabilityImpact().value());
                updateVulnerability.setString(9, cvssv2.getSeverity());
            } else {
                updateVulnerability.setNull(2, 0);
                updateVulnerability.setNull(3, 0);
                updateVulnerability.setNull(4, 0);
                updateVulnerability.setNull(5, 0);
                updateVulnerability.setNull(6, 0);
                updateVulnerability.setNull(7, 0);
                updateVulnerability.setNull(8, 0);
                updateVulnerability.setNull(9, 0);
            }
            if (cve.getImpact().getBaseMetricV3() != null) {
                BaseMetricV3 cvssv3 = cve.getImpact().getBaseMetricV3();
                updateVulnerability.setString(10, cvssv3.getCvssV3().getAttackVector().value());
                updateVulnerability.setString(11, cvssv3.getCvssV3().getAttackComplexity().value());
                updateVulnerability.setString(12, cvssv3.getCvssV3().getPrivilegesRequired().value());
                updateVulnerability.setString(13, cvssv3.getCvssV3().getUserInteraction().value());
                updateVulnerability.setString(14, cvssv3.getCvssV3().getScope().value());
                updateVulnerability.setString(15, cvssv3.getCvssV3().getConfidentialityImpact().value());
                updateVulnerability.setString(16, cvssv3.getCvssV3().getIntegrityImpact().value());
                updateVulnerability.setString(17, cvssv3.getCvssV3().getAvailabilityImpact().value());
                updateVulnerability.setFloat(18, cvssv3.getCvssV3().getBaseScore().floatValue());
                updateVulnerability.setString(19, cvssv3.getCvssV3().getBaseSeverity().value());
            } else {
                updateVulnerability.setNull(10, 0);
                updateVulnerability.setNull(11, 0);
                updateVulnerability.setNull(12, 0);
                updateVulnerability.setNull(13, 0);
                updateVulnerability.setNull(14, 0);
                updateVulnerability.setNull(15, 0);
                updateVulnerability.setNull(16, 0);
                updateVulnerability.setNull(17, 0);
                updateVulnerability.setNull(18, 0);
                updateVulnerability.setNull(19, 0);
            }
            updateVulnerability.setInt(20, vulnerabilityId);
            updateVulnerability.executeUpdate();
        }
        catch (SQLException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    private synchronized void updateVulnerabilityInsertCwe(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (PreparedStatement insertCWE = this.prepareStatement(PreparedStatementCveDb.INSERT_CWE);){
            if (insertCWE == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_CWE));
            }
            insertCWE.setInt(1, vulnerabilityId);
            for (ProblemtypeDatum datum : cve.getCve().getProblemtype().getProblemtypeData()) {
                for (LangString desc : datum.getDescription()) {
                    if (!"en".equals(desc.getLang())) continue;
                    insertCWE.setString(2, desc.getValue());
                    insertCWE.execute();
                }
            }
        }
    }

    private synchronized void updateVulnerabilityDeleteVulnerability(int vulnerabilityId) throws SQLException {
        try (PreparedStatement deleteVulnerability = this.prepareStatement(PreparedStatementCveDb.DELETE_VULNERABILITY);){
            deleteVulnerability.setInt(1, vulnerabilityId);
            deleteVulnerability.executeUpdate();
        }
    }

    private synchronized void updateVulnerabilityInsertSoftware(int vulnerabilityId, String cveId, List<VulnerableSoftware> software, String baseEcosystem) throws DatabaseException, SQLException {
        try (PreparedStatement insertCpe = this.prepareStatement(PreparedStatementCveDb.INSERT_CPE);
             PreparedStatement selectCpeId = this.prepareStatement(PreparedStatementCveDb.SELECT_CPE_ID);
             PreparedStatement insertSoftware = this.prepareStatement(PreparedStatementCveDb.INSERT_SOFTWARE);){
            if (insertCpe == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_CPE));
            }
            if (selectCpeId == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_CPE_ID));
            }
            if (insertSoftware == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_SOFTWARE));
            }
            for (VulnerableSoftware parsedCpe : software) {
                int cpeProductId = 0;
                selectCpeId.setString(1, parsedCpe.getPart().getAbbreviation());
                selectCpeId.setString(2, parsedCpe.getVendor());
                selectCpeId.setString(3, parsedCpe.getProduct());
                selectCpeId.setString(4, parsedCpe.getVersion());
                selectCpeId.setString(5, parsedCpe.getUpdate());
                selectCpeId.setString(6, parsedCpe.getEdition());
                selectCpeId.setString(7, parsedCpe.getLanguage());
                selectCpeId.setString(8, parsedCpe.getSwEdition());
                selectCpeId.setString(9, parsedCpe.getTargetSw());
                selectCpeId.setString(10, parsedCpe.getTargetHw());
                selectCpeId.setString(11, parsedCpe.getOther());
                try (ResultSet rs = selectCpeId.executeQuery();){
                    if (rs.next()) {
                        cpeProductId = rs.getInt(1);
                    }
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Unable to get primary key for new cpe: " + parsedCpe.toCpe23FS(), ex);
                }
                if (cpeProductId == 0) {
                    insertCpe.setString(1, parsedCpe.getPart().getAbbreviation());
                    insertCpe.setString(2, parsedCpe.getVendor());
                    insertCpe.setString(3, parsedCpe.getProduct());
                    insertCpe.setString(4, parsedCpe.getVersion());
                    insertCpe.setString(5, parsedCpe.getUpdate());
                    insertCpe.setString(6, parsedCpe.getEdition());
                    insertCpe.setString(7, parsedCpe.getLanguage());
                    insertCpe.setString(8, parsedCpe.getSwEdition());
                    insertCpe.setString(9, parsedCpe.getTargetSw());
                    insertCpe.setString(10, parsedCpe.getTargetHw());
                    insertCpe.setString(11, parsedCpe.getOther());
                    String ecosystem = this.determineEcosystem(baseEcosystem, parsedCpe.getVendor(), parsedCpe.getProduct(), parsedCpe.getTargetSw());
                    this.addNullableStringParameter(insertCpe, 12, ecosystem);
                    insertCpe.executeUpdate();
                    cpeProductId = DBUtils.getGeneratedKey(insertCpe);
                }
                if (cpeProductId == 0) {
                    throw new DatabaseException("Unable to retrieve cpeProductId - no data returned");
                }
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setInt(2, cpeProductId);
                this.addNullableStringParameter(insertSoftware, 3, parsedCpe.getVersionEndExcluding());
                this.addNullableStringParameter(insertSoftware, 4, parsedCpe.getVersionEndIncluding());
                this.addNullableStringParameter(insertSoftware, 5, parsedCpe.getVersionStartExcluding());
                this.addNullableStringParameter(insertSoftware, 6, parsedCpe.getVersionStartIncluding());
                insertSoftware.setBoolean(7, parsedCpe.isVulnerable());
                if (this.isBatchInsertEnabled()) {
                    insertSoftware.addBatch();
                    continue;
                }
                try {
                    insertSoftware.execute();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("Duplicate entry")) {
                        String msg = String.format("Duplicate software key identified in '%s'", cveId);
                        LOGGER.info(msg, (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.isBatchInsertEnabled()) {
                this.executeBatch(cveId, insertSoftware);
            }
        }
    }

    private synchronized String updateVulnerabilityInsertReferences(int vulnerabilityId, DefCveItem cve, String baseEcosystem) throws SQLException {
        String ecosystem = baseEcosystem;
        try (PreparedStatement insertReference = this.prepareStatement(PreparedStatementCveDb.INSERT_REFERENCE);){
            if (insertReference == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_REFERENCE));
            }
            int countReferences = 0;
            for (Reference r : cve.getCve().getReferences().getReferenceData()) {
                if (ecosystem == null) {
                    if (r.getUrl().contains("elixir-security-advisories")) {
                        ecosystem = "elixir";
                    } else if (r.getUrl().contains("ruby-lang.org")) {
                        ecosystem = "ruby";
                    } else if (r.getUrl().contains("python.org")) {
                        ecosystem = "python";
                    } else if (r.getUrl().contains("drupal.org")) {
                        ecosystem = "python";
                    } else if (r.getUrl().contains("npm")) {
                        ecosystem = "npm";
                    } else if (r.getUrl().contains("nodejs.org")) {
                        ecosystem = "npm";
                    } else if (r.getUrl().contains("nodesecurity.io")) {
                        ecosystem = "npm";
                    } else if (r.getUrl().contains("rustsec.org")) {
                        ecosystem = "rust";
                    }
                }
                insertReference.setInt(1, vulnerabilityId);
                insertReference.setString(2, r.getName());
                insertReference.setString(3, r.getUrl());
                insertReference.setString(4, r.getRefsource());
                if (this.isBatchInsertEnabled()) {
                    insertReference.addBatch();
                    if (++countReferences % this.getBatchSize() == 0) {
                        insertReference.executeBatch();
                        LOGGER.trace(this.getLogForBatchInserts(countReferences, "Completed %s batch inserts to references table: %s"));
                        countReferences = 0;
                        continue;
                    }
                    if (countReferences != cve.getCve().getReferences().getReferenceData().size()) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(this.getLogForBatchInserts(countReferences, "Completed %s batch inserts to reference table: %s"));
                    }
                    insertReference.executeBatch();
                    countReferences = 0;
                    continue;
                }
                insertReference.execute();
            }
        }
        return ecosystem;
    }

    private List<VulnerableSoftware> parseCpes(DefCveItem cve) throws CpeValidationException {
        ArrayList<VulnerableSoftware> software = new ArrayList<VulnerableSoftware>();
        List<DefCpeMatch> cpeEntries = cve.getConfigurations().getNodes().stream().collect(new NodeFlatteningCollector()).collect(new CpeMatchStreamCollector()).filter(predicate -> predicate.getCpe23Uri().startsWith(this.cpeStartsWithFilter)).filter(entry -> !"CVE-2009-0754".equals(cve.getCve().getCVEDataMeta().getId()) || !"cpe:2.3:a:apache:apache:*:*:*:*:*:*:*:*".equals(entry.getCpe23Uri())).collect(Collectors.toList());
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        try {
            cpeEntries.forEach(entry -> {
                builder.cpe(this.parseCpe((DefCpeMatch)entry, cve.getCve().getCVEDataMeta().getId())).versionEndExcluding(entry.getVersionEndExcluding()).versionStartExcluding(entry.getVersionStartExcluding()).versionEndIncluding(entry.getVersionEndIncluding()).versionStartIncluding(entry.getVersionStartIncluding()).vulnerable(entry.getVulnerable());
                try {
                    software.add(builder.build());
                }
                catch (CpeValidationException ex) {
                    throw new LambdaExceptionWrapper((Exception)((Object)ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (CpeValidationException)ex.getCause();
        }
        return software;
    }

    private Cpe parseCpe(DefCpeMatch cpe, String cveId) throws DatabaseException {
        Cpe parsedCpe;
        try {
            parsedCpe = CpeParser.parse((String)cpe.getCpe23Uri(), (boolean)true);
        }
        catch (CpeParsingException ex) {
            LOGGER.debug("NVD (" + cveId + ") contain an invalid 2.3 CPE: " + cpe.getCpe23Uri());
            if (cpe.getCpe22Uri() != null && !cpe.getCpe22Uri().isEmpty()) {
                try {
                    parsedCpe = CpeParser.parse((String)cpe.getCpe22Uri(), (boolean)true);
                }
                catch (CpeParsingException ex2) {
                    throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
                }
            }
            throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
        }
        return parsedCpe;
    }

    private int getBatchSize() {
        int max;
        try {
            max = this.settings.getInt("database.batchinsert.maxsize");
        }
        catch (InvalidSettingException pE) {
            max = 1000;
        }
        return max;
    }

    private boolean isBatchInsertEnabled() {
        boolean batch;
        try {
            batch = this.settings.getBoolean("database.batchinsert.enabled");
        }
        catch (InvalidSettingException pE) {
            batch = false;
        }
        return batch;
    }

    private String getLogForBatchInserts(int pCountReferences, String pFormat) {
        return String.format(pFormat, pCountReferences, new Date());
    }

    private void executeBatch(String vulnId, PreparedStatement statement) throws SQLException {
        try {
            statement.executeBatch();
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("Duplicate entry")) {
                String msg = String.format("Duplicate software key identified in '%s'", vulnId);
                LOGGER.info(msg, (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean dataExists() {
        ResultSet rs;
        block8: {
            boolean bl;
            PreparedStatement cs;
            block7: {
                rs = null;
                cs = this.getPreparedStatement(PreparedStatementCveDb.COUNT_CPE);
                if (cs != null) break block7;
                LOGGER.error("Unable to validate if data exists in the database");
                boolean bl2 = false;
                DBUtils.closeResultSet(rs);
                return bl2;
            }
            try {
                rs = cs.executeQuery();
                if (!rs.next() || rs.getInt(1) <= 0) break block8;
                bl = true;
            }
            catch (Exception ex) {
                try {
                    String dd;
                    try {
                        dd = this.settings.getDataDirectory().getAbsolutePath();
                    }
                    catch (IOException ex1) {
                        dd = this.settings.getString("data.directory");
                    }
                    LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at http://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, this.settings.getString("odc.application.name")});
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
            }
            DBUtils.closeResultSet(rs);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        return false;
    }

    public synchronized void cleanupDatabase() {
        LOGGER.info("Begin database maintenance");
        long start = System.currentTimeMillis();
        this.clearCache();
        try (PreparedStatement psOrphans = this.getPreparedStatement(PreparedStatementCveDb.CLEANUP_ORPHANS);
             PreparedStatement psEcosystem = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_ECOSYSTEM);
             PreparedStatement psEcosystem2 = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_ECOSYSTEM2);){
            int count;
            if (psEcosystem != null && (count = psEcosystem.executeUpdate()) > 0) {
                LOGGER.info("Updated the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psEcosystem2 != null && (count = psEcosystem2.executeUpdate()) > 0) {
                LOGGER.info("Removed the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psOrphans != null && (count = psOrphans.executeUpdate()) > 0) {
                LOGGER.info("Cleaned up {} orphaned NVD records", (Object)count);
            }
            long millis = System.currentTimeMillis() - start;
            LOGGER.info("End database maintenance ({} ms)", (Object)millis);
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unexpected SQL Exception", ex);
        }
    }

    public synchronized void defrag() {
        if (ConnectionFactory.isH2Connection(this.settings)) {
            long start = System.currentTimeMillis();
            try (CallableStatement psCompaxt = this.connection.prepareCall("SHUTDOWN DEFRAG");){
                if (psCompaxt != null) {
                    LOGGER.info("Begin database defrag");
                    psCompaxt.execute();
                    long millis = System.currentTimeMillis() - start;
                    LOGGER.info("End database defrag ({} ms)", (Object)millis);
                }
            }
            catch (SQLException ex) {
                LOGGER.error("An unexpected SQL Exception occurred compacting the database; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    protected VulnerableSoftware getMatchingSoftware(Cpe cpe, Set<VulnerableSoftware> vulnerableSoftware) {
        VulnerableSoftware matched = null;
        for (VulnerableSoftware vs : vulnerableSoftware) {
            if (!vs.matches((ICpe)cpe)) continue;
            if (matched == null) {
                matched = vs;
                continue;
            }
            if (!"*".equals(vs.getWellFormedUpdate()) || "*".equals(matched.getWellFormedUpdate())) continue;
            matched = vs;
        }
        return matched;
    }

    public synchronized void deleteUnusedCpe() {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("DELETE_UNUSED_DICT_CPE"));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addCpe(String cpe, String vendor, String product) {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("ADD_DICT_CPE"));
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    private void addNullableStringParameter(PreparedStatement ps, int pos, String value) throws SQLException {
        if (value == null || value.isEmpty()) {
            ps.setNull(pos, 12);
        } else {
            ps.setString(pos, value);
        }
    }

    static enum PreparedStatementCveDb {
        CLEANUP_ORPHANS,
        UPDATE_ECOSYSTEM,
        UPDATE_ECOSYSTEM2,
        COUNT_CPE,
        DELETE_REFERENCE,
        DELETE_SOFTWARE,
        DELETE_CWE,
        DELETE_VULNERABILITY,
        INSERT_CPE,
        INSERT_PROPERTY,
        INSERT_CWE,
        INSERT_REFERENCE,
        INSERT_SOFTWARE,
        INSERT_VULNERABILITY,
        MERGE_PROPERTY,
        SELECT_CPE_ENTRIES,
        SELECT_CPE_ID,
        SELECT_CVE_FROM_SOFTWARE,
        SELECT_PROPERTIES,
        SELECT_VULNERABILITY_CWE,
        SELECT_REFERENCES,
        SELECT_SOFTWARE,
        SELECT_VENDOR_PRODUCT_LIST,
        SELECT_VENDOR_PRODUCT_LIST_FOR_NODE,
        SELECT_VULNERABILITY,
        SELECT_VULNERABILITY_ID,
        UPDATE_PROPERTY,
        UPDATE_VULNERABILITY;

    }
}

