/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.pom.Model;

public class DataCacheFactory {
    private static final String CACHE_DIRECTORY = "cache";
    private static final String CACHE_PROPERTIES = "dependencycheck-cache.properties";
    private static Boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCacheFactory(Settings settings) {
        Class<DataCacheFactory> clazz = DataCacheFactory.class;
        synchronized (DataCacheFactory.class) {
            if (!initialized.booleanValue()) {
                File cacheDirectory;
                try {
                    cacheDirectory = new File(settings.getDataDirectory(), CACHE_DIRECTORY);
                }
                catch (IOException ex) {
                    throw new CacheException("Unable to obtain disk cache directory path", (Throwable)ex);
                }
                if (!cacheDirectory.isDirectory() && !cacheDirectory.mkdirs()) {
                    throw new CacheException("Unable to create disk cache: " + cacheDirectory.toString());
                }
                try (InputStream in = FileUtils.getResourceAsStream((String)CACHE_PROPERTIES);){
                    if (in == null) {
                        throw new RuntimeException("Cache properties `dependencycheck-cache.properties` could not be found");
                    }
                    Properties properties = new Properties();
                    properties.load(in);
                    properties.put("jcs.auxiliary.ODC.attributes.DiskPath", cacheDirectory.getCanonicalPath());
                    for (CacheType t : CacheType.values()) {
                        File fp = new File(cacheDirectory, t.toString());
                        properties.put("jcs.auxiliary." + t.toString() + ".attributes.DiskPath", fp.getCanonicalPath());
                    }
                    JCS.setConfigProperties((Properties)properties);
                    initialized = true;
                }
                catch (IOException ex) {
                    throw new CacheException("Error creating disk cache", (Throwable)ex);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DataCache<List<Advisory>> getNodeAuditCache() {
        CompositeCacheAttributes attr = new CompositeCacheAttributes();
        attr.setUseDisk(true);
        attr.setUseLateral(false);
        attr.setUseRemote(false);
        CacheAccess ca = JCS.getInstance((String)"NODEAUDIT", (ICompositeCacheAttributes)attr);
        DataCache<List<Advisory>> dc = new DataCache<List<Advisory>>(ca);
        return dc;
    }

    public DataCache<Model> getPomCache() {
        CompositeCacheAttributes attr = new CompositeCacheAttributes();
        attr.setUseDisk(true);
        attr.setUseLateral(false);
        attr.setUseRemote(false);
        CacheAccess ca = JCS.getInstance((String)"POM", (ICompositeCacheAttributes)attr);
        DataCache<Model> dc = new DataCache<Model>(ca);
        return dc;
    }

    public DataCache<List<MavenArtifact>> getCentralCache() {
        CompositeCacheAttributes attr = new CompositeCacheAttributes();
        attr.setUseDisk(true);
        attr.setUseLateral(false);
        attr.setUseRemote(false);
        CacheAccess ca = JCS.getInstance((String)"CENTRAL", (ICompositeCacheAttributes)attr);
        DataCache<List<MavenArtifact>> dc = new DataCache<List<MavenArtifact>>(ca);
        return dc;
    }

    private static enum CacheType {
        NODEAUDIT,
        CENTRAL,
        POM;

    }
}

