/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.owasp.dependencycheck.data.nvd.json.DefNode;

public class NodeFlatteningCollector
implements Collector<DefNode, ArrayList<DefNode>, Stream<DefNode>> {
    private List<DefNode> flatten(DefNode node) {
        ArrayList<DefNode> result = new ArrayList<DefNode>();
        result.add(node);
        return this.flatten(result, node.getChildren());
    }

    private List<DefNode> flatten(List<DefNode> result, List<DefNode> nodes) {
        nodes.forEach(n -> {
            this.flatten(result, n.getChildren());
            result.add((DefNode)n);
        });
        return result;
    }

    @Override
    public Supplier<ArrayList<DefNode>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<DefNode>, DefNode> accumulator() {
        return (nodes, n) -> nodes.addAll(this.flatten((DefNode)n));
    }

    @Override
    public BinaryOperator<ArrayList<DefNode>> combiner() {
        return (map, other) -> {
            map.addAll(other);
            return map;
        };
    }

    @Override
    public Function<ArrayList<DefNode>, Stream<DefNode>> finisher() {
        return m -> m.stream();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }
}

