/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.golang.GoModJsonParser;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GolangModAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GolangModAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "Golang";
    private static final String ANALYZER_NAME = "Golang Mod Analyzer";
    public static final String GO_MOD = "go.mod";
    private static final FileFilter GO_MOD_FILTER = FileFilterBuilder.newInstance().addFilenames("go.mod").build();

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.golang.mod.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return GO_MOD_FILTER;
    }

    private String getGo() {
        String goPath = this.getSettings().getString("analyzer.golang.path");
        if (goPath == null) {
            LOGGER.warn("Path to `go` executable not set. Trying default location. If you do want to set it, please set the `{}` property", (Object)"analyzer.golang.path");
            return "go";
        }
        File goFile = new File(goPath);
        if (goFile.isFile()) {
            return goFile.getAbsolutePath();
        }
        LOGGER.warn("Path to `go` exec executable does not exist: {}. Trying default location", (Object)goPath);
        return "go";
    }

    private Process launchGoMod(File folder) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGo());
        args.add("mod");
        args.add("edit");
        args.add("-json");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("go initialization failure; this error can be ignored if you are not analyzing Go. Otherwise ensure that go is installed and the path to go is correctly specified", ioe);
        }
    }

    @Override
    @SuppressFBWarnings(justification="The fallthrough is intentional to avoid code duplication", value={"SF_SWITCH_NO_DEFAULT"})
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        int exitValue;
        Process process;
        this.setEnabled(false);
        try {
            process = this.launchGoMod(this.getSettings().getTempDirectory());
        }
        catch (AnalysisException ae) {
            String msg = String.format("Exception from go process: %s. Disabling %s", ae.getCause(), ANALYZER_NAME);
            throw new InitializationException(msg, ae);
        }
        catch (IOException ex) {
            throw new InitializationException("Unable to create temporary file, the Go Mod Analyzer will be disabled", ex);
        }
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ex) {
            String msg = String.format("Go mod process was interrupted. Disabling %s", ANALYZER_NAME);
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        boolean expectedNoModuleFoundExitValue = true;
        int possiblyGoTooOldExitValue = 2;
        int goExecutableNotFoundExitValue = 127;
        switch (exitValue) {
            case 1: {
                this.setEnabled(true);
                LOGGER.info("{} is enabled.", (Object)ANALYZER_NAME);
                return;
            }
            case 127: {
                throw new InitializationException(String.format("Go executable not found. Disabling %s: %s", ANALYZER_NAME, exitValue));
            }
            case 2: {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                    if (!reader.ready()) {
                        LOGGER.warn("Go mod error stream unexpectedly not ready. Disabling {}", (Object)ANALYZER_NAME);
                        throw new InitializationException("Go mod error stream unexpectedly not ready.");
                    }
                    String line = reader.readLine();
                    if (line == null) {
                        LOGGER.warn("An error occurred calling `go` - no output could be read. Disabling {}.", (Object)ANALYZER_NAME);
                        throw new InitializationException("Error calling `go` - no output could be read.");
                    }
                    if (line.contains("unknown subcommand \"mod\"")) {
                        LOGGER.warn("Your version of `go` does not support modules. Disabling {}. Error: `{}`", (Object)ANALYZER_NAME, (Object)line);
                        throw new InitializationException("Go version does not support modules.");
                    }
                    break;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new InitializationException("Unexpected go encoding.", ex);
                }
                catch (IOException ex) {
                    throw new InitializationException("Unable to read go output.", ex);
                }
            }
        }
        String msg = String.format("Unexpected exit code from go process. Disabling %s: %s", ANALYZER_NAME, exitValue);
        throw new InitializationException(msg);
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        int exitValue;
        File parentFile = dependency.getActualFile().getParentFile();
        Process process = this.launchGoMod(parentFile);
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("go process interrupted", ie);
        }
        if (exitValue < 0 || exitValue > 1) {
            String msg = String.format("Unexpected exit code from go process; exit code: %s", exitValue);
            throw new AnalysisException(msg);
        }
        try {
            StringBuilder error = new StringBuilder();
            try (BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                while (errReader.ready()) {
                    error.append(errReader.readLine());
                }
            }
            if (!error.toString().equals("")) {
                LOGGER.warn(error.toString());
                throw new AnalysisException(error.toString());
            }
            GoModJsonParser parser = new GoModJsonParser(process.getInputStream());
            parser.process();
            parser.getDependencies().forEach(goDep -> engine.addDependency(goDep.toDependency(dependency)));
        }
        catch (IOException ioe) {
            LOGGER.warn("go mod failure", (Throwable)ioe);
        }
    }
}

