/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import java.io.IOException;
import java.io.StringReader;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Properties;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;

public class MetaProperties {
    private String sha256;
    private long lastModifiedDate;
    private long size;
    private long zipSize;
    private long gzSize;

    public long getGzSize() {
        return this.gzSize;
    }

    public long getZipSize() {
        return this.zipSize;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getSha256() {
        return this.sha256;
    }

    public MetaProperties(String contents) throws InvalidDataException {
        Properties properties = new Properties();
        try (StringReader r = new StringReader(contents);){
            properties.load(r);
        }
        catch (IOException ex) {
            throw new InvalidDataException("Unable to parse meta file data", ex);
        }
        this.sha256 = properties.getProperty("sha256");
        try {
            String date = properties.getProperty("lastModifiedDate");
            if (date == null) {
                throw new InvalidDataException("lastModifiedDate not found in meta file");
            }
            this.lastModifiedDate = ZonedDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toEpochSecond();
        }
        catch (DateTimeParseException ex) {
            throw new InvalidDataException("Meta file lastModifiedDate cannot be parsed: " + properties.getProperty("lastModifiedDate"), ex);
        }
        try {
            this.zipSize = Long.parseLong(properties.getProperty("zipSize"));
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Meta file zip size cannot be parsed: " + properties.getProperty("zipSize"), ex);
        }
        try {
            this.gzSize = Long.parseLong(properties.getProperty("gzSize"));
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Meta file gz size cannot be parsed: " + properties.getProperty("gzSize"), ex);
        }
        try {
            this.size = Long.parseLong(properties.getProperty("size"));
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Meta file size cannot be parsed: " + properties.getProperty("size"), ex);
        }
    }
}

