/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.owasp.dependencycheck.data.cwe.CweDB;

public class CweSet
implements Serializable {
    private static final long serialVersionUID = 7884812602736995362L;
    private final Set<String> cwes = new HashSet<String>();

    public Set<String> getEntries() {
        return this.cwes;
    }

    public void addCwe(String cwe) {
        this.cwes.add(cwe);
    }

    public String toString() {
        return this.cwes.stream().map(cwe -> CweDB.getFullName(cwe)).collect(Collectors.joining(", "));
    }

    public Stream<String> stream() {
        return this.cwes.stream();
    }

    public Map<String, String> getFullCwes() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.cwes.forEach(cwe -> map.put((String)cwe, CweDB.getName(cwe)));
        return map;
    }
}

