/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvd.json.MetaProperties;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.data.update.nvd.UpdateableNvdCve;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.HttpResourceConnection;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NvdCveUpdater
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveUpdater.class);
    private static final int PROCESSING_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private static final int DOWNLOAD_THREAD_POOL_SIZE = Math.round(1.5f * (float)Runtime.getRuntime().availableProcessors());
    private ExecutorService processingExecutorService = null;
    private ExecutorService downloadExecutorService = null;
    private Settings settings;
    private CveDB cveDb = null;
    private DatabaseProperties dbProperties = null;

    @Override
    public synchronized boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        this.cveDb = engine.getDatabase();
        if (this.isUpdateConfiguredFalse()) {
            return false;
        }
        boolean updatesMade = false;
        try {
            this.dbProperties = this.cveDb.getDatabaseProperties();
            if (this.checkUpdate()) {
                UpdateableNvdCve updateable = this.getUpdatesNeeded();
                if (updateable.isUpdateNeeded()) {
                    this.initializeExecutorServices();
                    this.performUpdate(updateable);
                    updatesMade = true;
                }
                this.dbProperties.save("NVD CVE Checked", Long.toString(System.currentTimeMillis()));
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("NVD CVE properties files contain an invalid URL, unable to update the data to use the most current data.", ex);
        }
        catch (DownloadFailedException ex) {
            String jre;
            LOGGER.warn("Unable to download the NVD CVE data; the results may not include the most recent CPE/CVEs from the NVD.");
            if (this.settings.getString("proxy.server") == null) {
                LOGGER.warn("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
            }
            if ((jre = System.getProperty("java.version")) == null || jre.startsWith("1.4") || jre.startsWith("1.5") || jre.startsWith("1.6") || jre.startsWith("1.7")) {
                LOGGER.warn("An old JRE is being used ({} {}), and likely does not have the correct root certificates or algorithms to connect to the NVD - consider upgrading your JRE.", (Object)System.getProperty("java.vendor"), (Object)jre);
            }
            throw new UpdateException("Unable to download the NVD CVE data.", ex);
        }
        catch (DatabaseException ex) {
            throw new UpdateException("Database Exception, unable to update the data to use the most current data.", ex);
        }
        finally {
            this.shutdownExecutorServices();
        }
        return updatesMade;
    }

    private boolean isUpdateConfiguredFalse() {
        try {
            if (!this.settings.getBoolean("updater.nvdcve.enabled", true)) {
                return true;
            }
        }
        catch (InvalidSettingException ex) {
            LOGGER.trace("invalid setting UPDATE_NVDCVE_ENABLED", (Throwable)ex);
        }
        boolean autoUpdate = true;
        try {
            autoUpdate = this.settings.getBoolean("autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
        }
        return !autoUpdate;
    }

    protected void initializeExecutorServices() {
        int max = this.settings.getInt("max.download.threads", 3);
        int downloadPoolSize = DOWNLOAD_THREAD_POOL_SIZE > max ? max : DOWNLOAD_THREAD_POOL_SIZE;
        this.downloadExecutorService = Executors.newFixedThreadPool(downloadPoolSize);
        this.processingExecutorService = Executors.newFixedThreadPool(PROCESSING_THREAD_POOL_SIZE);
        LOGGER.debug("#download   threads: {}", (Object)downloadPoolSize);
        LOGGER.debug("#processing threads: {}", (Object)PROCESSING_THREAD_POOL_SIZE);
    }

    private void shutdownExecutorServices() {
        if (this.processingExecutorService != null) {
            this.processingExecutorService.shutdownNow();
        }
        if (this.downloadExecutorService != null) {
            this.downloadExecutorService.shutdownNow();
        }
    }

    private boolean checkUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = this.settings.getInt("cve.check.validforhours", 0);
        if (this.dataExists() && 0 < validForHours) {
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            long lastChecked = Long.parseLong(this.dbProperties.getProperty("NVD CVE Checked", "0"));
            long now = System.currentTimeMillis();
            boolean bl = proceed = now - lastChecked > msValid;
            if (!proceed) {
                LOGGER.info("Skipping NVD check since last check was within {} hours.", (Object)validForHours);
                LOGGER.debug("Last NVD was at {}, and now {} is within {} ms.", new Object[]{lastChecked, now, msValid});
            }
        }
        return proceed;
    }

    private boolean dataExists() {
        return this.cveDb.dataExists();
    }

    private void performUpdate(UpdateableNvdCve updateable) throws UpdateException {
        int maxUpdates = 0;
        for (NvdCveInfo cve : updateable) {
            if (!cve.getNeedsUpdate()) continue;
            ++maxUpdates;
        }
        if (maxUpdates <= 0) {
            return;
        }
        if (maxUpdates > 3) {
            LOGGER.info("NVD CVE requires several updates; this could take a couple of minutes.");
        }
        DownloadTask runLast = null;
        HashSet<Future<Future<ProcessTask>>> downloadFutures = new HashSet<Future<Future<ProcessTask>>>(maxUpdates);
        for (Object cve : updateable) {
            if (!((NvdCveInfo)cve).getNeedsUpdate()) continue;
            DownloadTask downloadTask = new DownloadTask((NvdCveInfo)cve, this.processingExecutorService, this.cveDb, this.settings);
            if (downloadTask.isModified()) {
                runLast = downloadTask;
                continue;
            }
            boolean added = downloadFutures.add(this.downloadExecutorService.submit(downloadTask));
            if (added) continue;
            throw new UpdateException("Unable to add the download task for " + ((NvdCveInfo)cve).getId());
        }
        HashSet<Future> processFutures = new HashSet<Future>(maxUpdates);
        for (Future future : downloadFutures) {
            try {
                Future task = (Future)future.get();
                if (task == null) continue;
                processFutures.add(task);
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException("The download was interrupted", ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
                throw new UpdateException("The execution of the download was interrupted", ex);
            }
        }
        for (Future future : processFutures) {
            try {
                ProcessTask task = (ProcessTask)future.get();
                if (task.getException() == null) continue;
                throw task.getException();
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during processing", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Execution Exception during process", (Throwable)ex);
                throw new UpdateException(ex);
            }
        }
        if (runLast != null) {
            Future<Future<ProcessTask>> modified = this.downloadExecutorService.submit(runLast);
            try {
                Future<ProcessTask> future = modified.get();
                ProcessTask last = future.get();
                if (last.getException() != null) {
                    throw last.getException();
                }
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException("The download was interrupted", ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
                throw new UpdateException("The execution of the download was interrupted", ex);
            }
        }
        this.dbProperties.save(updateable.get("Modified"));
        this.cveDb.cleanupDatabase();
    }

    protected final MetaProperties getMetaFile(String url) throws UpdateException {
        try {
            String metaUrl = url.substring(0, url.length() - 7) + "meta";
            URL u = new URL(metaUrl);
            Downloader d = new Downloader(this.settings);
            String content = d.fetchContent(u, true);
            return new MetaProperties(content);
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("Meta file url is invalid: " + url, ex);
        }
        catch (InvalidDataException ex) {
            throw new UpdateException("Meta file content is invalid: " + url, ex);
        }
        catch (DownloadFailedException ex) {
            throw new UpdateException("Unable to download meta file: " + url, ex);
        }
    }

    protected final UpdateableNvdCve getUpdatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        UpdateableNvdCve updates;
        block9: {
            LOGGER.debug("starting getUpdatesNeeded() ...");
            updates = new UpdateableNvdCve();
            if (this.dbProperties != null && !this.dbProperties.isEmpty()) {
                try {
                    int startYear = this.settings.getInt("cve.startyear", 2002);
                    int endYear = Calendar.getInstance().get(1);
                    boolean needsFullUpdate = false;
                    for (int y = startYear; y <= endYear; ++y) {
                        long val = Long.parseLong(this.dbProperties.getProperty("NVD CVE " + y, "0"));
                        if (val != 0L) continue;
                        needsFullUpdate = true;
                        break;
                    }
                    long lastUpdated = Long.parseLong(this.dbProperties.getProperty("NVD CVE Modified", "0"));
                    long now = System.currentTimeMillis();
                    int days = this.settings.getInt("cve.url.modified.validfordays", 7);
                    String url = this.settings.getString("cve.url.modified");
                    MetaProperties modified = this.getMetaFile(url);
                    if (!needsFullUpdate && lastUpdated == modified.getLastModifiedDate()) {
                        return updates;
                    }
                    updates.add("Modified", url, modified.getLastModifiedDate(), true);
                    if (!needsFullUpdate && DateUtil.withinDateRange(lastUpdated, now, days)) break block9;
                    int start = this.settings.getInt("cve.startyear");
                    int end = Calendar.getInstance().get(1);
                    String baseUrl = this.settings.getString("cve.url.base");
                    for (int i = start; i <= end; ++i) {
                        url = String.format(baseUrl, i);
                        MetaProperties meta = this.getMetaFile(url);
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(this.dbProperties.getProperty("NVD CVE " + i, "0"));
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.debug("Error parsing '{}' '{}' from nvdcve.lastupdated", new Object[]{"NVD CVE ", i, ex});
                        }
                        if (currentTimestamp >= meta.getLastModifiedDate()) continue;
                        updates.add(Integer.toString(i), url, meta.getLastModifiedDate(), true);
                    }
                }
                catch (NumberFormatException ex) {
                    LOGGER.warn("An invalid schema version or timestamp exists in the data.properties file.");
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (InvalidSettingException ex) {
                    throw new UpdateException("The NVD CVE start year property is set to an invalid value", ex);
                }
            }
        }
        return updates;
    }

    @SuppressFBWarnings(justification="This is only called from within a synchronized method", value={"IS2_INCONSISTENT_SYNC"})
    private Map<String, Long> retrieveLastModifiedDates(int startYear, int endYear) throws MalformedURLException, DownloadFailedException {
        HashSet<String> urls = new HashSet<String>();
        String baseUrl = this.settings.getString("cve.url.base");
        for (int i = startYear; i <= endYear; ++i) {
            String url2 = String.format(baseUrl, i);
            urls.add(url2);
        }
        urls.add(this.settings.getString("cve.url.modified"));
        HashMap timestampFutures = new HashMap();
        urls.forEach(url -> {
            TimestampRetriever timestampRetriever = new TimestampRetriever((String)url, this.settings);
            Future<Long> future = this.downloadExecutorService.submit(timestampRetriever);
            timestampFutures.put(url, future);
        });
        HashMap<String, Long> lastModifiedDates = new HashMap<String, Long>();
        for (String url3 : urls) {
            long timestamp;
            Future timestampFuture = (Future)timestampFutures.get(url3);
            try {
                timestamp = (Long)timestampFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DownloadFailedException((Throwable)e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new DownloadFailedException((Throwable)e);
            }
            lastModifiedDates.put(url3, timestamp);
        }
        return lastModifiedDates;
    }

    protected synchronized void setSettings(Settings settings) {
        this.settings = settings;
    }

    private static class TimestampRetriever
    implements Callable<Long> {
        private final Settings settings;
        private final String url;

        TimestampRetriever(String url, Settings settings) {
            this.url = url;
            this.settings = settings;
        }

        @Override
        public Long call() throws Exception {
            LOGGER.debug("Checking for updates from: {}", (Object)this.url);
            try {
                HttpResourceConnection resource = new HttpResourceConnection(this.settings);
                Long l = resource.getLastModified(new URL(this.url));
                return l;
            }
            finally {
                this.settings.cleanup(false);
            }
        }
    }
}

