/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency.naming;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class CpeIdentifier
implements Identifier {
    private static final long serialVersionUID = 2901855131887281680L;
    private final Cpe cpe;
    private Confidence confidence;
    private String url;
    private String notes;

    public CpeIdentifier(Cpe cpe, Confidence confidence) {
        this.cpe = cpe;
        this.confidence = confidence;
        this.url = null;
    }

    public CpeIdentifier(Cpe cpe, String url, Confidence confidence) {
        this.cpe = cpe;
        this.confidence = confidence;
        this.url = url;
    }

    public CpeIdentifier(String vendor, String product, String version, Confidence confidence) throws CpeValidationException {
        CpeBuilder builder = new CpeBuilder();
        this.cpe = builder.part(Part.APPLICATION).vendor(vendor).product(product).version(version).build();
        this.confidence = confidence;
    }

    public Cpe getCpe() {
        return this.cpe;
    }

    @Override
    public Confidence getConfidence() {
        return this.confidence;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String getValue() {
        return this.cpe.toCpe23FS();
    }

    public String toString() {
        return this.cpe.toCpe23FS();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cpe).append((Object)this.confidence).append((Object)this.url).append((Object)this.notes).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CpeIdentifier)) {
            return false;
        }
        CpeIdentifier other = (CpeIdentifier)obj;
        return new EqualsBuilder().append((Object)this.cpe, (Object)other.cpe).append((Object)this.confidence, (Object)other.confidence).append((Object)this.url, (Object)other.url).append((Object)this.notes, (Object)other.notes).isEquals();
    }

    @Override
    public int compareTo(Identifier o) {
        if (o instanceof CpeIdentifier) {
            CpeIdentifier other = (CpeIdentifier)o;
            return new CompareToBuilder().append((Object)this.cpe, (Object)other.cpe).append((Object)this.url, (Object)other.getUrl()).append((Object)this.confidence, (Object)other.getConfidence()).toComparison();
        }
        return new CompareToBuilder().append((Object)this.toString(), (Object)o.toString()).append((Object)this.url, (Object)o.getUrl()).append((Object)this.confidence, (Object)o.getConfidence()).toComparison();
    }
}

