/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.owasp.dependencycheck.data.nvd.json.CVEItem;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NvdCveParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveParser.class);
    private final CveDB cveDB;
    private final String cpeStartsWithFilter;

    public NvdCveParser(Settings settings, CveDB db) {
        this.cpeStartsWithFilter = settings.getString("cve.cpe.startswith.filter", "cpe:2.3:a:");
        this.cveDB = db;
    }

    public void parse(File file) throws UpdateException {
        LOGGER.debug("Parsing " + file.getName());
        try (FileInputStream fin = new FileInputStream(file);
             GZIPInputStream in = new GZIPInputStream(fin);
             InputStreamReader isr = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             JsonReader reader = new JsonReader((Reader)isr);){
            Gson gson = new GsonBuilder().create();
            reader.beginObject();
            while (reader.hasNext() && !JsonToken.BEGIN_ARRAY.equals((Object)reader.peek())) {
                reader.skipValue();
            }
            reader.beginArray();
            while (reader.hasNext()) {
                CVEItem cve = (CVEItem)gson.fromJson(reader, CVEItem.class);
                if (!this.testCveCpeStartWithFilter(cve)) continue;
                this.cveDB.updateVulnerability(cve);
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error(ex.getMessage());
            throw new UpdateException("Unable to find the NVD CPE file, `" + file + "`, to parse", ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error reading NVD JSON data: {}", (Object)file);
            LOGGER.debug("Error extracting the NVD JSON data from: " + file.toString(), (Throwable)ex);
            throw new UpdateException("Unable to find the NVD CPE file to parse", ex);
        }
    }

    protected boolean testCveCpeStartWithFilter(CVEItem cve) {
        return cve.getConfigurations().getNodes().stream().collect(new NodeFlatteningCollector()).collect(new CpeMatchStreamCollector()).anyMatch(cpe -> cpe.getCpe23Uri().startsWith(this.cpeStartsWithFilter));
    }
}

