/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.owasp.dependencycheck.data.lucene.AbstractTokenizingFilter;

public final class AlphaNumericFilter
extends AbstractTokenizingFilter {
    private final PositionIncrementAttribute posIncrAttribute = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private int skipCounter;

    public AlphaNumericFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        ArrayDeque<String> tokens = this.getTokens();
        CharTermAttribute termAtt = this.getTermAtt();
        if (tokens.isEmpty()) {
            this.skipCounter = 0;
            while (this.input.incrementToken()) {
                String text = new String(termAtt.buffer(), 0, termAtt.length());
                if (text.isEmpty()) {
                    return true;
                }
                String[] parts = text.split("[^a-zA-Z0-9]");
                if (parts.length == 0) {
                    this.skipCounter += this.posIncrAttribute.getPositionIncrement();
                    continue;
                }
                if (this.skipCounter != 0) {
                    this.posIncrAttribute.setPositionIncrement(this.posIncrAttribute.getPositionIncrement() + this.skipCounter);
                }
                for (String part : parts) {
                    if (part.isEmpty()) continue;
                    tokens.add(part);
                }
            }
        }
        return this.addTerm();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.skipCounter = 0;
    }

    public void end() throws IOException {
        super.end();
        this.posIncrAttribute.setPositionIncrement(this.posIncrAttribute.getPositionIncrement() + this.skipCounter);
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 27).appendSuper(super.hashCode()).append((Object)this.posIncrAttribute).append(this.skipCounter).build();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AlphaNumericFilter rhs = (AlphaNumericFilter)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.skipCounter, rhs.skipCounter).append((Object)this.posIncrAttribute, (Object)rhs.posIncrAttribute).isEquals();
    }
}

