/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@ThreadSafe
public class IndexEntry
implements Serializable {
    private static final long serialVersionUID = 8011924485946326934L;
    private String vendor;
    private int documentId;
    private String product;
    private float searchScore;

    public int getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(int documentId) {
        this.documentId = documentId;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public float getSearchScore() {
        return this.searchScore;
    }

    public void setSearchScore(float searchScore) {
        this.searchScore = searchScore;
    }

    public void parseName(String cpeName) throws UnsupportedEncodingException {
        String cpeNameWithoutPrefix;
        String[] data;
        if (cpeName != null && cpeName.length() > 7 && (data = StringUtils.split((String)(cpeNameWithoutPrefix = cpeName.substring(7)), (char)':')).length >= 1) {
            this.vendor = URLDecoder.decode(data[0].replace("+", "%2B"), StandardCharsets.UTF_8.name());
            if (data.length >= 2) {
                this.product = URLDecoder.decode(data[1].replace("+", "%2B"), StandardCharsets.UTF_8.name());
            }
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 27).appendSuper(super.hashCode()).append(this.documentId).append((Object)this.vendor).append((Object)this.product).append(this.searchScore).build();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexEntry)) {
            return false;
        }
        IndexEntry other = (IndexEntry)obj;
        if (this.vendor == null ? other.vendor != null : !this.vendor.equals(other.vendor)) {
            return false;
        }
        return !(this.product != null ? !this.product.equals(other.product) : other.product != null);
    }

    public String toString() {
        return "IndexEntry{vendor=" + this.vendor + ", product=" + this.product + "', score=" + this.searchScore + "}";
    }
}

