/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ThreadSafe
public class AssemblyAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String ANALYZER_NAME = "Assembly Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"dll", "exe"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(SUPPORTED_EXTENSIONS).build();
    private File grokAssemblyExe = null;
    private File grokAssemblyConfig = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(AssemblyAnalyzer.class);

    protected List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (!SystemUtils.IS_OS_WINDOWS) {
            if (this.getSettings().getString("analyzer.assembly.mono.path") != null) {
                args.add(this.getSettings().getString("analyzer.assembly.mono.path"));
            } else if (this.isInPath("mono")) {
                args.add("mono");
            } else {
                return null;
            }
        }
        args.add(this.grokAssemblyExe.getPath());
        return args;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File test = new File(dependency.getActualFilePath());
        if (!test.isFile()) {
            throw new AnalysisException(String.format("%s does not exist and cannot be analyzed by dependency-check", dependency.getActualFilePath()));
        }
        if (this.grokAssemblyExe == null) {
            LOGGER.warn("GrokAssembly didn't get deployed");
            return;
        }
        List<String> args = this.buildArgumentList();
        if (args == null) {
            LOGGER.warn("Assembly Analyzer was unable to execute");
            return;
        }
        args.add(dependency.getActualFilePath());
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            String product;
            String vendor;
            int rc;
            Process proc = pb.start();
            DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
            Document doc = builder.parse(proc.getInputStream());
            String errorStream = IOUtils.toString((InputStream)proc.getErrorStream(), (Charset)StandardCharsets.UTF_8);
            if (null != errorStream && !errorStream.isEmpty()) {
                LOGGER.warn("Error from GrokAssembly: {}", (Object)errorStream);
            }
            try {
                rc = proc.waitFor();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            if (rc == 3) {
                LOGGER.debug("{} is not a .NET assembly or executable and as such cannot be analyzed by dependency-check", (Object)dependency.getActualFilePath());
                return;
            }
            if (rc != 0) {
                LOGGER.debug("Return code {} from GrokAssembly; dependency-check is unable to analyze the library: {}", (Object)rc, (Object)dependency.getActualFilePath());
                return;
            }
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (error != null && !error.isEmpty()) {
                throw new AnalysisException(error);
            }
            String version = xpath.evaluate("/assembly/version", doc);
            if (version != null) {
                dependency.addEvidence(EvidenceType.VERSION, "grokassembly", "version", version, Confidence.HIGHEST);
            }
            if ((vendor = xpath.evaluate("/assembly/company", doc)) != null) {
                dependency.addEvidence(EvidenceType.VENDOR, "grokassembly", "vendor", vendor, Confidence.HIGH);
            }
            if ((product = xpath.evaluate("/assembly/product", doc)) != null) {
                dependency.addEvidence(EvidenceType.PRODUCT, "grokassembly", "product", product, Confidence.HIGH);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new AnalysisException("Error initializing the assembly analyzer", pce);
        }
        catch (IOException | XPathExpressionException ioe) {
            throw new AnalysisException(ioe);
        }
        catch (SAXException saxe) {
            LOGGER.error("----------------------------------------------------");
            LOGGER.error("Failed to read the Assembly Analyzer results. On some systems mono-runtime and mono-devel need to be installed.");
            LOGGER.error("----------------------------------------------------");
            throw new AnalysisException("Couldn't parse Assembly Analyzer results (GrokAssembly)", saxe);
        }
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        File cfgFile;
        File tempFile;
        try {
            tempFile = File.createTempFile("GKA", ".exe", this.getSettings().getTempDirectory());
            cfgFile = new File(tempFile.getPath() + ".config");
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create temporary file for the assembly analyzer", ex);
        }
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             InputStream is = FileUtils.getResourceAsStream((String)"GrokAssembly.exe");
             FileOutputStream fosCfg = new FileOutputStream(cfgFile);
             InputStream isCfg = FileUtils.getResourceAsStream((String)"GrokAssembly.exe.config");){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            this.grokAssemblyExe = tempFile;
            LOGGER.debug("Extracted GrokAssembly.exe to {}", (Object)this.grokAssemblyExe.getPath());
            IOUtils.copy((InputStream)isCfg, (OutputStream)fosCfg);
            this.grokAssemblyConfig = cfgFile;
            LOGGER.debug("Extracted GrokAssembly.exe.config to {}", (Object)cfgFile);
        }
        catch (IOException ioe) {
            this.setEnabled(false);
            LOGGER.warn("Could not extract GrokAssembly.exe: {}", (Object)ioe.getMessage());
            throw new InitializationException("Could not extract GrokAssembly.exe", ioe);
        }
        List<String> args = this.buildArgumentList();
        if (args == null) {
            this.setEnabled(false);
            LOGGER.error("----------------------------------------------------");
            LOGGER.error(".NET Assembly Analyzer could not be initialized and at least one 'exe' or 'dll' was scanned. The 'mono' executable could not be found on the path; either disable the Assembly Analyzer or configure the path mono. On some systems mono-runtime and mono-devel need to be installed.");
            LOGGER.error("----------------------------------------------------");
            return;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            Process p = pb.start();
            IOUtils.copy((InputStream)p.getErrorStream(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
            Document doc = builder.parse(p.getInputStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            String error = xpath.evaluate("/assembly/error", doc);
            if (p.waitFor() != 1 || error == null || error.isEmpty()) {
                LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer, please see the log for more details.");
                LOGGER.debug("GrokAssembly.exe is not working properly");
                this.grokAssemblyExe = null;
                this.setEnabled(false);
                throw new InitializationException("Could not execute .NET AssemblyAnalyzer");
            }
        }
        catch (InitializationException e) {
            this.setEnabled(false);
            throw e;
        }
        catch (IOException | InterruptedException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer;\nthis can be ignored unless you are scanning .NET DLLs. Please see the log for more details.");
            LOGGER.debug("Could not execute GrokAssembly {}", (Object)e.getMessage());
            this.setEnabled(false);
            throw new InitializationException("An error occurred with the .NET AssemblyAnalyzer", e);
        }
    }

    @Override
    public void closeAnalyzer() throws Exception {
        try {
            if (this.grokAssemblyExe != null && !this.grokAssemblyExe.delete()) {
                LOGGER.debug("Unable to delete temporary GrokAssembly.exe; attempting delete on exit");
                this.grokAssemblyExe.deleteOnExit();
            }
        }
        catch (SecurityException se) {
            LOGGER.debug("Can't delete temporary GrokAssembly.exe");
            this.grokAssemblyExe.deleteOnExit();
        }
        try {
            if (this.grokAssemblyConfig != null && !this.grokAssemblyConfig.delete()) {
                LOGGER.debug("Unable to delete temporary GrokAssembly.exe.config; attempting delete on exit");
                this.grokAssemblyConfig.deleteOnExit();
            }
        }
        catch (SecurityException se) {
            LOGGER.debug("Can't delete temporary GrokAssembly.exe.config");
            this.grokAssemblyConfig.deleteOnExit();
        }
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.assembly.enabled";
    }

    private boolean isInPath(String file) {
        ProcessBuilder pb = new ProcessBuilder("which", file);
        try {
            Process proc = pb.start();
            int retCode = proc.waitFor();
            if (retCode == 0) {
                return true;
            }
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.debug("Path search failed for " + file, (Throwable)ex);
        }
        return false;
    }
}

