/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AnalysisTask
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysisTask.class);
    private final Analyzer analyzer;
    private final Dependency dependency;
    private final Engine engine;
    private final List<Throwable> exceptions;

    AnalysisTask(Analyzer analyzer, Dependency dependency, Engine engine, List<Throwable> exceptions) {
        this.analyzer = analyzer;
        this.dependency = dependency;
        this.engine = engine;
        this.exceptions = exceptions;
    }

    @Override
    public Void call() {
        if (this.shouldAnalyze()) {
            LOGGER.debug("Begin Analysis of '{}' ({})", (Object)this.dependency.getActualFilePath(), (Object)this.analyzer.getName());
            try {
                this.analyzer.analyze(this.dependency, this.engine);
            }
            catch (AnalysisException ex) {
                LOGGER.warn("An error occurred while analyzing '{}' ({}).", (Object)this.dependency.getActualFilePath(), (Object)this.analyzer.getName());
                LOGGER.debug("", (Throwable)ex);
                this.exceptions.add(ex);
            }
            catch (Throwable ex) {
                LOGGER.warn("An unexpected error occurred during analysis of '{}' ({}): {}", new Object[]{this.dependency.getActualFilePath(), this.analyzer.getName(), ex.getMessage()});
                LOGGER.error("", ex);
                this.exceptions.add(ex);
            }
        }
        return null;
    }

    protected boolean shouldAnalyze() {
        if (this.analyzer instanceof FileTypeAnalyzer) {
            FileTypeAnalyzer fileTypeAnalyzer = (FileTypeAnalyzer)this.analyzer;
            return fileTypeAnalyzer.accept(this.dependency.getActualFile());
        }
        return true;
    }
}

