/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;

@ThreadSafe
public class FileNameAnalyzer
extends AbstractAnalyzer {
    private static final NameFileFilter IGNORED_FILES = new NameFileFilter(new String[]{"__init__.py", "__init__.pyc", "__init__.pyo", "composer.lock", "configure.in", "configure.ac", "Gemfile.lock", "METADATA", "PKG-INFO", "package.json", "packages.config", "Package.swift", "classes.jar", "build.gradle"}, IOCase.INSENSITIVE);
    private static final String ANALYZER_NAME = "File Name Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.filename.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File f = dependency.getActualFile();
        String fileName = FilenameUtils.removeExtension((String)f.getName());
        String ext = FilenameUtils.getExtension((String)f.getName());
        if (!IGNORED_FILES.accept(f) && !"js".equals(ext)) {
            DependencyVersion version = DependencyVersionUtil.parseVersion(fileName);
            String packageName = DependencyVersionUtil.parsePreVersion(fileName);
            if (version != null) {
                if (version.getVersionParts() == null || version.getVersionParts().size() < 2) {
                    dependency.addEvidence(EvidenceType.VERSION, "file", "version", version.toString(), Confidence.MEDIUM);
                } else {
                    dependency.addEvidence(EvidenceType.VERSION, "file", "version", version.toString(), Confidence.HIGHEST);
                }
                dependency.addEvidence(EvidenceType.VERSION, "file", "name", packageName, Confidence.MEDIUM);
            }
            dependency.addEvidence(EvidenceType.PRODUCT, "file", "name", packageName, Confidence.HIGH);
            dependency.addEvidence(EvidenceType.VENDOR, "file", "name", packageName, Confidence.HIGH);
        }
    }
}

