/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.owasp.dependencycheck.utils.H2DBCleanupHook;
import org.owasp.dependencycheck.utils.H2DBShutdownHook;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class H2DBShutdownHookFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2DBShutdownHookFactory.class);

    private H2DBShutdownHookFactory() {
    }

    public static H2DBShutdownHook getHook(Settings settings) {
        try {
            String className = settings.getString("data.h2.shutdownhook", "org.owasp.dependencycheck.utils.H2DBCleanupHook");
            Class<?> type = Class.forName(className);
            return (H2DBShutdownHook)type.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOGGER.debug("Failed to instantiate {}, using default shutdown hook instead", (Throwable)ex);
            return new H2DBCleanupHook();
        }
    }
}

