/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;

@NotThreadSafe
public class Vulnerability
implements Serializable,
Comparable<Vulnerability> {
    private static final long serialVersionUID = 307319490326651052L;
    private String name;
    private String description;
    private Set<Reference> references = new HashSet<Reference>();
    private Set<VulnerableSoftware> vulnerableSoftware = new HashSet<VulnerableSoftware>();
    private String cwe;
    private String unscoredSeverity;
    private float cvssScore;
    private String cvssAccessVector;
    private String cvssAccessComplexity;
    private String cvssAuthentication;
    private String cvssConfidentialityImpact;
    private String cvssIntegrityImpact;
    private String cvssAvailabilityImpact;
    private String matchedCPE;
    private String matchedAllPreviousCPE;
    private String notes;
    private Source source = Source.NVD;

    public Vulnerability() {
    }

    public Vulnerability(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Reference> getReferences() {
        return this.references;
    }

    public List<Reference> getReferences(boolean sorted) {
        ArrayList<Reference> sortedRefs = new ArrayList<Reference>(this.references);
        if (sorted) {
            Collections.sort(sortedRefs);
        }
        return sortedRefs;
    }

    public void setReferences(Set<Reference> references) {
        this.references = references;
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public void addReference(String referenceSource, String referenceName, String referenceUrl) {
        Reference ref = new Reference();
        ref.setSource(referenceSource);
        ref.setName(referenceName);
        ref.setUrl(referenceUrl);
        this.references.add(ref);
    }

    public Set<VulnerableSoftware> getVulnerableSoftware() {
        return this.vulnerableSoftware;
    }

    public List<VulnerableSoftware> getVulnerableSoftware(boolean sorted) {
        ArrayList<VulnerableSoftware> sortedVulnerableSoftware = new ArrayList<VulnerableSoftware>(this.vulnerableSoftware);
        if (sorted) {
            Collections.sort(sortedVulnerableSoftware);
        }
        return sortedVulnerableSoftware;
    }

    public void setVulnerableSoftware(Set<VulnerableSoftware> vulnerableSoftware) {
        this.vulnerableSoftware = vulnerableSoftware;
    }

    public void addVulnerableSoftware(String cpe) {
        this.addVulnerableSoftware(cpe, null);
    }

    public void addVulnerableSoftware(String cpe, String previousVersion) {
        VulnerableSoftware vs = new VulnerableSoftware();
        vs.setCpe(cpe);
        if (previousVersion != null) {
            vs.setPreviousVersion(previousVersion);
        }
        this.updateVulnerableSoftware(vs);
    }

    public void updateVulnerableSoftware(VulnerableSoftware vulnSoftware) {
        if (this.vulnerableSoftware.contains(vulnSoftware)) {
            this.vulnerableSoftware.remove(vulnSoftware);
        }
        this.vulnerableSoftware.add(vulnSoftware);
    }

    public String getCwe() {
        return this.cwe;
    }

    public void setCwe(String cwe) {
        this.cwe = cwe;
    }

    public String getUnscoredSeverity() {
        return this.unscoredSeverity;
    }

    public void setUnscoredSeverity(String unscoredSeverity) {
        this.unscoredSeverity = unscoredSeverity;
    }

    public float getCvssScore() {
        return this.cvssScore;
    }

    public void setCvssScore(float cvssScore) {
        this.cvssScore = cvssScore;
    }

    public String getCvssAccessVector() {
        return this.cvssAccessVector;
    }

    public void setCvssAccessVector(String cvssAccessVector) {
        this.cvssAccessVector = cvssAccessVector;
    }

    public String getCvssAccessComplexity() {
        return this.cvssAccessComplexity;
    }

    public void setCvssAccessComplexity(String cvssAccessComplexity) {
        this.cvssAccessComplexity = cvssAccessComplexity;
    }

    public String getCvssAuthentication() {
        return this.cvssAuthentication;
    }

    public void setCvssAuthentication(String cvssAuthentication) {
        this.cvssAuthentication = cvssAuthentication;
    }

    public String getCvssConfidentialityImpact() {
        return this.cvssConfidentialityImpact;
    }

    public void setCvssConfidentialityImpact(String cvssConfidentialityImpact) {
        this.cvssConfidentialityImpact = cvssConfidentialityImpact;
    }

    public String getCvssIntegrityImpact() {
        return this.cvssIntegrityImpact;
    }

    public void setCvssIntegrityImpact(String cvssIntegrityImpact) {
        this.cvssIntegrityImpact = cvssIntegrityImpact;
    }

    public String getCvssAvailabilityImpact() {
        return this.cvssAvailabilityImpact;
    }

    public void setCvssAvailabilityImpact(String cvssAvailabilityImpact) {
        this.cvssAvailabilityImpact = cvssAvailabilityImpact;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Vulnerability ");
        sb.append(this.name);
        sb.append("\nReferences:\n");
        for (Reference reference : this.getReferences(true)) {
            sb.append("=> ");
            sb.append(reference);
            sb.append("\n");
        }
        sb.append("\nSoftware:\n");
        for (VulnerableSoftware software : this.getVulnerableSoftware(true)) {
            sb.append("=> ");
            sb.append(software);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Vulnerability v) {
        return new CompareToBuilder().append((Object)this.name, (Object)v.name).toComparison();
    }

    public void setMatchedCPE(String cpeId, String previous) {
        this.matchedCPE = cpeId;
        this.matchedAllPreviousCPE = previous;
    }

    public String getMatchedCPE() {
        return this.matchedCPE;
    }

    public String getMatchedAllPreviousCPE() {
        return this.matchedAllPreviousCPE;
    }

    public boolean hasMatchedAllPreviousCPE() {
        return this.matchedAllPreviousCPE != null;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public static enum Source {
        NVD,
        NSP,
        RETIREJS;

    }
}

