/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PomProjectInputStream
extends FilterInputStream {
    private static final byte[] PROJECT = new byte[]{60, 112, 114, 111, 106, 101, 99, 116};
    protected static final int BUFFER_SIZE = 1024;

    public PomProjectInputStream(InputStream in) throws IOException {
        super(new BufferedInputStream(in));
        this.skipToProject();
    }

    private void skipToProject() throws IOException {
        byte[] buffer = new byte[1024];
        super.mark(1024);
        int count = super.read(buffer, 0, 1024);
        int adjustment = 0;
        while (count > 0) {
            int pos = PomProjectInputStream.findSequence(PROJECT, buffer);
            if (pos >= 0) {
                super.reset();
                super.skip(pos - adjustment);
                return;
            }
            super.reset();
            super.skip(PROJECT.length);
            super.mark(1024);
            for (int i = 0; i < PROJECT.length; ++i) {
                buffer[i] = buffer[1024 - PROJECT.length + i];
            }
            adjustment = PROJECT.length;
            count = super.read(buffer, PROJECT.length, 1024 - PROJECT.length);
        }
    }

    private static boolean testRemaining(byte[] sequence, byte[] buffer, int pos) {
        boolean match = true;
        for (int i = 1; i < sequence.length; ++i) {
            if (buffer[pos + i] == sequence[i]) continue;
            match = false;
            break;
        }
        return match;
    }

    protected static int findSequence(byte[] sequence, byte[] buffer) {
        int pos = -1;
        for (int i = 0; i < buffer.length - sequence.length + 1; ++i) {
            if (buffer[i] != sequence[0] || !PomProjectInputStream.testRemaining(sequence, buffer, i)) continue;
            pos = i;
            break;
        }
        return pos;
    }
}

