/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.utils.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Dependency
extends EvidenceCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Dependency.class);
    private String actualFilePath;
    private String filePath;
    private String fileName;
    private String packagePath;
    private String md5sum;
    private String sha1sum;
    private final Set<Identifier> identifiers = new TreeSet<Identifier>();
    private String displayName = null;
    private final Set<Identifier> suppressedIdentifiers = new TreeSet<Identifier>();
    private final Set<Vulnerability> suppressedVulnerabilities = new HashSet<Vulnerability>();
    private String description;
    private String license;
    private final Set<Vulnerability> vulnerabilities = new HashSet<Vulnerability>();
    private final Set<Dependency> relatedDependencies = new HashSet<Dependency>();
    private final Set<String> projectReferences = new HashSet<String>();
    private final List<String> availableVersions = new ArrayList<String>();
    private boolean isVirtual = false;
    private String name;
    private String version;
    private String ecosystem;

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public Dependency() {
    }

    public Dependency(File file) {
        this(file, false);
    }

    public Dependency(File file, boolean isVirtual) {
        this();
        this.isVirtual = isVirtual;
        this.filePath = this.actualFilePath = file.getAbsolutePath();
        this.fileName = file.getName();
        this.packagePath = this.filePath;
        this.determineHashes(file);
    }

    public Dependency(boolean isVirtual) {
        this();
        this.isVirtual = isVirtual;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setActualFilePath(String actualFilePath) {
        this.actualFilePath = actualFilePath;
        if (this.sha1sum == null) {
            File file = new File(this.actualFilePath);
            this.determineHashes(file);
        }
    }

    public String getActualFilePath() {
        return this.actualFilePath;
    }

    public File getActualFile() {
        return new File(this.actualFilePath);
    }

    public void setFilePath(String filePath) {
        if (this.packagePath == null || this.packagePath.equals(this.filePath)) {
            this.packagePath = filePath;
        }
        this.filePath = filePath;
    }

    public void setDisplayFileName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayFileName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.name == null) {
            return this.fileName;
        }
        if (this.version == null) {
            return this.name;
        }
        return this.name + ":" + this.version;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getSha1sum() {
        return this.sha1sum;
    }

    public void setSha1sum(String sha1sum) {
        this.sha1sum = sha1sum;
    }

    public synchronized Set<Identifier> getIdentifiers() {
        return Collections.unmodifiableSet(new HashSet<Identifier>(this.identifiers));
    }

    protected synchronized void addIdentifiers(Set<Identifier> identifiers) {
        this.identifiers.addAll(identifiers);
    }

    public synchronized void addIdentifier(String type, String value, String url) {
        Identifier i = new Identifier(type, value, url);
        this.identifiers.add(i);
    }

    public synchronized void addIdentifier(String type, String value, String url, Confidence confidence) {
        Identifier i = new Identifier(type, value, url);
        i.setConfidence(confidence);
        this.identifiers.add(i);
    }

    public synchronized void removeIdentifier(Identifier i) {
        this.identifiers.remove(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsEvidence(String source, MavenArtifact mavenArtifact, Confidence confidence) {
        if (mavenArtifact.getGroupId() != null && !mavenArtifact.getGroupId().isEmpty()) {
            this.addEvidence(EvidenceType.VENDOR, source, "groupid", mavenArtifact.getGroupId(), confidence);
        }
        if (mavenArtifact.getArtifactId() != null && !mavenArtifact.getArtifactId().isEmpty()) {
            this.addEvidence(EvidenceType.PRODUCT, source, "artifactid", mavenArtifact.getArtifactId(), confidence);
        }
        if (mavenArtifact.getVersion() != null && !mavenArtifact.getVersion().isEmpty()) {
            this.addEvidence(EvidenceType.VERSION, source, "version", mavenArtifact.getVersion(), confidence);
        }
        boolean found = false;
        if (mavenArtifact.getArtifactUrl() != null && !mavenArtifact.getArtifactUrl().isEmpty()) {
            Dependency dependency = this;
            synchronized (dependency) {
                for (Identifier i : this.identifiers) {
                    if (!"maven".equals(i.getType()) || !i.getValue().equals(mavenArtifact.toString())) continue;
                    found = true;
                    i.setConfidence(Confidence.HIGHEST);
                    String url = "http://search.maven.org/#search|ga|1|1%3A%22" + this.getSha1sum() + "%22";
                    i.setUrl(url);
                    LOGGER.debug("Already found identifier {}. Confidence set to highest", (Object)i.getValue());
                    break;
                }
            }
        }
        if (!found && mavenArtifact.getGroupId() != null && mavenArtifact.getArtifactId() != null && mavenArtifact.getVersion() != null) {
            LOGGER.debug("Adding new maven identifier {}", (Object)mavenArtifact);
            this.addIdentifier("maven", mavenArtifact.toString(), mavenArtifact.getArtifactUrl(), Confidence.HIGHEST);
        }
    }

    public synchronized void addIdentifier(Identifier identifier) {
        this.identifiers.add(identifier);
    }

    public synchronized Set<Identifier> getSuppressedIdentifiers() {
        return Collections.unmodifiableSet(new HashSet<Identifier>(this.suppressedIdentifiers));
    }

    public synchronized void addSuppressedIdentifier(Identifier identifier) {
        this.suppressedIdentifiers.add(identifier);
    }

    public synchronized Set<Vulnerability> getVulnerabilities() {
        return this.getVulnerabilities(false);
    }

    public synchronized Set<Vulnerability> getVulnerabilities(boolean sorted) {
        Set<Vulnerability> vulnerabilitySet = sorted ? new TreeSet<Vulnerability>(this.vulnerabilities) : this.vulnerabilities;
        return Collections.unmodifiableSet(vulnerabilitySet);
    }

    public synchronized Set<Vulnerability> getSuppressedVulnerabilities() {
        return this.getSuppressedVulnerabilities(false);
    }

    public synchronized Set<Vulnerability> getSuppressedVulnerabilities(boolean sorted) {
        Set<Vulnerability> vulnerabilitySet = sorted ? new TreeSet<Vulnerability>(this.suppressedVulnerabilities) : this.suppressedVulnerabilities;
        return Collections.unmodifiableSet(vulnerabilitySet);
    }

    public synchronized void addSuppressedVulnerability(Vulnerability vulnerability) {
        this.suppressedVulnerabilities.add(vulnerability);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void determineHashes(File file) {
        String md5 = null;
        String sha1 = null;
        if (this.isVirtual) {
            return;
        }
        try {
            md5 = Checksum.getMD5Checksum((File)file);
            sha1 = Checksum.getSHA1Checksum((File)file);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to read '{}' to determine hashes.", (Object)file.getName());
            LOGGER.debug("", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("Unable to use MD5 or SHA1 checksums.");
            LOGGER.debug("", (Throwable)ex);
        }
        this.setMd5sum(md5);
        this.setSha1sum(sha1);
    }

    public synchronized void addVulnerability(Vulnerability vulnerability) {
        this.vulnerabilities.add(vulnerability);
    }

    public synchronized void addVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities.addAll(vulnerabilities);
    }

    public synchronized void removeVulnerability(Vulnerability v) {
        this.vulnerabilities.remove(v);
    }

    public synchronized Set<Dependency> getRelatedDependencies() {
        return Collections.unmodifiableSet(new HashSet<Dependency>(this.relatedDependencies));
    }

    public synchronized Set<String> getProjectReferences() {
        return Collections.unmodifiableSet(new HashSet<String>(this.projectReferences));
    }

    public synchronized void addProjectReference(String projectReference) {
        this.projectReferences.add(projectReference);
    }

    public synchronized void addAllProjectReferences(Set<String> projectReferences) {
        this.projectReferences.addAll(projectReferences);
    }

    public synchronized void addRelatedDependency(Dependency dependency) {
        if (this == dependency) {
            LOGGER.warn("Attempted to add a circular reference - please post the log file to issue #172 here https://github.com/jeremylong/DependencyCheck/issues/172");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        } else if (!this.relatedDependencies.add(dependency)) {
            LOGGER.debug("Failed to add dependency, likely due to referencing the same file as another dependency in the set.");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        }
    }

    public synchronized void removeRelatedDependencies(Dependency dependency) {
        this.relatedDependencies.remove(dependency);
    }

    public synchronized List<String> getAvailableVersions() {
        return Collections.unmodifiableList(new ArrayList<String>(this.availableVersions));
    }

    public synchronized void addAvailableVersion(String version) {
        this.availableVersions.add(version);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.actualFilePath, (Object)other.actualFilePath).append((Object)this.filePath, (Object)other.filePath).append((Object)this.fileName, (Object)other.fileName).append((Object)this.packagePath, (Object)other.packagePath).append((Object)this.md5sum, (Object)other.md5sum).append((Object)this.sha1sum, (Object)other.sha1sum).append(this.identifiers, other.identifiers).append((Object)this.description, (Object)other.description).append((Object)this.license, (Object)other.license).append(this.vulnerabilities, other.vulnerabilities).append(this.projectReferences, other.projectReferences).append(this.availableVersions, other.availableVersions).append((Object)this.version, (Object)other.version).append((Object)this.ecosystem, (Object)other.ecosystem).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(3, 47).appendSuper(super.hashCode()).append((Object)this.actualFilePath).append((Object)this.filePath).append((Object)this.fileName).append((Object)this.packagePath).append((Object)this.md5sum).append((Object)this.sha1sum).append(this.identifiers).append((Object)this.description).append((Object)this.license).append(this.vulnerabilities).append(this.projectReferences).append(this.availableVersions).append((Object)this.version).append((Object)this.ecosystem).toHashCode();
    }

    @Override
    public String toString() {
        return "Dependency{ fileName='" + this.fileName + "', actualFilePath='" + this.actualFilePath + "', filePath='" + this.filePath + "', packagePath='" + this.packagePath + "'}";
    }

    public synchronized void addSuppressedVulnerabilities(List<Vulnerability> vulns) {
        this.suppressedVulnerabilities.addAll(vulns);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEcosystem() {
        return this.ecosystem;
    }

    public void setEcosystem(String ecosystem) {
        this.ecosystem = ecosystem;
    }
}

